/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.osgi.karaf.managed;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.jboss.arquillian.container.osgi.karaf.managed.KarafManagedContainerConfiguration;
import org.jboss.arquillian.container.osgi.karaf.managed.MBeanProxy;
import org.jboss.arquillian.container.osgi.karaf.managed.ObjectNameFactory;
import org.jboss.arquillian.container.spi.client.container.DeployableContainer;
import org.jboss.arquillian.container.spi.client.container.DeploymentException;
import org.jboss.arquillian.container.spi.client.container.LifecycleException;
import org.jboss.arquillian.container.spi.client.protocol.ProtocolDescription;
import org.jboss.arquillian.container.spi.client.protocol.metadata.JMXContext;
import org.jboss.arquillian.container.spi.client.protocol.metadata.ProtocolMetaData;
import org.jboss.arquillian.container.spi.context.annotation.ContainerScoped;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.osgi.spi.BundleInfo;
import org.jboss.osgi.vfs.AbstractVFS;
import org.jboss.osgi.vfs.VFSUtils;
import org.jboss.osgi.vfs.VirtualFile;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.descriptor.api.Descriptor;
import org.osgi.framework.BundleException;
import org.osgi.jmx.framework.BundleStateMBean;
import org.osgi.jmx.framework.FrameworkMBean;
import org.osgi.jmx.framework.ServiceStateMBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KarafManagedDeployableContainer
implements DeployableContainer<KarafManagedContainerConfiguration> {
    static final Logger LOGGER = LoggerFactory.getLogger((String)KarafManagedDeployableContainer.class.getPackage().getName());
    @Inject
    @ContainerScoped
    private InstanceProducer<MBeanServerConnection> mbeanServerInstance;
    private final Map<String, BundleHandle> deployedBundles = new HashMap<String, BundleHandle>();
    private KarafManagedContainerConfiguration config;
    private FrameworkMBean frameworkMBean;
    private BundleStateMBean bundleStateMBean;
    private ServiceStateMBean serviceStateMBean;
    private Process process;

    public Class<KarafManagedContainerConfiguration> getConfigurationClass() {
        return KarafManagedContainerConfiguration.class;
    }

    public ProtocolDescription getDefaultProtocol() {
        return new ProtocolDescription("jmx-osgi");
    }

    public void setup(KarafManagedContainerConfiguration config) {
        this.config = config;
    }

    public void start() throws LifecycleException {
        MBeanServerConnection mbeanServer = null;
        try {
            mbeanServer = this.getMBeanServerConnection(500L, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException ex) {
            // empty catch block
        }
        if (mbeanServer == null) {
            String karafHome = this.config.getKarafHome();
            if (karafHome == null) {
                throw new IllegalStateException("karafHome cannot be null");
            }
            File karafHomeDir = new File(karafHome);
            if (!karafHomeDir.isDirectory()) {
                throw new IllegalStateException("Not a valid Karaf home dir: " + karafHomeDir);
            }
            String[] envp = new String[]{};
            try {
                this.process = Runtime.getRuntime().exec("bin/karaf", envp, karafHomeDir);
            }
            catch (Exception ex) {
                throw new LifecycleException("Cannot start managed Karaf container", (Throwable)ex);
            }
        }
        try {
            String completeService;
            mbeanServer = this.getMBeanServerConnection(30L, TimeUnit.SECONDS);
            this.mbeanServerInstance.set((Object)mbeanServer);
            ObjectName oname = ObjectNameFactory.create("osgi.core:type=framework,version=1.7,*");
            this.frameworkMBean = this.getMBeanProxy(mbeanServer, oname, FrameworkMBean.class, 30L, TimeUnit.SECONDS);
            oname = ObjectNameFactory.create("osgi.core:type=bundleState,version=1.7,*");
            this.bundleStateMBean = this.getMBeanProxy(mbeanServer, oname, BundleStateMBean.class, 30L, TimeUnit.SECONDS);
            oname = ObjectNameFactory.create("osgi.core:type=serviceState,version=1.7,*");
            this.serviceStateMBean = this.getMBeanProxy(mbeanServer, oname, ServiceStateMBean.class, 30L, TimeUnit.SECONDS);
            this.awaitArquillianBundleActive(30L, TimeUnit.SECONDS);
            Integer beginningStartLevel = this.config.getKarafBeginningStartLevel();
            if (beginningStartLevel != null) {
                this.awaitKarafBeginningStartLevel(beginningStartLevel, 30L, TimeUnit.SECONDS);
            }
            if ((completeService = this.config.getBootstrapCompleteService()) != null) {
                this.awaitBootstrapCompleteService(completeService, 30L, TimeUnit.SECONDS);
            }
        }
        catch (RuntimeException rte) {
            this.process.destroy();
            throw rte;
        }
        catch (Exception ex) {
            this.process.destroy();
            throw new LifecycleException("Cannot start Karaf container", (Throwable)ex);
        }
    }

    public void stop() throws LifecycleException {
        if (this.process != null) {
            this.process.destroy();
        }
    }

    public ProtocolMetaData deploy(Archive<?> archive) throws DeploymentException {
        try {
            BundleHandle handle = this.installBundle(archive);
            this.deployedBundles.put(archive.getName(), handle);
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception ex) {
            throw new DeploymentException("Cannot deploy: " + archive.getName(), (Throwable)ex);
        }
        MBeanServerConnection mbeanServer = (MBeanServerConnection)this.mbeanServerInstance.get();
        return new ProtocolMetaData().addContext((Object)new JMXContext(mbeanServer));
    }

    public void undeploy(Archive<?> archive) throws DeploymentException {
        BundleHandle handle = this.deployedBundles.remove(archive.getName());
        if (handle != null) {
            long bundleId;
            String bundleState = null;
            try {
                bundleId = handle.getBundleId();
                CompositeData bundleType = this.bundleStateMBean.getBundle(bundleId);
                if (bundleType != null) {
                    bundleState = (String)bundleType.get("State");
                }
            }
            catch (IOException e) {
                return;
            }
            if (bundleState != null && !bundleState.equals("UNINSTALLED")) {
                try {
                    bundleId = handle.getBundleId();
                    this.frameworkMBean.uninstallBundle(bundleId);
                }
                catch (IOException ex) {
                    LOGGER.error("Cannot undeploy: " + archive.getName(), (Throwable)ex);
                }
            }
        }
    }

    public void deploy(Descriptor descriptor) throws DeploymentException {
        throw new UnsupportedOperationException();
    }

    public void undeploy(Descriptor descriptor) throws DeploymentException {
        throw new UnsupportedOperationException();
    }

    private MBeanServerConnection getMBeanServerConnection(final long timeout, final TimeUnit unit) throws TimeoutException {
        Callable<MBeanServerConnection> callable = new Callable<MBeanServerConnection>(){

            @Override
            public MBeanServerConnection call() throws Exception {
                IOException lastException = null;
                long timeoutMillis = System.currentTimeMillis() + unit.toMillis(timeout);
                while (System.currentTimeMillis() < timeoutMillis) {
                    try {
                        return KarafManagedDeployableContainer.this.getMBeanServerConnection();
                    }
                    catch (IOException ex) {
                        lastException = ex;
                        Thread.sleep(500L);
                    }
                }
                TimeoutException timeoutException = new TimeoutException();
                timeoutException.initCause(lastException);
                throw timeoutException;
            }
        };
        ExecutorService executor = Executors.newSingleThreadExecutor();
        Future<MBeanServerConnection> future = executor.submit(callable);
        try {
            return future.get(timeout, unit);
        }
        catch (TimeoutException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    private MBeanServerConnection getMBeanServerConnection() throws IOException {
        String[] credentials = new String[]{this.config.getJmxUsername(), this.config.getJmxPassword()};
        Map<String, String[]> env = Collections.singletonMap("jmx.remote.credentials", credentials);
        JMXServiceURL serviceURL = new JMXServiceURL(this.config.getJmxServiceURL());
        JMXConnector connector = JMXConnectorFactory.connect(serviceURL, env);
        return connector.getMBeanServerConnection();
    }

    private <T> T getMBeanProxy(final MBeanServerConnection mbeanServer, final ObjectName oname, final Class<T> type, final long timeout, final TimeUnit unit) throws TimeoutException {
        Callable callable = new Callable<T>(){

            @Override
            public T call() throws Exception {
                Throwable lastException = null;
                long timeoutMillis = System.currentTimeMillis() + unit.toMillis(timeout);
                while (System.currentTimeMillis() < timeoutMillis) {
                    Set<ObjectName> names = mbeanServer.queryNames(oname, null);
                    if (names.size() == 1) {
                        ObjectName instanceName = names.iterator().next();
                        return MBeanProxy.get(mbeanServer, instanceName, type);
                    }
                    Thread.sleep(500L);
                }
                LOGGER.warn("Cannot connect to Karaf", lastException);
                throw new TimeoutException();
            }
        };
        ExecutorService executor = Executors.newSingleThreadExecutor();
        Future future = executor.submit(callable);
        try {
            return future.get(timeout, unit);
        }
        catch (TimeoutException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    private void awaitArquillianBundleActive(long timeout, TimeUnit unit) throws IOException, TimeoutException, InterruptedException {
        String symbolicName = "arquillian-osgi-bundle";
        List<BundleHandle> list = this.listBundles(symbolicName);
        if (list.size() != 1) {
            throw new IllegalStateException("Cannot obtain: " + symbolicName);
        }
        String bundleState = null;
        long bundleId = list.get(0).getBundleId();
        long timeoutMillis = System.currentTimeMillis() + unit.toMillis(timeout);
        while (System.currentTimeMillis() < timeoutMillis) {
            bundleState = this.bundleStateMBean.getState(bundleId);
            if ("ACTIVE".equals(bundleState)) {
                return;
            }
            Thread.sleep(500L);
        }
        throw new TimeoutException("Arquillian bundle [" + bundleId + "] not started: " + bundleState);
    }

    private void awaitKarafBeginningStartLevel(Integer beginningStartLevel, long timeout, TimeUnit unit) throws IOException, TimeoutException, InterruptedException {
        int startLevel = 0;
        long timeoutMillis = System.currentTimeMillis() + unit.toMillis(timeout);
        while (System.currentTimeMillis() < timeoutMillis) {
            startLevel = this.frameworkMBean.getFrameworkStartLevel();
            if (startLevel >= beginningStartLevel) {
                return;
            }
            Thread.sleep(500L);
        }
        throw new TimeoutException("Beginning start level [" + beginningStartLevel + "] not reached: " + startLevel);
    }

    private void awaitBootstrapCompleteService(String serviceName, long timeout, TimeUnit unit) throws TimeoutException, InterruptedException, IOException {
        long timeoutMillis = System.currentTimeMillis() + unit.toMillis(timeout);
        while (System.currentTimeMillis() < timeoutMillis) {
            TabularData list = this.serviceStateMBean.listServices(serviceName, null);
            if (list.size() > 0) {
                return;
            }
            Thread.sleep(500L);
        }
        throw new TimeoutException("Cannot obtain service: " + serviceName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BundleHandle installBundle(Archive<?> archive) throws BundleException, IOException {
        VirtualFile virtualFile = this.toVirtualFile(archive);
        try {
            BundleHandle bundleHandle = this.installBundle(archive.getName(), virtualFile);
            return bundleHandle;
        }
        finally {
            VFSUtils.safeClose((Closeable)virtualFile);
        }
    }

    private VirtualFile toVirtualFile(Archive<?> archive) throws IOException {
        ZipExporter exporter = (ZipExporter)archive.as(ZipExporter.class);
        return AbstractVFS.toVirtualFile((String)archive.getName(), (InputStream)exporter.exportAsInputStream());
    }

    private BundleHandle installBundle(String location, VirtualFile virtualFile) throws BundleException, IOException {
        BundleInfo info = BundleInfo.createBundleInfo((VirtualFile)virtualFile);
        String streamURL = info.getRoot().getStreamURL().toExternalForm();
        long bundleId = this.frameworkMBean.installBundleFromURL(location, streamURL);
        return new BundleHandle(bundleId, info.getSymbolicName());
    }

    private List<BundleHandle> listBundles(String symbolicName) throws IOException {
        ArrayList<BundleHandle> bundleList = new ArrayList<BundleHandle>();
        TabularData listBundles = this.bundleStateMBean.listBundles();
        for (CompositeData bundleType : listBundles.values()) {
            Long bundleId = (Long)bundleType.get("Identifier");
            String auxName = (String)bundleType.get("SymbolicName");
            if (symbolicName != null && !symbolicName.equals(auxName)) continue;
            bundleList.add(new BundleHandle(bundleId, symbolicName));
        }
        return bundleList;
    }

    static class BundleHandle {
        private long bundleId;
        private String symbolicName;

        BundleHandle(long bundleId, String symbolicName) {
            this.bundleId = bundleId;
            this.symbolicName = symbolicName;
        }

        long getBundleId() {
            return this.bundleId;
        }

        String getSymbolicName() {
            return this.symbolicName;
        }

        public String toString() {
            return "[" + this.bundleId + "]" + this.symbolicName;
        }
    }
}

