/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.osgi.karaf.managed;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.jboss.arquillian.container.osgi.jmx.JMXDeployableContainer;
import org.jboss.arquillian.container.osgi.jmx.ObjectNameFactory;
import org.jboss.arquillian.container.osgi.karaf.managed.KarafManagedContainerConfiguration;
import org.jboss.arquillian.container.spi.client.container.LifecycleException;
import org.osgi.jmx.framework.BundleStateMBean;
import org.osgi.jmx.framework.FrameworkMBean;
import org.osgi.jmx.framework.ServiceStateMBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KarafManagedDeployableContainer<T extends KarafManagedContainerConfiguration>
extends JMXDeployableContainer<T> {
    static final Logger _logger = LoggerFactory.getLogger((String)KarafManagedDeployableContainer.class.getPackage().getName());
    private KarafManagedContainerConfiguration config;
    private Process process;

    public Class<T> getConfigurationClass() {
        Class<KarafManagedContainerConfiguration> clazz = KarafManagedContainerConfiguration.class;
        return clazz;
    }

    public void setup(T config) {
        super.setup(config);
        this.config = config;
    }

    public void start() throws LifecycleException {
        MBeanServerConnection mbeanServer = null;
        try {
            mbeanServer = this.getMBeanServerConnection(500L, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
        if (mbeanServer != null && !this.config.isAllowConnectingToRunningServer()) {
            throw new LifecycleException("The server is already running! Managed containers does not support connecting to running server instances due to the possible harmful effect of connecting to the wrong server. Please stop server before running or change to another type of container.\nTo disable this check and allow Arquillian to connect to a running server, set allowConnectingToRunningServer to true in the container configuration");
        }
        if (mbeanServer == null) {
            String[] libs;
            String karafHome = this.config.getKarafHome();
            if (karafHome == null) {
                throw new IllegalStateException("karafHome cannot be null");
            }
            File karafHomeDir = new File(karafHome).getAbsoluteFile();
            if (!karafHomeDir.isDirectory()) {
                throw new IllegalStateException("Not a valid Karaf home dir: " + karafHomeDir);
            }
            String java = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
            _logger.info(String.format("Using java: %s", java));
            ArrayList<String> cmd = new ArrayList<String>();
            cmd.add(java);
            String javaArgs = this.config.getJavaVmArguments();
            if (!javaArgs.contains("-Xmx")) {
                javaArgs = "-Xmx512m " + javaArgs;
            }
            cmd.addAll(Arrays.asList(javaArgs.split("\\s")));
            cmd.add("-Dkaraf.home=" + karafHomeDir);
            cmd.add("-Dkaraf.base=" + karafHomeDir);
            cmd.add("-Dkaraf.etc=" + karafHomeDir + "/etc");
            cmd.add("-Dkaraf.data=" + karafHomeDir + "/data");
            cmd.add("-Dkaraf.instances=" + karafHomeDir + "/instances");
            cmd.add("-Dkaraf.restart.jvm.supported=true");
            cmd.add("-Dkaraf.startLocalConsole=false");
            cmd.add("-Dkaraf.startRemoteShell=false");
            cmd.add("-Djava.io.tmpdir=" + new File(karafHomeDir, "data/tmp"));
            cmd.add("-Djava.util.logging.config.file=" + new File(karafHomeDir, "etc/java.util.logging.properties"));
            cmd.add("-Djava.endorsed.dirs=" + new File(karafHomeDir, "lib/endorsed"));
            StringBuilder classPath = new StringBuilder();
            File karafLibBootDir = new File(karafHomeDir, "lib/boot/");
            for (String lib : libs = karafLibBootDir.list(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".jar");
                }
            })) {
                String separator = classPath.length() > 0 ? File.pathSeparator : "";
                classPath.append(separator).append(new File(karafLibBootDir, lib));
            }
            cmd.add("-classpath");
            cmd.add(classPath.toString());
            cmd.add("org.apache.karaf.main.Main");
            StringBuffer cmdstr = new StringBuffer();
            for (String tok : cmd) {
                cmdstr.append(tok).append(" ");
            }
            _logger.debug("Starting Karaf with: {}", (Object)cmdstr);
            try {
                ProcessBuilder processBuilder = new ProcessBuilder(cmd);
                processBuilder.directory(karafHomeDir);
                processBuilder.redirectErrorStream(true);
                this.process = processBuilder.start();
                new Thread(new ConsoleConsumer()).start();
            }
            catch (Exception ex) {
                throw new LifecycleException("Cannot start managed Karaf container", (Throwable)ex);
            }
            try {
                mbeanServer = this.getMBeanServerConnection(30L, TimeUnit.SECONDS);
            }
            catch (Exception ex) {
                this.destroyKarafProcess();
                throw new LifecycleException("Cannot obtain MBean server connection", (Throwable)ex);
            }
        }
        this.mbeanServerInstance.set((Object)mbeanServer);
        try {
            ObjectName oname = ObjectNameFactory.create((String)"osgi.core:type=framework,*");
            this.frameworkMBean = (FrameworkMBean)this.getMBeanProxy(mbeanServer, oname, FrameworkMBean.class, 30L, TimeUnit.SECONDS);
            oname = ObjectNameFactory.create((String)"osgi.core:type=bundleState,*");
            this.bundleStateMBean = (BundleStateMBean)this.getMBeanProxy(mbeanServer, oname, BundleStateMBean.class, 30L, TimeUnit.SECONDS);
            oname = ObjectNameFactory.create((String)"osgi.core:type=serviceState,*");
            this.serviceStateMBean = (ServiceStateMBean)this.getMBeanProxy(mbeanServer, oname, ServiceStateMBean.class, 30L, TimeUnit.SECONDS);
            this.installArquillianBundle();
            this.awaitArquillianBundleActive(30L, TimeUnit.SECONDS);
            Integer beginningStartLevel = this.config.getKarafBeginningStartLevel();
            if (beginningStartLevel != null) {
                this.awaitBeginningStartLevel(beginningStartLevel, 30L, TimeUnit.SECONDS);
            }
            this.awaitBootstrapCompleteServices();
        }
        catch (RuntimeException rte) {
            this.destroyKarafProcess();
            throw rte;
        }
        catch (Exception ex) {
            this.destroyKarafProcess();
            throw new LifecycleException("Cannot start Karaf container", (Throwable)ex);
        }
    }

    public void stop() throws LifecycleException {
        super.stop();
        this.destroyKarafProcess();
    }

    private void destroyKarafProcess() {
        if (this.process != null) {
            this.process.destroy();
        }
    }

    private class ConsoleConsumer
    implements Runnable {
        private ConsoleConsumer() {
        }

        @Override
        public void run() {
            InputStream stream = KarafManagedDeployableContainer.this.process.getInputStream();
            boolean writeOutput = KarafManagedDeployableContainer.this.config.isOutputToConsole();
            try {
                int num;
                byte[] buf = new byte[32];
                while ((num = stream.read(buf)) != -1) {
                    if (!writeOutput) continue;
                    System.out.write(buf, 0, num);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

