/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.osgi.karaf.remote;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.jboss.arquillian.container.osgi.jmx.JMXDeployableContainer;
import org.jboss.arquillian.container.osgi.karaf.remote.KarafRemoteContainerConfiguration;
import org.jboss.arquillian.container.spi.client.container.LifecycleException;
import org.osgi.jmx.framework.BundleStateMBean;
import org.osgi.jmx.framework.FrameworkMBean;
import org.osgi.jmx.framework.ServiceStateMBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KarafRemoteDeployableContainer<T extends KarafRemoteContainerConfiguration>
extends JMXDeployableContainer<T> {
    static final Logger logger = LoggerFactory.getLogger((String)KarafRemoteDeployableContainer.class.getPackage().getName());

    public Class<T> getConfigurationClass() {
        Class<KarafRemoteContainerConfiguration> clazz = KarafRemoteContainerConfiguration.class;
        return clazz;
    }

    public void setup(T config) {
        super.setup(config);
    }

    public void start() throws LifecycleException {
        MBeanServerConnection mbeanServer = null;
        try {
            mbeanServer = this.getMBeanServerConnection(30L, TimeUnit.SECONDS);
            this.mbeanServerInstance.set((Object)mbeanServer);
        }
        catch (TimeoutException e) {
            throw new LifecycleException("Error connecting to Karaf MBeanServer: ", (Throwable)e);
        }
        try {
            ObjectName oname = new ObjectName("osgi.core:type=framework,*");
            this.frameworkMBean = (FrameworkMBean)this.getMBeanProxy(mbeanServer, oname, FrameworkMBean.class, 30L, TimeUnit.SECONDS);
            oname = new ObjectName("osgi.core:type=bundleState,*");
            this.bundleStateMBean = (BundleStateMBean)this.getMBeanProxy(mbeanServer, oname, BundleStateMBean.class, 30L, TimeUnit.SECONDS);
            oname = new ObjectName("osgi.core:type=serviceState,*");
            this.serviceStateMBean = (ServiceStateMBean)this.getMBeanProxy(mbeanServer, oname, ServiceStateMBean.class, 30L, TimeUnit.SECONDS);
            this.installArquillianBundle();
            this.awaitArquillianBundleActive(30L, TimeUnit.SECONDS);
            this.awaitBootstrapCompleteServices();
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception ex) {
            throw new LifecycleException("Cannot start Karaf container", (Throwable)ex);
        }
    }

    public void stop() throws LifecycleException {
        super.stop();
    }
}

