/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.osgi.jmx;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerInvocationHandler;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.jboss.arquillian.container.osgi.CommonDeployableContainer;
import org.jboss.arquillian.container.osgi.jmx.JMXContainerConfiguration;
import org.jboss.arquillian.container.osgi.jmx.http.SimpleHTTPServer;
import org.jboss.arquillian.container.spi.client.container.DeploymentException;
import org.jboss.arquillian.container.spi.client.container.LifecycleException;
import org.jboss.arquillian.container.spi.client.protocol.ProtocolDescription;
import org.jboss.arquillian.container.spi.client.protocol.metadata.JMXContext;
import org.jboss.arquillian.container.spi.client.protocol.metadata.ProtocolMetaData;
import org.jboss.arquillian.container.spi.context.annotation.ContainerScoped;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.osgi.spi.BundleInfo;
import org.jboss.osgi.vfs.AbstractVFS;
import org.jboss.osgi.vfs.VFSUtils;
import org.jboss.osgi.vfs.VirtualFile;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.descriptor.api.Descriptor;
import org.jboss.shrinkwrap.resolver.api.maven.Maven;
import org.jboss.shrinkwrap.resolver.api.maven.MavenFormatStage;
import org.jboss.shrinkwrap.resolver.api.maven.MavenStrategyStage;
import org.osgi.framework.BundleException;
import org.osgi.jmx.framework.BundleStateMBean;
import org.osgi.jmx.framework.FrameworkMBean;
import org.osgi.jmx.framework.ServiceStateMBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JMXDeployableContainer<T extends JMXContainerConfiguration>
extends CommonDeployableContainer<T> {
    static final Logger logger = LoggerFactory.getLogger((String)JMXDeployableContainer.class.getPackage().getName());
    protected final Map<String, BundleHandle> deployedBundles = new HashMap<String, BundleHandle>();
    private JMXContainerConfiguration config;
    @Inject
    @ContainerScoped
    protected InstanceProducer<MBeanServerConnection> mbeanServerInstance;
    protected FrameworkMBean frameworkMBean;
    protected BundleStateMBean bundleStateMBean;
    protected ServiceStateMBean serviceStateMBean;

    protected JMXContainerConfiguration getContainerConfiguration() {
        return this.config;
    }

    public ProtocolDescription getDefaultProtocol() {
        return new ProtocolDescription("jmx-osgi");
    }

    @Override
    public void setup(T configuration) {
        super.setup(configuration);
        this.config = configuration;
    }

    public ProtocolMetaData deploy(Archive<?> archive) throws DeploymentException {
        try {
            BundleHandle handle = this.installBundle(archive);
            this.deployedBundles.put(archive.getName(), handle);
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception ex) {
            throw new DeploymentException("Cannot deploy: " + archive.getName(), (Throwable)ex);
        }
        MBeanServerConnection mbeanServer = (MBeanServerConnection)this.mbeanServerInstance.get();
        return new ProtocolMetaData().addContext((Object)new JMXContext(mbeanServer));
    }

    public void deploy(Descriptor desc) throws DeploymentException {
        throw new UnsupportedOperationException();
    }

    public void undeploy(Archive<?> archive) throws DeploymentException {
        BundleHandle handle = this.deployedBundles.remove(archive.getName());
        if (handle != null) {
            long bundleId;
            String bundleState = null;
            try {
                bundleId = handle.getBundleId();
                CompositeData bundleType = this.bundleStateMBean.getBundle(bundleId);
                if (bundleType != null) {
                    bundleState = (String)bundleType.get("State");
                }
            }
            catch (IOException e) {
                return;
            }
            if (bundleState != null && !bundleState.equals("UNINSTALLED")) {
                try {
                    bundleId = handle.getBundleId();
                    this.frameworkMBean.uninstallBundle(bundleId);
                }
                catch (IOException ex) {
                    logger.error("Cannot undeploy: " + archive.getName(), (Throwable)ex);
                }
            }
        }
    }

    public void undeploy(Descriptor desc) throws DeploymentException {
        throw new UnsupportedOperationException();
    }

    public void stop() throws LifecycleException {
        this.uninstallArquillianBundle();
    }

    protected BundleHandle installBundle(String groupId, String artifactId, String version, boolean startBundle) throws BundleException, IOException {
        String filespec = groupId + ":" + artifactId + ":jar:" + version;
        File[] resolved = ((MavenFormatStage)((MavenStrategyStage)Maven.resolver().resolve(filespec)).withoutTransitivity()).asFile();
        if (resolved == null || resolved.length == 0) {
            throw new BundleException("Cannot obtain maven artifact: " + filespec);
        }
        if (resolved.length > 1) {
            throw new BundleException("Multiple maven artifacts for: " + filespec);
        }
        URL fileURL = resolved[0].toURI().toURL();
        BundleHandle handle = this.installBundle(filespec, fileURL);
        if (startBundle) {
            this.frameworkMBean.startBundle(handle.getBundleId());
        }
        return handle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BundleHandle installBundle(Archive<?> archive) throws BundleException, IOException {
        VirtualFile virtualFile = this.toVirtualFile(archive);
        try {
            BundleHandle bundleHandle = this.installBundle(archive.getName(), virtualFile);
            return bundleHandle;
        }
        finally {
            VFSUtils.safeClose((Closeable)virtualFile);
        }
    }

    private BundleHandle installBundle(String location, VirtualFile virtualFile) throws BundleException, IOException {
        BundleInfo info = BundleInfo.createBundleInfo((VirtualFile)virtualFile);
        URL streamURL = info.getRoot().getStreamURL();
        return this.installBundle(location, streamURL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BundleHandle installBundle(String location, URL streamURL) throws BundleException, IOException {
        URL serverUrl = streamURL;
        SimpleHTTPServer server = null;
        if (!JMXDeployableContainer.isLocalHost(this.config)) {
            server = new SimpleHTTPServer();
            serverUrl = server.serve(streamURL);
            server.start();
        }
        try {
            long bundleId = this.frameworkMBean.installBundleFromURL(location, serverUrl.toExternalForm());
            String symbolicName = this.bundleStateMBean.getSymbolicName(bundleId);
            BundleHandle bundleHandle = new BundleHandle(bundleId, symbolicName);
            return bundleHandle;
        }
        finally {
            if (server != null) {
                server.shutdown();
            }
        }
    }

    private static boolean isLocalHost(JMXContainerConfiguration config) {
        try {
            JMXServiceURL serviceURL = new JMXServiceURL(config.getJmxServiceURL());
            InetAddress addr = InetAddress.getByName(serviceURL.getHost());
            if (addr.isAnyLocalAddress() || addr.isLoopbackAddress()) {
                return true;
            }
            return NetworkInterface.getByInetAddress(addr) != null;
        }
        catch (IOException e) {
            return false;
        }
    }

    protected String getArquillianBundleVersion() {
        String arqVersion = JMXDeployableContainer.class.getPackage().getImplementationVersion();
        if (arqVersion == null) {
            arqVersion = System.getProperty("arquillian.osgi.version");
        }
        return arqVersion;
    }

    protected void installArquillianBundle() throws LifecycleException, IOException {
        List<BundleHandle> bundleList = this.listBundles("arquillian-osgi-bundle");
        if (bundleList.isEmpty()) {
            try {
                this.installBundle("org.jboss.arquillian.osgi", "arquillian-osgi-bundle", this.getArquillianBundleVersion(), true);
            }
            catch (BundleException ex) {
                throw new LifecycleException("Cannot install arquillian-osgi-bundle", (Throwable)ex);
            }
        }
    }

    protected void uninstallArquillianBundle() throws LifecycleException {
        try {
            BundleHandle arqBundle = this.getBundle("arquillian-osgi-bundle", this.getArquillianBundleVersion());
            if (arqBundle != null) {
                this.frameworkMBean.uninstallBundle(arqBundle.getBundleId());
                logger.info("Bundle 'arquillian-osgi-bundle' was undeployed");
            }
        }
        catch (Exception ex) {
            throw new LifecycleException("Cannot uninstall arquillian-osgi-bundle", (Throwable)ex);
        }
    }

    private VirtualFile toVirtualFile(Archive<?> archive) throws IOException {
        ZipExporter exporter = (ZipExporter)archive.as(ZipExporter.class);
        return AbstractVFS.toVirtualFile((String)archive.getName(), (InputStream)exporter.exportAsInputStream());
    }

    protected void awaitBeginningStartLevel(Integer beginningStartLevel, long timeout, TimeUnit unit) throws IOException, TimeoutException, InterruptedException {
        int startLevel = 0;
        long timeoutMillis = System.currentTimeMillis() + unit.toMillis(timeout);
        while (System.currentTimeMillis() < timeoutMillis) {
            startLevel = this.frameworkMBean.getFrameworkStartLevel();
            if (startLevel >= beginningStartLevel) {
                return;
            }
            Thread.sleep(500L);
        }
        throw new TimeoutException("Beginning start level [" + beginningStartLevel + "] not reached: " + startLevel);
    }

    @Override
    protected void awaitBootstrapCompleteService(String service) {
        try {
            this.awaitBootstrapCompleteService(service, 30L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot obtain bootsrap complete service: " + service, e);
        }
    }

    protected void awaitBootstrapCompleteService(String serviceName, long timeout, TimeUnit unit) throws TimeoutException, InterruptedException, IOException {
        long timeoutMillis = System.currentTimeMillis() + unit.toMillis(timeout);
        while (System.currentTimeMillis() < timeoutMillis) {
            TabularData list = this.serviceStateMBean.listServices(serviceName, null);
            if (list.size() > 0) {
                return;
            }
            Thread.sleep(500L);
        }
        throw new TimeoutException("Timeout while waiting for service: " + serviceName);
    }

    protected void awaitArquillianBundleActive(long timeout, TimeUnit unit) throws IOException, TimeoutException, InterruptedException {
        String symbolicName = "arquillian-osgi-bundle";
        List<BundleHandle> list = this.listBundles(symbolicName);
        if (list.size() != 1) {
            throw new IllegalStateException("Cannot obtain: " + symbolicName);
        }
        String bundleState = null;
        long bundleId = list.get(0).getBundleId();
        long timeoutMillis = System.currentTimeMillis() + unit.toMillis(timeout);
        while (System.currentTimeMillis() < timeoutMillis) {
            bundleState = this.bundleStateMBean.getState(bundleId);
            if ("ACTIVE".equals(bundleState)) {
                return;
            }
            Thread.sleep(500L);
        }
        throw new TimeoutException("Arquillian bundle [" + bundleId + "] not started: " + bundleState);
    }

    protected MBeanServerConnection getMBeanServerConnection(final long timeout, final TimeUnit unit) throws TimeoutException {
        Callable<MBeanServerConnection> callable = new Callable<MBeanServerConnection>(){

            @Override
            public MBeanServerConnection call() throws Exception {
                Exception lastException = null;
                long timeoutMillis = System.currentTimeMillis() + unit.toMillis(timeout);
                while (System.currentTimeMillis() < timeoutMillis) {
                    try {
                        return JMXDeployableContainer.this.getMBeanServerConnection();
                    }
                    catch (Exception ex) {
                        lastException = ex;
                        Thread.sleep(500L);
                    }
                }
                TimeoutException timeoutException = new TimeoutException();
                timeoutException.initCause(lastException);
                throw timeoutException;
            }
        };
        ExecutorService executor = Executors.newSingleThreadExecutor();
        Future<MBeanServerConnection> future = executor.submit(callable);
        try {
            return future.get(timeout, unit);
        }
        catch (TimeoutException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    protected MBeanServerConnection getMBeanServerConnection() throws IOException {
        String[] credentials = new String[]{this.config.getJmxUsername(), this.config.getJmxPassword()};
        Map<String, String[]> env = Collections.singletonMap("jmx.remote.credentials", credentials);
        JMXServiceURL serviceURL = new JMXServiceURL(this.config.getJmxServiceURL());
        JMXConnector connector = JMXConnectorFactory.connect(serviceURL, env);
        return connector.getMBeanServerConnection();
    }

    protected <U> U getMBeanProxy(final MBeanServerConnection mbeanServer, final ObjectName oname, final Class<U> type, final long timeout, final TimeUnit unit) throws TimeoutException {
        Callable callable = new Callable<U>(){

            @Override
            public U call() throws Exception {
                Throwable lastException = null;
                long timeoutMillis = System.currentTimeMillis() + unit.toMillis(timeout);
                while (System.currentTimeMillis() < timeoutMillis) {
                    Set<ObjectName> names = mbeanServer.queryNames(oname, null);
                    if (names.size() == 1) {
                        ObjectName instanceName = names.iterator().next();
                        return MBeanServerInvocationHandler.newProxyInstance(mbeanServer, instanceName, type, false);
                    }
                    Thread.sleep(500L);
                }
                logger.warn("Cannot get MBean proxy for type: " + oname, lastException);
                throw new TimeoutException();
            }
        };
        ExecutorService executor = Executors.newSingleThreadExecutor();
        Future future = executor.submit(callable);
        try {
            return (U)future.get(timeout, unit);
        }
        catch (TimeoutException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    protected List<BundleHandle> listBundles(String symbolicName) throws IOException {
        ArrayList<BundleHandle> bundleList = new ArrayList<BundleHandle>();
        TabularData listBundles = this.bundleStateMBean.listBundles();
        for (CompositeData bundleType : listBundles.values()) {
            Long bundleId = (Long)bundleType.get("Identifier");
            String auxName = (String)bundleType.get("SymbolicName");
            if (symbolicName != null && !symbolicName.equals(auxName)) continue;
            bundleList.add(new BundleHandle(bundleId, symbolicName));
        }
        return bundleList;
    }

    @Override
    public void startBundle(String symbolicName, String version) throws Exception {
        BundleHandle bHandle = this.getBundle(symbolicName, version);
        if (bHandle == null) {
            throw new IllegalStateException("Bundle '" + symbolicName + ":" + version + "' was not found");
        }
        this.frameworkMBean.startBundle(bHandle.getBundleId());
    }

    protected BundleHandle getBundle(String symbolicName, String version) throws Exception {
        TabularData listBundles = this.bundleStateMBean.listBundles();
        for (CompositeData bundleType : listBundles.values()) {
            Long bundleId = (Long)bundleType.get("Identifier");
            String auxName = (String)bundleType.get("SymbolicName");
            String auxVersion = (String)bundleType.get("Version");
            if (!symbolicName.equals(auxName) || !version.equals(auxVersion)) continue;
            return new BundleHandle(bundleId, symbolicName);
        }
        return null;
    }

    static class BundleHandle {
        private long bundleId;
        private String symbolicName;

        BundleHandle(long bundleId, String symbolicName) {
            this.bundleId = bundleId;
            this.symbolicName = symbolicName;
        }

        long getBundleId() {
            return this.bundleId;
        }

        String getSymbolicName() {
            return this.symbolicName;
        }

        public String toString() {
            return "[" + this.bundleId + "]" + this.symbolicName;
        }
    }
}

