/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.osgi.jmx.http;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.jboss.osgi.vfs.VFSUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleHTTPServer {
    static final Logger _logger = LoggerFactory.getLogger((String)SimpleHTTPServer.class.getPackage().getName());
    private final Map<String, URL> streams = Collections.synchronizedMap(new HashMap());
    private final List<ClientConnection> clients = new ArrayList<ClientConnection>();
    private final ServerSocket serverSocket;
    private final String canonicalHostName;
    private volatile boolean running = true;

    public SimpleHTTPServer() throws IOException {
        this(null, InetAddress.getLocalHost().getCanonicalHostName(), 0);
    }

    public SimpleHTTPServer(InetAddress bindAddress, int port) throws IOException {
        this(bindAddress, bindAddress.getCanonicalHostName(), port);
    }

    private SimpleHTTPServer(InetAddress bindAddress, String canonicalHostname, int port) throws IOException {
        this.canonicalHostName = canonicalHostname;
        this.serverSocket = new ServerSocket();
        this.serverSocket.bind(new InetSocketAddress(bindAddress, port));
    }

    public URL serve(URL stream) {
        String token = UUID.randomUUID().toString();
        this.streams.put(token, stream);
        try {
            return new URL(String.format("http://%s:%d/%s", this.canonicalHostName, this.serverSocket.getLocalPort(), token));
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("HTTP url could not be parsed.", e);
        }
    }

    private void serve() {
        try {
            while (this.running) {
                ClientConnection client = new ClientConnection(this.serverSocket.accept());
                this.onClientConnect(client);
                client.start();
            }
        }
        catch (Exception e) {
            this.runError("Error accepting connection", e);
        }
    }

    private synchronized void onClientConnect(ClientConnection client) {
        if (!this.running) {
            client.shutdown();
        } else {
            this.clients.add(client);
        }
    }

    private synchronized void onClientDisconnect(ClientConnection client) {
        this.clients.remove(client);
    }

    private void runError(String message, Throwable t) {
        if (this.running) {
            _logger.error(message, t);
        }
    }

    public void start() {
        Thread srv = new Thread("Simple HTTP Server"){

            @Override
            public void run() {
                SimpleHTTPServer.this.serve();
            }
        };
        srv.setDaemon(true);
        srv.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        ArrayList<ClientConnection> runningClients;
        this.running = false;
        try {
            this.serverSocket.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        SimpleHTTPServer simpleHTTPServer = this;
        synchronized (simpleHTTPServer) {
            runningClients = new ArrayList<ClientConnection>(this.clients);
            this.clients.clear();
        }
        for (ClientConnection client : runningClients) {
            client.shutdown();
        }
    }

    private class ClientConnection
    extends Thread {
        private Socket socket;

        public ClientConnection(Socket socket) {
            this.setDaemon(true);
            this.socket = socket;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                BufferedReader input = new BufferedReader(new InputStreamReader(this.socket.getInputStream(), "US-ASCII"));
                DataOutputStream output = new DataOutputStream(this.socket.getOutputStream());
                try {
                    String line = input.readLine();
                    _logger.debug("Incoming request [{}]", (Object)line);
                    if (line == null || line.length() < 1) {
                        return;
                    }
                    URL streamUrl = this.getRequestedFile(line);
                    if (streamUrl != null) {
                        _logger.debug("For [{}] serving {}", (Object)line, (Object)streamUrl);
                        this.writeResponse(output, "200 OK");
                        VFSUtils.copyStream((InputStream)streamUrl.openStream(), (OutputStream)output);
                    } else {
                        this.writeResponse(output, "404 Not Found");
                        _logger.warn("For [{}] no file found", (Object)line);
                    }
                }
                catch (Exception e) {
                    this.writeResponse(output, "500 Server Error");
                    SimpleHTTPServer.this.runError("Error serving file", e);
                }
                finally {
                    output.flush();
                }
            }
            catch (Exception e) {
                SimpleHTTPServer.this.runError("Error setting up file serving thread", e);
            }
            finally {
                this.shutdown();
            }
        }

        private void writeResponse(DataOutputStream output, String responseLine) throws IOException {
            output.writeBytes("HTTP/1.0 ");
            output.writeBytes(responseLine);
            output.writeBytes("\r\n\r\n");
        }

        private URL getRequestedFile(String requestLine) {
            String[] parts;
            if (requestLine.startsWith("GET") && (parts = requestLine.split(" ")).length >= 2 && parts[1].startsWith("/")) {
                String token = parts[1].substring(1);
                return (URL)SimpleHTTPServer.this.streams.get(token);
            }
            return null;
        }

        public synchronized void shutdown() {
            if (this.socket != null) {
                try {
                    this.socket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.socket = null;
            }
            SimpleHTTPServer.this.onClientDisconnect(this);
        }
    }
}

