/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.spi.client.protocol.metadata;

import java.net.URI;
import org.jboss.arquillian.container.spi.client.protocol.metadata.HTTPContext;

public class Servlet {
    static final String HTTP_SCHEME = "http://";
    static final String ROOT_CONTEXT = "/";
    private final String name;
    private final String contextRoot;
    private String scheme;
    private String host;
    private int port;

    public Servlet(String name, String contextRoot) {
        if (name == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        if (contextRoot == null) {
            throw new IllegalArgumentException("contextRoot must not be null");
        }
        this.name = name;
        this.contextRoot = this.cleanContextRoot(contextRoot);
    }

    void setParent(HTTPContext context) {
        if (context.getHost() == null) {
            throw new IllegalArgumentException(context.getClass().getSimpleName() + " host must not be null");
        }
        this.scheme = context.getScheme();
        this.host = context.getHost();
        this.port = context.getPort();
    }

    public String getName() {
        return this.name;
    }

    public String getContextRoot() {
        return this.contextRoot;
    }

    public URI getBaseURI() {
        return URI.create(this.getBaseURIAsString());
    }

    public URI getFullURI() {
        return URI.create(this.getBaseURIAsString() + this.name);
    }

    private String getBaseURIAsString() {
        return this.scheme + "://" + this.host + ":" + this.port + this.contextRoot + ROOT_CONTEXT;
    }

    public int hashCode() {
        this.assertHostState();
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.contextRoot == null ? 0 : this.contextRoot.hashCode());
        result = 31 * result + (this.host == null ? 0 : this.host.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + this.port;
        return result;
    }

    public boolean equals(Object obj) {
        this.assertHostState();
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Servlet)) {
            return false;
        }
        Servlet other = (Servlet)obj;
        if (this.contextRoot == null ? other.contextRoot != null : !this.contextRoot.equals(other.contextRoot)) {
            return false;
        }
        if (this.host == null ? other.host != null : !this.host.equals(other.host)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return this.port == other.port;
    }

    public String toString() {
        return "Servlet [name=" + this.name + ", contextRoot=" + this.contextRoot + "]";
    }

    private String cleanContextRoot(String contextRoot) {
        if (!contextRoot.startsWith(ROOT_CONTEXT)) {
            contextRoot = ROOT_CONTEXT + contextRoot;
        }
        if (contextRoot.equals(ROOT_CONTEXT)) {
            contextRoot = "";
        }
        return contextRoot;
    }

    private void assertHostState() {
        if (this.host == null) {
            throw new IllegalStateException("host must not be null (see setParent(...))");
        }
    }
}

