/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.test.impl;

import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Map;

public class MapObject {
    public static void populate(Object object, Map<String, String> values) throws Exception {
        for (Method candidate : object.getClass().getMethods()) {
            String methodName = candidate.getName();
            if (!methodName.matches("^set[A-Z].*") || !candidate.getReturnType().equals(Void.TYPE) || candidate.getParameterTypes().length != 1) continue;
            candidate.setAccessible(true);
            String propertyName = methodName.substring(3, 4).toLowerCase() + methodName.substring(4);
            if (!values.containsKey(propertyName)) continue;
            candidate.invoke(object, MapObject.convert(candidate.getParameterTypes()[0], values.get(propertyName)));
        }
    }

    public static URL[] convert(File[] files) {
        URL[] urls = new URL[files.length];
        try {
            for (int i = 0; i < files.length; ++i) {
                urls[i] = files[i].toURI().toURL();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create URL from a File object?", e);
        }
        return urls;
    }

    private static Object convert(Class<?> clazz, String value) {
        if (Integer.class.equals(clazz) || Integer.TYPE.equals(clazz)) {
            return Integer.valueOf(value);
        }
        if (Double.class.equals(clazz) || Double.TYPE.equals(clazz)) {
            return Double.valueOf(value);
        }
        if (Long.class.equals(clazz) || Long.TYPE.equals(clazz)) {
            return Long.valueOf(value);
        }
        if (Boolean.class.equals(clazz) || Boolean.TYPE.equals(clazz)) {
            return Boolean.valueOf(value);
        }
        return value;
    }
}

