/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.test.impl.client.deployment;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.DeploymentConfiguration;
import org.jboss.arquillian.container.test.api.OverProtocol;
import org.jboss.arquillian.container.test.api.ShouldThrowException;
import org.jboss.arquillian.container.test.api.TargetsContainer;
import org.jboss.arquillian.container.test.impl.client.deployment.AbstractDeploymentScenarioGenerator;
import org.jboss.arquillian.container.test.spi.client.deployment.DeploymentScenarioGenerator;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.spi.ServiceLoader;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.arquillian.test.spi.TestClass;
import org.jboss.arquillian.test.spi.TestEnricher;
import org.jboss.arquillian.test.spi.execution.ExecUtils;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.descriptor.api.Descriptor;

public class AnnotationDeploymentScenarioGenerator
extends AbstractDeploymentScenarioGenerator
implements DeploymentScenarioGenerator {
    @Inject
    private Instance<ServiceLoader> serviceLoader;

    @Override
    protected List<DeploymentConfiguration> generateDeploymentContent(TestClass testClass) {
        Method[] deploymentMethods;
        ArrayList<DeploymentConfiguration> deployments = new ArrayList<DeploymentConfiguration>();
        for (Method deploymentMethod : deploymentMethods = testClass.getMethods(Deployment.class)) {
            this.validate(deploymentMethod);
            deployments.add(this.generateDeploymentContent(deploymentMethod));
        }
        return deployments;
    }

    private void validate(Method deploymentMethod) {
        if (!Modifier.isStatic(deploymentMethod.getModifiers())) {
            throw new IllegalArgumentException("Method annotated with " + Deployment.class.getName() + " is not static. " + deploymentMethod);
        }
        if (!Archive.class.isAssignableFrom(deploymentMethod.getReturnType()) && !Descriptor.class.isAssignableFrom(deploymentMethod.getReturnType())) {
            throw new IllegalArgumentException("Method annotated with " + Deployment.class.getName() + " must have return type " + Archive.class.getName() + " or " + Descriptor.class.getName() + ". " + deploymentMethod);
        }
        this.hasZeroOrOnlyArquillianResourceArgs(deploymentMethod);
    }

    private void hasZeroOrOnlyArquillianResourceArgs(Method deploymentMethod) throws IllegalArgumentException {
        boolean isOk;
        boolean bl = isOk = deploymentMethod.getParameterTypes().length == 0;
        if (!isOk) {
            ArrayList<String> badArgs = new ArrayList<String>();
            for (Parameter param : deploymentMethod.getParameters()) {
                if (param.getAnnotation(ArquillianResource.class) != null) continue;
                badArgs.add(param.getName());
            }
            if (!badArgs.isEmpty()) {
                throw new IllegalArgumentException("Method annotated with " + Deployment.class.getName() + " can not accept parameters that are not annotated with " + ArquillianResource.class.getName() + ". " + deploymentMethod + " has invalid parameters: " + badArgs);
            }
        }
    }

    private DeploymentConfiguration generateDeploymentContent(Method deploymentMethod) {
        Deployment deploymentAnnotation = deploymentMethod.getAnnotation(Deployment.class);
        DeploymentConfiguration.DeploymentContentBuilder deploymentContentBuilder = null;
        if (Archive.class.isAssignableFrom(deploymentMethod.getReturnType())) {
            Archive archive = this.invoke(Archive.class, deploymentMethod);
            deploymentContentBuilder = new DeploymentConfiguration.DeploymentContentBuilder(archive);
        } else if (Descriptor.class.isAssignableFrom(deploymentMethod.getReturnType())) {
            Descriptor descriptor = this.invoke(Descriptor.class, deploymentMethod);
            deploymentContentBuilder = new DeploymentConfiguration.DeploymentContentBuilder(descriptor);
        }
        if (deploymentMethod.isAnnotationPresent(OverProtocol.class)) {
            deploymentContentBuilder.withOverProtocol(deploymentMethod.getAnnotation(OverProtocol.class).value());
        }
        if (deploymentMethod.isAnnotationPresent(TargetsContainer.class)) {
            deploymentContentBuilder.withTargetsContainer(deploymentMethod.getAnnotation(TargetsContainer.class).value());
        }
        if (deploymentMethod.isAnnotationPresent(ShouldThrowException.class)) {
            ShouldThrowException shouldThrowException = deploymentMethod.getAnnotation(ShouldThrowException.class);
            deploymentContentBuilder.withShouldThrowException(shouldThrowException.value(), shouldThrowException.testable());
        }
        deploymentContentBuilder = deploymentContentBuilder.withDeployment().withManaged(deploymentAnnotation.managed()).withName(deploymentAnnotation.name()).withOrder(deploymentAnnotation.order()).withTestable(deploymentAnnotation.testable()).build();
        return deploymentContentBuilder.get();
    }

    private <T> T invoke(Class<T> type, Method deploymentMethod) {
        try {
            Object[] args = null;
            if (deploymentMethod.getParameterCount() > 0) {
                Collection enrichers = ((ServiceLoader)this.serviceLoader.get()).all(TestEnricher.class);
                args = ExecUtils.enrichArguments((Method)deploymentMethod, (Collection)enrichers);
            }
            return type.cast(deploymentMethod.invoke(null, args));
        }
        catch (Exception e) {
            throw new RuntimeException("Could not invoke deployment method: " + deploymentMethod, e);
        }
    }
}

