/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.fabric8.common;

import io.fabric8.common.util.Strings;
import io.fabric8.testkit.support.FabricControllerManagerSupport;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.jboss.arquillian.container.spi.ConfigurationException;
import org.jboss.arquillian.container.spi.client.container.ContainerConfiguration;

public class Fabric8CommonConfiguration
implements ContainerConfiguration {
    private String profiles;
    private String workFolder;
    private String globalResolver;
    private String fabricDockerImage;

    public static File getBaseDir() {
        return new File(System.getProperty("basedir", "."));
    }

    public void validate() throws ConfigurationException {
    }

    public void configure(FabricControllerManagerSupport controllerManager) {
        String profilesText = this.getProfiles();
        String[] profileArrays = null;
        if (Strings.isNotBlank((String)profilesText)) {
            profileArrays = profilesText.split(",");
        }
        if (profileArrays == null || profileArrays.length == 0) {
            profileArrays = new String[]{"autoscale"};
        }
        List<String> profiles = Arrays.asList(profileArrays);
        System.out.println("Populating initial fabric node with the profiles: " + profiles);
        controllerManager.setProfiles(profiles);
        File baseDir = Fabric8CommonConfiguration.getBaseDir();
        String outputFolder = Strings.defaultIfEmpty((String)this.getWorkFolder(), (String)"fabric8");
        File workDir = new File(baseDir, "target/" + outputFolder);
        System.out.println("Using " + workDir.getPath() + " to store the fabric8 installation");
        controllerManager.setWorkDirectory(workDir);
        if (Strings.isNotBlank((String)this.globalResolver)) {
            System.out.println("Using global resolver " + this.globalResolver);
            controllerManager.setEnvironmentVariable("FABRIC8_GLOBAL_RESOLVER", this.globalResolver);
        }
        if (Strings.isNotBlank((String)this.fabricDockerImage)) {
            System.out.println("Using fabric docker image: " + this.fabricDockerImage);
            controllerManager.setEnvironmentVariable("FABRIC8_DOCKER_IMAGE_FABRIC8", this.fabricDockerImage);
        }
    }

    public String getProfiles() {
        return this.profiles;
    }

    public void setProfiles(String profiles) {
        this.profiles = profiles;
    }

    public String getWorkFolder() {
        return this.workFolder;
    }

    public void setWorkFolder(String workFolder) {
        this.workFolder = workFolder;
    }

    public String getGlobalResolver() {
        return this.globalResolver;
    }

    public void setGlobalResolver(String globalResolver) {
        this.globalResolver = globalResolver;
    }

    public String getFabricDockerImage() {
        return this.fabricDockerImage;
    }

    public void setFabricDockerImage(String fabricDockerImage) {
        this.fabricDockerImage = fabricDockerImage;
    }
}

