/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.appengine.cli;

import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import org.jboss.arquillian.container.common.AppEngineCommonContainer;
import org.jboss.arquillian.container.spi.client.container.ContainerConfiguration;

public abstract class AppEngineCLIContainer<T extends ContainerConfiguration>
extends AppEngineCommonContainer<T> {
    private Thread appEngineThread;

    protected void invokeAppEngine(String sdkDir, String appEngineClass, Object args) throws Exception {
        this.invokeAppEngine(null, sdkDir, appEngineClass, args);
    }

    protected void invokeAppEngine(ThreadGroup threads, String sdkDir, String appEngineClass, Object args) throws Exception {
        File lib = new File(sdkDir, "lib");
        File tools = new File(lib, "appengine-tools-api.jar");
        if (!tools.exists()) {
            throw new IllegalArgumentException("No AppEngine tools jar: " + tools);
        }
        URL url = tools.toURI().toURL();
        URL[] urls = new URL[]{url};
        URLClassLoader cl = new URLClassLoader(urls);
        Class<?> kickStartClass = cl.loadClass(appEngineClass);
        Method main = kickStartClass.getMethod("main", String[].class);
        Runnable runnable = this.createRunnable(threads, main, args);
        this.appEngineThread = new Thread(threads, runnable, "AppEngine thread: " + ((Object)((Object)this)).getClass().getSimpleName());
        this.appEngineThread.start();
    }

    protected Runnable createRunnable(ThreadGroup threads, final Method main, final Object args) {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    main.invoke(null, args);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    protected void delayArchiveDeploy(String serverURL, long startupTimeout, long checkPeriod) throws Exception {
        long timeout;
        if (serverURL == null) {
            throw new IllegalArgumentException("Null server url");
        }
        URL server = new URL(serverURL);
        this.log.info("Pinging server url: " + serverURL);
        for (timeout = startupTimeout * 1000L; timeout > 0L; timeout -= checkPeriod) {
            Thread.sleep(checkPeriod);
            try {
                server.openStream();
                break;
            }
            catch (Throwable ignored) {
                continue;
            }
        }
        if (timeout <= 0L) {
            throw new IllegalStateException("Cannot connect to managed AppEngine, timed out.");
        }
    }

    protected void shutdownServer() {
        if (this.appEngineThread != null) {
            this.appEngineThread.interrupt();
            this.appEngineThread = null;
        }
    }

    protected static void addArg(List<String> args, String key, boolean condition) {
        if (condition) {
            args.add("--" + key);
        }
    }

    protected static Object addArg(List<String> args, String key, Object value, boolean optional) {
        if (value == null && !optional) {
            throw new IllegalArgumentException("Missing argument value: " + key);
        }
        if (value != null) {
            args.add("--" + key + "=" + value);
        }
        return value;
    }
}

