/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.appengine.remote;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import org.jboss.arquillian.container.appengine.cli.AppEngineCLIContainer;
import org.jboss.arquillian.container.appengine.remote.AppEngineRemoteConfiguration;
import org.jboss.arquillian.container.spi.ConfigurationException;
import org.jboss.arquillian.container.spi.client.container.DeploymentException;
import org.jboss.arquillian.container.spi.client.protocol.metadata.ProtocolMetaData;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.Node;

public class AppEngineRemoteContainer
extends AppEngineCLIContainer<AppEngineRemoteConfiguration> {
    private static final String APPLICATION = "<application>";
    private AppEngineRemoteConfiguration configuration;

    public Class<AppEngineRemoteConfiguration> getConfigurationClass() {
        return AppEngineRemoteConfiguration.class;
    }

    public void setup(AppEngineRemoteConfiguration configuration) {
        this.configuration = configuration;
        if (configuration.getSdkDir() == null) {
            throw new ConfigurationException("AppEngine SDK root is null.");
        }
        if (configuration.getPassword() == null) {
            throw new ConfigurationException("AppEngine password is null.");
        }
        System.setProperty("appengine.sdk.root", configuration.getSdkDir());
    }

    protected ProtocolMetaData doDeploy(Archive<?> archive) throws DeploymentException {
        String app;
        String sdkDir = this.configuration.getSdkDir();
        if (!new File(sdkDir).isDirectory()) {
            throw new DeploymentException("SDK root is not a directory: " + sdkDir);
        }
        try {
            app = this.getAppLocation().getCanonicalPath();
        }
        catch (IOException e) {
            throw new DeploymentException("Cannot get app location.", (Throwable)e);
        }
        try {
            String serverURL;
            this.log.info(archive.toString(true));
            ArrayList<String> args = new ArrayList<String>();
            AppEngineRemoteContainer.addArg(args, (String)"email", (Object)this.configuration.getEmail(), (boolean)false);
            AppEngineRemoteContainer.addArg(args, (String)"host", (Object)this.configuration.getHost(), (boolean)true);
            AppEngineRemoteContainer.addArg(args, (String)"compile_encoding", (Object)this.configuration.getEncoding(), (boolean)true);
            AppEngineRemoteContainer.addArg(args, (String)"proxy", (Object)this.configuration.getProxy(), (boolean)true);
            AppEngineRemoteContainer.addArg(args, (String)"passin", (boolean)this.configuration.isPassIn());
            if (!this.configuration.isPassIn()) {
                AppEngineRemoteContainer.addArg(args, (String)"disable_prompt", (boolean)this.configuration.isPrompt());
            }
            AppEngineRemoteContainer.addArg(args, (String)"enable_jar_splitting", (boolean)this.configuration.isSplitJars());
            AppEngineRemoteContainer.addArg(args, (String)"retain_upload_dir", (boolean)this.configuration.isKeepTempUploadDir());
            args.add("update");
            args.add(app);
            this.invokeAppEngine(sdkDir, "com.google.appengine.tools.admin.AppCfg", args.toArray(new String[args.size()]));
            String host = this.configuration.getHost();
            if (host == null) {
                host = this.readAppId(archive) + ".appspot.com";
            }
            if ((serverURL = this.configuration.getServerURL()) == null) {
                serverURL = "http://" + host;
            }
            this.delayArchiveDeploy(serverURL + "/index.html", this.configuration.getStartupTimeout(), 60000L);
            return this.getProtocolMetaData(host, 80, archive);
        }
        catch (Exception e) {
            List<String> args = Arrays.asList("rollback", app);
            try {
                this.invokeAppEngine(sdkDir, "com.google.appengine.tools.admin.AppCfg", args.toArray(new String[args.size()]));
            }
            catch (Exception ignored) {
                // empty catch block
            }
            throw new DeploymentException("Cannot deploy to local GAE.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readAppId(Archive<?> archive) throws IOException {
        Node webXml = archive.get("WEB-INF/appengine-web.xml");
        InputStream is = webXml.getAsset().openStream();
        try {
            int x;
            StringBuilder builder = new StringBuilder();
            boolean isAppId = false;
            StringBuilder appId = new StringBuilder();
            while ((x = is.read()) != -1) {
                char ch = (char)x;
                if (isAppId) {
                    if (ch == '<') break;
                    appId.append(ch);
                } else {
                    builder.append(ch);
                }
                if (isAppId || !builder.toString().endsWith(APPLICATION)) continue;
                isAppId = true;
            }
            String string = appId.toString();
            return string;
        }
        finally {
            try {
                is.close();
            }
            catch (IOException ignored) {}
        }
    }

    protected void invokeAppEngine(String sdkDir, String appEngineClass, Object args) throws Exception {
        ThreadGroup threads = new ThreadGroup("AppCfgThreadGroup");
        this.invokeAppEngine(threads, sdkDir, appEngineClass, args);
    }

    protected Runnable createRunnable(final ThreadGroup threads, final Method main, final Object args) {
        return new Runnable(){

            @Override
            public void run() {
                PrintStream outOrig = System.out;
                InputStream inOrig = System.in;
                try {
                    PipedOutputStream stdin;
                    PipedInputStream inReplace = new PipedInputStream();
                    try {
                        stdin = new PipedOutputStream(inReplace);
                    }
                    catch (IOException e) {
                        AppEngineRemoteContainer.this.log.log(Level.SEVERE, "Unable to redirect input", e);
                        System.setOut(outOrig);
                        System.setIn(inOrig);
                        return;
                    }
                    System.setIn(inReplace);
                    final BufferedWriter stdinWriter = new BufferedWriter(new OutputStreamWriter(stdin));
                    Runnable onExpected = new Runnable(){

                        @Override
                        public void run() {
                            try {
                                stdinWriter.write(AppEngineRemoteContainer.this.configuration.getPassword());
                                stdinWriter.newLine();
                                stdinWriter.flush();
                            }
                            catch (IOException e) {
                                AppEngineRemoteContainer.this.log.log(Level.SEVERE, "Unable to enter password", e);
                            }
                        }
                    };
                    System.setOut(new PrintStream(new PasswordOutputStream(threads, outOrig, onExpected), true));
                    main.invoke(null, args);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                finally {
                    System.setOut(outOrig);
                    System.setIn(inOrig);
                }
            }
        };
    }

    private static class PasswordOutputStream
    extends OutputStream {
        private final ThreadGroup threads;
        private final PrintStream out;
        private final Runnable onExpected;
        private final byte[] expect;
        private int match = 0;

        public PasswordOutputStream(ThreadGroup threads, PrintStream out, Runnable onExpected) {
            this.threads = threads;
            this.out = out;
            this.onExpected = onExpected;
            try {
                this.expect = "Password for".getBytes("ASCII");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }

        private boolean isRedirectThread() {
            ThreadGroup tg;
            for (tg = Thread.currentThread().getThreadGroup(); this.threads != tg && tg != null; tg = tg.getParent()) {
            }
            return this.threads == tg;
        }

        @Override
        public void write(int b) throws IOException {
            if (this.isRedirectThread()) {
                this.expect((byte)(0xFF & b));
            }
            this.out.write(b);
        }

        private synchronized void expect(byte b) {
            if (this.expect[this.match] == b) {
                ++this.match;
                if (this.match == this.expect.length) {
                    this.match = 0;
                    Thread t = new Thread(this.onExpected, "EnterPasswordThread");
                    t.setDaemon(true);
                    t.start();
                }
            } else {
                this.match = 0;
            }
        }
    }
}

