/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.glassfish.managed_6;

import java.io.File;
import org.jboss.arquillian.container.glassfish.CommonGlassFishConfiguration;
import org.jboss.arquillian.container.spi.ConfigurationException;
import org.jboss.arquillian.container.spi.client.deployment.Validate;

public class GlassFishManagedContainerConfiguration
extends CommonGlassFishConfiguration {
    private String glassFishHome = System.getenv("GLASSFISH_HOME");
    private String domain = null;
    private boolean outputToConsole = true;
    private boolean debug = false;
    private boolean allowConnectingToRunningServer = false;
    private boolean enableDerby = false;

    public String getGlassFishHome() {
        return this.glassFishHome;
    }

    public void setGlassFishHome(String glassFishHome) {
        this.glassFishHome = glassFishHome;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public boolean isOutputToConsole() {
        return this.outputToConsole;
    }

    public void setOutputToConsole(boolean outputToConsole) {
        this.outputToConsole = outputToConsole;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public File getAdminCliJar() {
        return new File(this.getGlassFishHome() + "/glassfish/modules/admin-cli.jar");
    }

    public boolean isAllowConnectingToRunningServer() {
        return this.allowConnectingToRunningServer;
    }

    public void setAllowConnectingToRunningServer(boolean allowConnectingToRunningServer) {
        this.allowConnectingToRunningServer = allowConnectingToRunningServer;
    }

    public boolean isEnableDerby() {
        return this.enableDerby;
    }

    public void setEnableDerby(boolean enableDerby) {
        this.enableDerby = enableDerby;
    }

    public String getTarget() {
        return "server";
    }

    public void validate() throws ConfigurationException {
        Validate.notNull((Object)this.getGlassFishHome(), (String)"The property glassFishHome must be specified or the GLASSFISH_HOME environment variable must be set");
        Validate.configurationDirectoryExists((String)(this.getGlassFishHome() + "/glassfish"), (String)(this.getGlassFishHome() + " is not a valid GlassFish installation"));
        if (!this.getAdminCliJar().isFile()) {
            throw new IllegalArgumentException("Could not locate admin-cli.jar module in GlassFish installation: " + this.getGlassFishHome());
        }
        if (this.getDomain() != null) {
            Validate.configurationDirectoryExists((String)(this.getGlassFishHome() + "/glassfish/domains/" + this.getDomain()), (String)("Invalid domain: " + this.getDomain()));
        }
        super.validate();
    }
}

