/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.glassfish.managed_6;

import org.jboss.arquillian.container.glassfish.CommonGlassFishConfiguration;
import org.jboss.arquillian.container.glassfish.CommonGlassFishManager;
import org.jboss.arquillian.container.glassfish.managed_6.GlassFishManagedContainerConfiguration;
import org.jboss.arquillian.container.glassfish.managed_6.GlassFishServerControl;
import org.jboss.arquillian.container.spi.client.container.DeployableContainer;
import org.jboss.arquillian.container.spi.client.container.DeploymentException;
import org.jboss.arquillian.container.spi.client.container.LifecycleException;
import org.jboss.arquillian.container.spi.client.protocol.ProtocolDescription;
import org.jboss.arquillian.container.spi.client.protocol.metadata.ProtocolMetaData;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.descriptor.api.Descriptor;

public class GlassFishManagedDeployableContainer
implements DeployableContainer<GlassFishManagedContainerConfiguration> {
    private GlassFishManagedContainerConfiguration configuration;
    private GlassFishServerControl serverControl;
    private CommonGlassFishManager<GlassFishManagedContainerConfiguration> glassFishManager;
    private boolean connectedToRunningServer;

    public Class<GlassFishManagedContainerConfiguration> getConfigurationClass() {
        return GlassFishManagedContainerConfiguration.class;
    }

    public void setup(GlassFishManagedContainerConfiguration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException("configuration must not be null");
        }
        this.configuration = configuration;
        this.serverControl = new GlassFishServerControl(configuration);
        this.glassFishManager = new CommonGlassFishManager((CommonGlassFishConfiguration)configuration);
    }

    public void start() throws LifecycleException {
        if (this.glassFishManager.isDASRunning()) {
            if (this.configuration.isAllowConnectingToRunningServer()) {
                this.connectedToRunningServer = true;
                this.glassFishManager.start();
                return;
            }
            throw new LifecycleException("The server is already running! Managed containers does not support connecting to running server instances due to the possible harmful effect of connecting to the wrong server. Please stop server before running or change to another type of container.\nTo disable this check and allow Arquillian to connect to a running server, set allowConnectingToRunningServer to true in the container configuration");
        }
        this.serverControl.start();
        for (int i = 0; i < this.configuration.getRetries() && !this.glassFishManager.isDASRunning(); ++i) {
            try {
                Thread.sleep(this.configuration.getWaitTimeMs());
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.glassFishManager.start();
    }

    public void stop() throws LifecycleException {
        if (!this.connectedToRunningServer) {
            this.serverControl.stop();
        }
    }

    public ProtocolDescription getDefaultProtocol() {
        return new ProtocolDescription("Servlet 5.0");
    }

    public ProtocolMetaData deploy(Archive<?> archive) throws DeploymentException {
        return this.glassFishManager.deploy(archive);
    }

    public void undeploy(Archive<?> archive) throws DeploymentException {
        this.glassFishManager.undeploy(archive);
    }

    public void deploy(Descriptor descriptor) throws DeploymentException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void undeploy(Descriptor descriptor) throws DeploymentException {
        throw new UnsupportedOperationException("Not implemented");
    }
}

