/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.glassfish.managed_6;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.arquillian.container.glassfish.managed_6.GlassFishManagedContainerConfiguration;
import org.jboss.arquillian.container.spi.client.container.LifecycleException;

class GlassFishServerControl {
    private static final String DERBY_MISCONFIGURED_HINT = "It seems that the Glassfish version you are running might have a problem starting embedded Derby database. Please take a look at the server logs. You can also switch off 'enableDerby' property in your 'arquillian.xml' if you don't need it. For more information please refer to relevant issues for existing workarounds: https://java.net/jira/browse/GLASSFISH-21004 https://issues.apache.org/jira/browse/DERBY-6438";
    private static final List<String> NO_ARGS = new ArrayList<String>();
    private static final Logger logger = Logger.getLogger(GlassFishServerControl.class.getName());
    private GlassFishManagedContainerConfiguration config;
    private Thread shutdownHook;

    GlassFishServerControl(GlassFishManagedContainerConfiguration config) {
        this.config = config;
    }

    void start() throws LifecycleException {
        this.registerShutdownHook();
        if (this.config.isEnableDerby()) {
            this.startDerbyDatabase();
        }
        ArrayList<String> args = new ArrayList<String>();
        if (this.config.isDebug()) {
            args.add("--debug");
        }
        this.executeAdminDomainCommand("Starting container", "start-domain", args, this.createProcessOutputConsumer());
    }

    void stop() throws LifecycleException {
        this.removeShutdownHook();
        try {
            this.stopContainer();
        }
        catch (LifecycleException failedStoppingContainer) {
            logger.log(Level.SEVERE, "Failed stopping container.", failedStoppingContainer);
        }
        finally {
            this.stopDerbyDatabase();
        }
    }

    private void stopContainer() throws LifecycleException {
        ArrayList<String> args = new ArrayList<String>();
        args.add("--kill");
        this.executeAdminDomainCommand("Stopping container", "stop-domain", args, this.createProcessOutputConsumer());
    }

    private void startDerbyDatabase() throws LifecycleException {
        if (!this.config.isEnableDerby()) {
            return;
        }
        try {
            this.executeAdminDomainCommand("Starting database", "start-database", NO_ARGS, this.createProcessOutputConsumer());
        }
        catch (LifecycleException e) {
            logger.warning(DERBY_MISCONFIGURED_HINT);
            throw e;
        }
    }

    private void stopDerbyDatabase() throws LifecycleException {
        if (this.config.isEnableDerby()) {
            this.executeAdminDomainCommand("Stopping database", "stop-database", NO_ARGS, this.createProcessOutputConsumer());
        }
    }

    private void removeShutdownHook() {
        if (this.shutdownHook != null) {
            Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
            this.shutdownHook = null;
        }
    }

    private void registerShutdownHook() {
        this.shutdownHook = new Thread(new Runnable(){

            @Override
            public void run() {
                logger.warning("Forcing container shutdown");
                try {
                    GlassFishServerControl.this.stopContainer();
                    GlassFishServerControl.this.stopDerbyDatabase();
                }
                catch (LifecycleException e) {
                    logger.log(Level.SEVERE, "Failed stopping services through shutdown hook.", e);
                }
            }
        });
        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
    }

    private void executeAdminDomainCommand(String description, String adminCmd, List<String> args, ProcessOutputConsumer consumer) throws LifecycleException {
        if (this.config.getDomain() != null) {
            args.add(this.config.getDomain());
        }
        this.executeAdminCommand(description, adminCmd, args, consumer);
    }

    private void executeAdminCommand(String description, String command, List<String> args, ProcessOutputConsumer consumer) throws LifecycleException {
        int result;
        List<String> cmd = this.buildCommand(command, args);
        if (this.config.isOutputToConsole()) {
            System.out.println(description + " using command: " + cmd.toString());
        }
        Process process = null;
        ConsoleReader consoleReader = null;
        try {
            process = new ProcessBuilder(cmd).redirectErrorStream(true).start();
            consoleReader = new ConsoleReader(process, consumer);
            new Thread(consoleReader).start();
            result = process.waitFor();
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, description + " failed.", e);
            throw new LifecycleException("Unable to execute " + cmd.toString(), (Throwable)e);
        }
        catch (InterruptedException e) {
            logger.log(Level.WARNING, description + " interrupted.", e);
            throw new LifecycleException("Unable to execute " + cmd.toString(), (Throwable)e);
        }
        finally {
            if (consoleReader != null) {
                consoleReader.close();
            }
            if (process != null) {
                process.destroy();
            }
        }
        if (result != 0) {
            throw new LifecycleException("Unable to execute " + cmd.toString());
        }
    }

    private List<String> buildCommand(String command, List<String> args) {
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add("java");
        cmd.add("-jar");
        cmd.add(this.config.getAdminCliJar().getAbsolutePath());
        cmd.add(command);
        cmd.addAll(args);
        cmd.add("-t");
        return cmd;
    }

    private ProcessOutputConsumer createProcessOutputConsumer() {
        if (this.config.isOutputToConsole()) {
            return new OutputLoggingConsumer();
        }
        return new SilentOutputConsumer();
    }

    private class SilentOutputConsumer
    implements ProcessOutputConsumer {
        private SilentOutputConsumer() {
        }

        @Override
        public void consume(String line) {
        }
    }

    private static class OutputLoggingConsumer
    implements ProcessOutputConsumer {
        private OutputLoggingConsumer() {
        }

        @Override
        public void consume(String line) {
            System.out.println(line);
        }
    }

    private static interface ProcessOutputConsumer {
        public void consume(String var1);
    }

    private static class ConsoleReader
    implements Runnable,
    Closeable {
        private final ProcessOutputConsumer consumer;
        private final BufferedReader reader;

        private ConsoleReader(Process process, ProcessOutputConsumer consumer) {
            this.reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            this.consumer = consumer;
        }

        @Override
        public void run() {
            try {
                String line;
                while ((line = this.reader.readLine()) != null) {
                    this.consumer.consume(line);
                }
            }
            catch (IOException failOnReading) {
                logger.log(Level.SEVERE, failOnReading.getMessage(), failOnReading);
            }
        }

        @Override
        public void close() {
            if (this.reader != null) {
                try {
                    this.reader.close();
                }
                catch (IOException failOnClose) {
                    logger.log(Level.SEVERE, failOnClose.getMessage(), failOnClose);
                }
            }
        }
    }
}

