/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.jbossas.managed_6;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.naming.Context;
import org.jboss.arquillian.container.jbossas.managed_6.ArquillianServerManager;
import org.jboss.arquillian.container.jbossas.managed_6.JBossASConfiguration;
import org.jboss.arquillian.container.jbossas.managed_6.ManagementViewParser;
import org.jboss.arquillian.container.jbossas.managed_6.ShrinkWrapUtil;
import org.jboss.arquillian.container.spi.client.container.DeployableContainer;
import org.jboss.arquillian.container.spi.client.container.DeploymentException;
import org.jboss.arquillian.container.spi.client.container.LifecycleException;
import org.jboss.arquillian.container.spi.client.protocol.ProtocolDescription;
import org.jboss.arquillian.container.spi.client.protocol.metadata.ProtocolMetaData;
import org.jboss.arquillian.container.spi.context.annotation.ContainerScoped;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.deployers.spi.management.deploy.DeploymentManager;
import org.jboss.deployers.spi.management.deploy.DeploymentProgress;
import org.jboss.deployers.spi.management.deploy.DeploymentStatus;
import org.jboss.jbossas.servermanager.Argument;
import org.jboss.jbossas.servermanager.Property;
import org.jboss.jbossas.servermanager.Server;
import org.jboss.jbossas.servermanager.ServerController;
import org.jboss.jbossas.servermanager.ServerManager;
import org.jboss.profileservice.spi.ProfileKey;
import org.jboss.profileservice.spi.ProfileService;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.descriptor.api.Descriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossASLocalContainer
implements DeployableContainer<JBossASConfiguration> {
    private static Logger log = Logger.getLogger(JBossASLocalContainer.class.getName());
    private static final String DEFAULT_PROFILE_KEY_NAME = "jboss:profile=applications";
    private JBossASConfiguration configuration;
    protected ServerManager manager;
    private final List<String> failedUndeployments = new ArrayList<String>();
    private ProfileService profileService;
    private DeploymentManager deploymentManager;
    @Inject
    @ContainerScoped
    private InstanceProducer<Context> contextInst;

    public ProtocolDescription getDefaultProtocol() {
        return new ProtocolDescription("Servlet 3.0");
    }

    public Class<JBossASConfiguration> getConfigurationClass() {
        return JBossASConfiguration.class;
    }

    public void setup(JBossASConfiguration configuration) {
        this.configuration = configuration;
        this.manager = this.createAndConfigureServerManager();
    }

    public void start() throws LifecycleException {
        try {
            Server server = this.manager.getServer(this.configuration.getProfileName());
            if (ServerController.isServerStarted((Server)server)) {
                throw new LifecycleException("The server is already running! Managed containers does not support connecting to running server instances due to the possible harmfull effect of connecting to the wrong server. Please stop server before running or change to another type of container.");
            }
            this.manager.startServer(server.getName());
            this.initProfileService(server);
        }
        catch (Exception e) {
            throw new LifecycleException("Could not start remote container", (Throwable)e);
        }
    }

    public void stop() throws LifecycleException {
        Server server = this.manager.getServer(this.configuration.getProfileName());
        if (!server.isRunning()) {
            throw new LifecycleException("Can not stop server. Server is not started");
        }
        try {
            this.removeFailedUnDeployments();
        }
        catch (Exception e) {
            throw new LifecycleException("Could not clean up failed undeployments", (Throwable)e);
        }
        try {
            this.manager.stopServer(server.getName());
        }
        catch (Exception e) {
            throw new LifecycleException("Could not stop server", (Throwable)e);
        }
    }

    public void deploy(Descriptor descriptor) throws DeploymentException {
        String deploymentName = descriptor.getDescriptorName();
        URL deploymentUrl = ShrinkWrapUtil.toURL(descriptor);
        this.deploy(deploymentName, deploymentUrl);
    }

    public void undeploy(Descriptor descriptor) throws DeploymentException {
        this.undeploy(descriptor.getDescriptorName());
    }

    public ProtocolMetaData deploy(Archive<?> archive) throws DeploymentException {
        String deploymentName = archive.getName();
        URL deploymentUrl = ShrinkWrapUtil.toURL(archive);
        this.deploy(deploymentName, deploymentUrl);
        try {
            return ManagementViewParser.parse(deploymentName, this.profileService);
        }
        catch (Exception e) {
            throw new DeploymentException("Could not extract deployment metadata", (Throwable)e);
        }
    }

    public void undeploy(Archive<?> archive) throws DeploymentException {
        this.undeploy(archive.getName());
    }

    private void deploy(String deploymentName, URL url) throws DeploymentException {
        Exception failure = null;
        try {
            DeploymentProgress distribute = this.deploymentManager.distribute(deploymentName, url, true);
            distribute.run();
            DeploymentStatus uploadStatus = distribute.getDeploymentStatus();
            if (uploadStatus.isFailed()) {
                failure = uploadStatus.getFailure();
                this.undeploy(deploymentName);
            } else {
                DeploymentProgress progress = this.deploymentManager.start(new String[]{deploymentName});
                progress.run();
                DeploymentStatus status = progress.getDeploymentStatus();
                if (status.isFailed()) {
                    failure = status.getFailure();
                    this.undeploy(deploymentName);
                }
            }
        }
        catch (Exception e) {
            throw new DeploymentException("Could not deploy " + deploymentName, (Throwable)e);
        }
        if (failure != null) {
            throw new DeploymentException("Failed to deploy " + deploymentName, (Throwable)failure);
        }
    }

    private void undeploy(String name) throws DeploymentException {
        try {
            DeploymentProgress stopProgress = this.deploymentManager.stop(new String[]{name});
            stopProgress.run();
            DeploymentProgress undeployProgress = this.deploymentManager.remove(new String[]{name});
            undeployProgress.run();
            if (undeployProgress.getDeploymentStatus().isFailed()) {
                this.failedUndeployments.add(name);
            }
        }
        catch (Exception e) {
            throw new DeploymentException("Could not undeploy " + name, (Throwable)e);
        }
    }

    private void removeFailedUnDeployments() throws IOException {
        Server server = this.manager.getServer(this.configuration.getProfileName());
        ArrayList remainingDeployments = new ArrayList();
        for (String name : this.failedUndeployments) {
            try {
                server.undeploy(new File(name));
            }
            catch (Exception e) {
                IOException ioe = new IOException();
                ioe.initCause(e);
                throw ioe;
            }
        }
        if (remainingDeployments.size() > 0) {
            log.severe("Failed to undeploy these artifacts: " + remainingDeployments);
        }
        this.failedUndeployments.clear();
    }

    private void initProfileService(Server server) throws Exception {
        Context ctx = server.getNamingContext();
        this.contextInst.set((Object)ctx);
        this.profileService = (ProfileService)ctx.lookup("ProfileService");
        this.deploymentManager = this.profileService.getDeploymentManager();
        ProfileKey defaultKey = new ProfileKey(DEFAULT_PROFILE_KEY_NAME);
        this.deploymentManager.loadProfile(defaultKey);
    }

    private ServerManager createAndConfigureServerManager() {
        ArquillianServerManager manager = new ArquillianServerManager(this.configuration.getStartupTimeoutInSeconds(), this.configuration.getShutdownTimeoutInSeconds());
        if (this.configuration.getJbossHome() != null) {
            manager.setJbossHome(this.configuration.getJbossHome());
        }
        if (this.configuration.getJavaHome() != null) {
            manager.setJavaHome(this.configuration.getJavaHome());
        }
        manager.addServer(this.createAndConfigureServer());
        return manager;
    }

    private Server createAndConfigureServer() {
        Server server = new Server();
        server.setName(this.configuration.getProfileName());
        server.setHttpPort(Integer.valueOf(this.httpPort()));
        server.setRmiPort(Integer.valueOf(this.rmiPort()));
        server.setHost(this.configuration.getBindAddress());
        server.setHasWebServer(!this.configuration.isUseRmiPortForAliveCheck());
        server.setUsername("admin");
        server.setPassword("admin");
        if (this.configuration.getPartition() != null) {
            server.setPartition(this.configuration.getPartition());
        } else {
            server.setPartition(Long.toHexString(System.currentTimeMillis()));
        }
        this.setServerVMArgs(server, this.javaVmArguments());
        Property prop = new Property();
        prop.setKey("jbosstest.udp.ip_ttl");
        prop.setValue("0");
        server.addSysProperty(prop);
        prop = new Property();
        prop.setKey("java.endorsed.dirs");
        prop.setValue(new File(this.configuration.getJbossHome(), "lib/endorsed").getAbsolutePath());
        server.addSysProperty(prop);
        return server;
    }

    private int httpPort() {
        JBossASConfiguration.JBossBindingSet jbossBindingSet = this.getJBossBindingSet();
        if (jbossBindingSet == null) {
            return this.configuration.getHttpPort();
        }
        return jbossBindingSet.getHttpPort();
    }

    private int rmiPort() {
        JBossASConfiguration.JBossBindingSet jbossBindingSet = this.getJBossBindingSet();
        if (jbossBindingSet == null) {
            return this.configuration.getRmiPort();
        }
        return jbossBindingSet.getRmiPort();
    }

    private JBossASConfiguration.JBossBindingSet getJBossBindingSet() {
        return JBossASConfiguration.JBossBindingSet.getBindingSet(this.configuration.getPortBindingSet());
    }

    private String javaVmArguments() {
        String javaVmArguments = this.configuration.getJavaVmArguments();
        if (this.configuration.getPortBindingSet() != null) {
            javaVmArguments = javaVmArguments + " -Djboss.service.binding.set=" + this.configuration.getPortBindingSet();
        }
        return javaVmArguments;
    }

    private void setServerVMArgs(Server server, String arguments) {
        for (String argument : arguments.split(" ")) {
            Argument arg = new Argument();
            arg.setValue(argument);
            server.addJvmArg(arg);
        }
    }
}

