/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.jbossas.remote_5_0;

import java.io.ByteArrayInputStream;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.jboss.arquillian.container.spi.client.protocol.metadata.HTTPContext;
import org.jboss.arquillian.container.spi.client.protocol.metadata.ProtocolMetaData;
import org.jboss.arquillian.container.spi.client.protocol.metadata.Servlet;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ManagementViewParser {
    public static ProtocolMetaData parse(String archiveName, MBeanServerConnection connection) throws Exception {
        ProtocolMetaData metaData = new ProtocolMetaData();
        HTTPContext httpContext = ManagementViewParser.extractHTTPContext(connection);
        metaData.addContext((Object)httpContext);
        ManagementViewParser.scanDeployment(connection, httpContext, archiveName);
        return metaData;
    }

    private static void scanDeployment(MBeanServerConnection connection, HTTPContext httpContext, String archiveName) throws Exception {
        ObjectName earExpression = new ObjectName("*:*,J2EEApplication=" + archiveName);
        Set<ObjectName> deployments = connection.queryNames(earExpression, null);
        for (ObjectName deployment : deployments) {
            if (!deployment.getKeyProperty("j2eeType").equals("WebModule")) continue;
            ManagementViewParser.scanWar(connection, httpContext, deployment);
        }
    }

    private static void scanWar(MBeanServerConnection connection, HTTPContext httpContext, ObjectName war) throws Exception {
        String descriptor = (String)connection.getAttribute(war, "deploymentDescriptor");
        List<String> servletNames = ManagementViewParser.extractServletNames(descriptor);
        for (String servletName : servletNames) {
            Set<ObjectName> servletObjects = connection.queryNames(new ObjectName("*:*,J2EEApplication=none,J2EEServer=none,j2eeType=Servlet,name=" + servletName), null);
            for (ObjectName servletObject : servletObjects) {
                String contextRoot = servletObject.getKeyProperty("WebModule").replaceAll(".*\\/(.*)", "$1");
                httpContext.add(new Servlet(servletName, contextRoot));
            }
        }
    }

    private static HTTPContext extractHTTPContext(MBeanServerConnection connection) throws Exception {
        Set<ObjectName> connectors = connection.queryNames(new ObjectName("jboss.web:*,type=Connector"), null);
        for (ObjectName connector : connectors) {
            String protocol = (String)connection.getAttribute(connector, "protocol");
            if (!protocol.contains("HTTP")) continue;
            String address = ((InetAddress)connection.getAttribute(connector, "address")).getHostAddress();
            Integer port = Integer.parseInt(connector.getKeyProperty("port"));
            return new HTTPContext(address, port.intValue());
        }
        return null;
    }

    private static List<String> extractServletNames(String descriptor) throws Exception {
        Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(descriptor.getBytes()));
        XPathExpression xPathExpression = XPathFactory.newInstance().newXPath().compile("/web-app/servlet/servlet-name");
        NodeList nodes = (NodeList)xPathExpression.evaluate(doc, XPathConstants.NODESET);
        ArrayList<String> servletNames = new ArrayList<String>();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            servletNames.add(node.getTextContent());
        }
        return servletNames;
    }
}

