/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.jbossas.remote_6;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import org.jboss.arquillian.container.jbossas.remote_6.JBossASConfiguration;
import org.jboss.arquillian.protocol.servlet_3.ServletMethodExecutor;
import org.jboss.arquillian.spi.Configuration;
import org.jboss.arquillian.spi.ContainerMethodExecutor;
import org.jboss.arquillian.spi.Context;
import org.jboss.arquillian.spi.DeployableContainer;
import org.jboss.arquillian.spi.DeploymentException;
import org.jboss.arquillian.spi.LifecycleException;
import org.jboss.deployers.spi.management.deploy.DeploymentManager;
import org.jboss.deployers.spi.management.deploy.DeploymentProgress;
import org.jboss.deployers.spi.management.deploy.DeploymentStatus;
import org.jboss.profileservice.spi.ProfileKey;
import org.jboss.profileservice.spi.ProfileService;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossASRemoteContainer
implements DeployableContainer {
    private final List<String> failedUndeployments = new ArrayList<String>();
    private DeploymentManager deploymentManager;
    private HttpServer httpFileServer;
    private JBossASConfiguration configuration;

    public void setup(Context context, Configuration configuration) {
        this.configuration = (JBossASConfiguration)configuration.getContainerConfig(JBossASConfiguration.class);
    }

    public void start(Context context) throws LifecycleException {
        try {
            this.httpFileServer = HttpServer.create();
            this.httpFileServer.bind(new InetSocketAddress(InetAddress.getByName(this.configuration.getLocalDeploymentBindAddress()), this.configuration.getLocalDeploymentBindPort()), -1);
            this.httpFileServer.start();
            this.initDeploymentManager();
            this.stopDeploymentScanner();
        }
        catch (Exception e) {
            throw new LifecycleException("Could not connect to container", (Throwable)e);
        }
    }

    public void stop(Context context) throws LifecycleException {
        try {
            this.httpFileServer.stop(0);
            this.removeFailedUnDeployments();
            this.startDeploymentScanner();
        }
        catch (Exception e) {
            throw new LifecycleException("Could not clean up", (Throwable)e);
        }
    }

    public ContainerMethodExecutor deploy(Context context, final Archive<?> archive) throws DeploymentException {
        if (archive == null) {
            throw new IllegalArgumentException("Archive must be specified");
        }
        if (this.deploymentManager == null) {
            throw new IllegalStateException("start has not been called!");
        }
        String deploymentName = archive.getName();
        Exception failure = null;
        try {
            this.httpFileServer.createContext("/" + deploymentName, new HttpHandler(){

                public void handle(HttpExchange exchange) throws IOException {
                    InputStream zip = ((ZipExporter)archive.as(ZipExporter.class)).exportZip();
                    ByteArrayOutputStream zipStream = new ByteArrayOutputStream();
                    JBossASRemoteContainer.copy(zip, zipStream);
                    zip.close();
                    byte[] zipArray = zipStream.toByteArray();
                    exchange.sendResponseHeaders(200, zipArray.length);
                    OutputStream out = exchange.getResponseBody();
                    out.write(zipArray);
                    out.close();
                }
            });
            URL fileServerUrl = this.createFileServerURL(deploymentName);
            DeploymentProgress distribute = this.deploymentManager.distribute(deploymentName, fileServerUrl, true);
            distribute.run();
            DeploymentStatus uploadStatus = distribute.getDeploymentStatus();
            if (uploadStatus.isFailed()) {
                failure = uploadStatus.getFailure();
                this.undeploy(deploymentName);
            } else {
                DeploymentProgress progress = this.deploymentManager.start(new String[]{deploymentName});
                progress.run();
                DeploymentStatus status = progress.getDeploymentStatus();
                if (status.isFailed()) {
                    failure = status.getFailure();
                    this.undeploy(deploymentName);
                }
            }
        }
        catch (Exception e) {
            throw new DeploymentException("Could not deploy " + deploymentName, (Throwable)e);
        }
        if (failure != null) {
            throw new DeploymentException("Failed to deploy " + deploymentName, (Throwable)failure);
        }
        try {
            return new ServletMethodExecutor(new URL("http", this.configuration.getRemoteServerAddress(), this.configuration.getRemoteServerHttpPort(), "/"));
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create ContianerMethodExecutor", e);
        }
    }

    public void undeploy(Context context, Archive<?> archive) throws DeploymentException {
        if (archive == null) {
            throw new IllegalArgumentException("Archive must be specified");
        }
        this.undeploy(archive.getName());
    }

    private void undeploy(String name) throws DeploymentException {
        try {
            DeploymentProgress stopProgress = this.deploymentManager.stop(new String[]{name});
            stopProgress.run();
            DeploymentProgress undeployProgress = this.deploymentManager.remove(new String[]{name});
            undeployProgress.run();
            if (undeployProgress.getDeploymentStatus().isFailed()) {
                this.failedUndeployments.add(name);
            }
            this.httpFileServer.removeContext("/" + name);
        }
        catch (Exception e) {
            throw new DeploymentException("Could not undeploy " + name, (Throwable)e);
        }
    }

    private void initDeploymentManager() throws Exception {
        String profileName = this.configuration.getProfileName();
        InitialContext ctx = new InitialContext();
        ProfileService ps = (ProfileService)ctx.lookup("ProfileService");
        this.deploymentManager = ps.getDeploymentManager();
        ProfileKey defaultKey = new ProfileKey(profileName);
        this.deploymentManager.loadProfile(defaultKey);
    }

    private URL createFileServerURL(String archiveName) {
        try {
            InetSocketAddress address = this.httpFileServer.getAddress();
            return new URL("http", address.getHostName(), address.getPort(), "/" + archiveName);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Could not create fileserver url", e);
        }
    }

    private void removeFailedUnDeployments() throws IOException {
        ArrayList<String> remainingDeployments = new ArrayList<String>();
        for (String name : this.failedUndeployments) {
            try {
                DeploymentProgress undeployProgress = this.deploymentManager.remove(new String[]{name});
                undeployProgress.run();
                if (!undeployProgress.getDeploymentStatus().isFailed()) continue;
                remainingDeployments.add(name);
            }
            catch (Exception e) {
                IOException ioe = new IOException();
                ioe.initCause(e);
                throw ioe;
            }
        }
        if (remainingDeployments.size() > 0) {
            // empty if block
        }
        this.failedUndeployments.clear();
    }

    private static void copy(InputStream source, OutputStream destination) throws IOException {
        if (source == null) {
            throw new IllegalArgumentException("source must be specified");
        }
        if (destination == null) {
            throw new IllegalArgumentException("destination must be specified");
        }
        byte[] readBuffer = new byte[2156];
        int bytesIn = 0;
        while ((bytesIn = source.read(readBuffer)) != -1) {
            destination.write(readBuffer, 0, bytesIn);
        }
    }

    private void startDeploymentScanner() throws Exception {
        ObjectName DEPLOYMNET_SCANNER = new ObjectName("jboss.deployment:flavor=URL,type=DeploymentScanner");
        MBeanServerConnection adaptor = (MBeanServerConnection)new InitialContext().lookup("jmx/invoker/RMIAdaptor");
        adaptor.invoke(DEPLOYMNET_SCANNER, "start", new Object[0], new String[0]);
    }

    private void stopDeploymentScanner() throws Exception {
        ObjectName DEPLOYMNET_SCANNER = new ObjectName("jboss.deployment:flavor=URL,type=DeploymentScanner");
        MBeanServerConnection adaptor = (MBeanServerConnection)new InitialContext().lookup("jmx/invoker/RMIAdaptor");
        adaptor.invoke(DEPLOYMNET_SCANNER, "stop", new Object[0], new String[0]);
    }
}

