/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.jbossas.remote_6;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import org.jboss.arquillian.container.jbossas.remote_6.JBossASConfiguration;
import org.jboss.arquillian.container.jbossas.remote_6.ManagementViewParser;
import org.jboss.arquillian.container.jbossas.remote_6.ShrinkWrapUtil;
import org.jboss.arquillian.container.spi.client.container.DeployableContainer;
import org.jboss.arquillian.container.spi.client.container.DeploymentException;
import org.jboss.arquillian.container.spi.client.container.LifecycleException;
import org.jboss.arquillian.container.spi.client.protocol.ProtocolDescription;
import org.jboss.arquillian.container.spi.client.protocol.metadata.ProtocolMetaData;
import org.jboss.arquillian.container.spi.context.annotation.ContainerScoped;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.deployers.spi.management.deploy.DeploymentManager;
import org.jboss.deployers.spi.management.deploy.DeploymentProgress;
import org.jboss.deployers.spi.management.deploy.DeploymentStatus;
import org.jboss.profileservice.spi.ProfileKey;
import org.jboss.profileservice.spi.ProfileService;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.descriptor.api.Descriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossASRemoteContainer
implements DeployableContainer<JBossASConfiguration> {
    private static final String DEFAULT_PROFILE_KEY_NAME = "jboss:profile=applications";
    private final List<String> failedUndeployments = new ArrayList<String>();
    private ProfileService profileService;
    private DeploymentManager deploymentManager;
    private JBossASConfiguration configuration;
    @Inject
    @ContainerScoped
    private InstanceProducer<Context> contextInst;

    public ProtocolDescription getDefaultProtocol() {
        return new ProtocolDescription("Servlet 3.0");
    }

    public Class<JBossASConfiguration> getConfigurationClass() {
        return JBossASConfiguration.class;
    }

    public void setup(JBossASConfiguration configuration) {
        this.configuration = configuration;
    }

    public void start() throws LifecycleException {
        try {
            this.initDeploymentManager();
        }
        catch (Exception e) {
            throw new LifecycleException("Could not connect to container", (Throwable)e);
        }
    }

    public void stop() throws LifecycleException {
        try {
            this.removeFailedUnDeployments();
        }
        catch (Exception e) {
            throw new LifecycleException("Could not clean up", (Throwable)e);
        }
    }

    public void deploy(Descriptor descriptor) throws DeploymentException {
        String deploymentName = descriptor.getDescriptorName();
        URL deploymentUrl = ShrinkWrapUtil.toURL(descriptor);
        this.deploy(deploymentName, deploymentUrl);
    }

    public void undeploy(Descriptor descriptor) throws DeploymentException {
        this.undeploy(descriptor.getDescriptorName());
    }

    public ProtocolMetaData deploy(Archive<?> archive) throws DeploymentException {
        String deploymentName = archive.getName();
        URL deploymentUrl = ShrinkWrapUtil.toURL(archive);
        this.deploy(deploymentName, deploymentUrl);
        try {
            return ManagementViewParser.parse(deploymentName, this.profileService);
        }
        catch (Exception e) {
            throw new DeploymentException("Could not extract deployment metadata", (Throwable)e);
        }
    }

    public void undeploy(Archive<?> archive) throws DeploymentException {
        this.undeploy(archive.getName());
    }

    private void deploy(String deploymentName, URL url) throws DeploymentException {
        Exception failure = null;
        try {
            DeploymentProgress distribute = this.deploymentManager.distribute(deploymentName, url, true);
            distribute.run();
            DeploymentStatus uploadStatus = distribute.getDeploymentStatus();
            if (uploadStatus.isFailed()) {
                failure = uploadStatus.getFailure();
                this.undeploy(deploymentName);
            } else {
                DeploymentProgress progress = this.deploymentManager.start(new String[]{deploymentName});
                progress.run();
                DeploymentStatus status = progress.getDeploymentStatus();
                if (status.isFailed()) {
                    failure = status.getFailure();
                    this.undeploy(deploymentName);
                }
            }
        }
        catch (Exception e) {
            throw new DeploymentException("Could not deploy " + deploymentName, (Throwable)e);
        }
        if (failure != null) {
            throw new DeploymentException("Failed to deploy " + deploymentName, (Throwable)failure);
        }
    }

    private void undeploy(String name) throws DeploymentException {
        try {
            DeploymentProgress stopProgress = this.deploymentManager.stop(new String[]{name});
            stopProgress.run();
            DeploymentProgress undeployProgress = this.deploymentManager.remove(new String[]{name});
            undeployProgress.run();
            if (undeployProgress.getDeploymentStatus().isFailed()) {
                this.failedUndeployments.add(name);
            }
        }
        catch (Exception e) {
            throw new DeploymentException("Could not undeploy " + name, (Throwable)e);
        }
    }

    private void initDeploymentManager() throws Exception {
        Context ctx = this.createContext();
        this.profileService = (ProfileService)ctx.lookup("ProfileService");
        this.deploymentManager = this.profileService.getDeploymentManager();
        ProfileKey defaultKey = new ProfileKey(DEFAULT_PROFILE_KEY_NAME);
        this.deploymentManager.loadProfile(defaultKey);
    }

    private Context createContext() throws Exception {
        if (this.contextInst.get() == null) {
            Properties props = new Properties();
            props.put("java.naming.factory.initial", this.configuration.getContextFactory());
            props.put("java.naming.factory.url.pkgs", this.configuration.getUrlPkgPrefix());
            props.put("java.naming.provider.url", this.configuration.getProviderUrl());
            this.contextInst.set((Object)new InitialContext(props));
        }
        return (Context)this.contextInst.get();
    }

    private void removeFailedUnDeployments() throws IOException {
        ArrayList<String> remainingDeployments = new ArrayList<String>();
        for (String name : this.failedUndeployments) {
            try {
                DeploymentProgress undeployProgress = this.deploymentManager.remove(new String[]{name});
                undeployProgress.run();
                if (!undeployProgress.getDeploymentStatus().isFailed()) continue;
                remainingDeployments.add(name);
            }
            catch (Exception e) {
                IOException ioe = new IOException();
                ioe.initCause(e);
                throw ioe;
            }
        }
        if (remainingDeployments.size() > 0) {
            // empty if block
        }
        this.failedUndeployments.clear();
    }
}

