/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.jbossas.remote_6;

import java.util.Map;
import java.util.Set;
import org.jboss.arquillian.container.spi.client.protocol.metadata.HTTPContext;
import org.jboss.arquillian.container.spi.client.protocol.metadata.ProtocolMetaData;
import org.jboss.arquillian.container.spi.client.protocol.metadata.Servlet;
import org.jboss.deployers.spi.management.ManagementView;
import org.jboss.managed.api.ManagedComponent;
import org.jboss.managed.api.ManagedDeployment;
import org.jboss.profileservice.spi.NoSuchDeploymentException;
import org.jboss.profileservice.spi.ProfileService;

public final class ManagementViewParser {
    public static ProtocolMetaData parse(String archiveName, ProfileService profile) throws Exception {
        ProtocolMetaData metaData = new ProtocolMetaData();
        ManagementView management = profile.getViewManager();
        management.load();
        HTTPContext httpContext = ManagementViewParser.extractHTTPContext(management);
        if (httpContext != null) {
            metaData.addContext((Object)httpContext);
        }
        ManagementViewParser.scanDeployment(management, httpContext, management.getDeployment(archiveName));
        return metaData;
    }

    private static HTTPContext extractHTTPContext(ManagementView management) throws Exception {
        Set contextRootDeployments = management.getMatchingDeploymentName("http\\-.*");
        if (contextRootDeployments.size() > 0) {
            String deploymentName = (String)contextRootDeployments.iterator().next();
            String expression = ".*\\-.*?(\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3})-(.*)";
            return new HTTPContext(deploymentName.replaceAll(expression, "$1"), Integer.parseInt(deploymentName.replaceAll(expression, "$2")));
        }
        return null;
    }

    private static void scanDeployment(ManagementView management, HTTPContext context, ManagedDeployment parent) throws NoSuchDeploymentException {
        Map components = parent.getComponents();
        for (Map.Entry entry : components.entrySet()) {
            ManagedComponent value = (ManagedComponent)entry.getValue();
            if (!value.getType().getType().equals("WAR")) continue;
            ManagementViewParser.scanWar(management, context, value);
        }
        for (ManagedDeployment child : parent.getChildren()) {
            ManagementViewParser.scanDeployment(management, context, child);
        }
    }

    private static void scanWar(ManagementView management, HTTPContext context, ManagedComponent value) throws NoSuchDeploymentException {
        String contextRoot = (String)value.getProperty("contextRoot").getField("value", String.class);
        Set contextRootDeployments = management.getMatchingDeploymentName("//.*" + contextRoot);
        for (String contextRootDeployment : contextRootDeployments) {
            ManagedDeployment warDeployment = management.getDeployment(contextRootDeployment);
            for (Map.Entry warComponentEntry : warDeployment.getComponents().entrySet()) {
                ManagedComponent comp = (ManagedComponent)warComponentEntry.getValue();
                if (!comp.getType().getSubtype().equals("Servlet")) continue;
                String servletName = comp.getNameType().replaceFirst(".*,name=(.*)", "$1");
                context.add(new Servlet(servletName, contextRoot));
            }
        }
    }
}

