/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.jetty;

public class VersionUtil {
    private static String expression = "([0-9]{1,5})\\.([0-9]{1,5}).*";

    private VersionUtil() {
    }

    public static Version extract(String version) {
        if (version == null || !version.matches(expression)) {
            return new Version(0, 0);
        }
        return new Version(Integer.parseInt(version.replaceAll(expression, "$1")), Integer.parseInt(version.replaceAll(expression, "$2")));
    }

    public static boolean isGraterThenOrEqual(String greater, String then) {
        return VersionUtil.isGraterThenOrEqual(VersionUtil.extract(greater), VersionUtil.extract(then));
    }

    public static boolean isGraterThenOrEqual(Version greater, Version then) {
        return greater.compareTo(then) >= 0;
    }

    public static boolean isLessThenOrEqual(String less, String then) {
        return VersionUtil.isLessThenOrEqual(VersionUtil.extract(less), VersionUtil.extract(then));
    }

    public static boolean isLessThenOrEqual(Version less, Version then) {
        return less.compareTo(then) <= 0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Version
    implements Comparable<Version> {
        private Integer major;
        private Integer minor;

        public Version(int major, int minor) {
            this.major = major;
            this.minor = minor;
        }

        public int getMajor() {
            return this.major;
        }

        public int getMinor() {
            return this.minor;
        }

        @Override
        public int compareTo(Version o) {
            int majorCompare = this.major.compareTo(o.major);
            if (majorCompare == 0) {
                return this.minor.compareTo(o.minor);
            }
            return majorCompare;
        }
    }
}

