/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.jetty.embedded_11;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Locale;
import java.util.logging.Logger;
import org.eclipse.jetty.annotations.AnnotationConfiguration;
import org.eclipse.jetty.deploy.App;
import org.eclipse.jetty.deploy.AppProvider;
import org.eclipse.jetty.deploy.DeploymentManager;
import org.eclipse.jetty.deploy.util.FileID;
import org.eclipse.jetty.plus.webapp.EnvConfiguration;
import org.eclipse.jetty.plus.webapp.PlusConfiguration;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.webapp.Configuration;
import org.eclipse.jetty.webapp.FragmentConfiguration;
import org.eclipse.jetty.webapp.JettyWebXmlConfiguration;
import org.eclipse.jetty.webapp.WebAppContext;
import org.jboss.arquillian.container.jetty.embedded_11.JettyEmbeddedConfiguration;
import org.jboss.arquillian.container.jetty.embedded_11.WebAppContextProcessor;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;

public class ArquillianAppProvider
extends AbstractLifeCycle
implements AppProvider {
    private static final Logger LOG;
    private static final String EXPORT_FILE_PREFIX = "export";
    private static final File EXPORT_DIR;
    private final JettyEmbeddedConfiguration config;
    private DeploymentManager deploymentManager;
    private final Collection<WebAppContextProcessor> webAppContextProcessors;

    public ArquillianAppProvider(JettyEmbeddedConfiguration config, Collection<WebAppContextProcessor> webAppContextProcessors) {
        this.config = config;
        this.webAppContextProcessors = webAppContextProcessors;
    }

    protected App createApp(Archive<?> archive) {
        File exported;
        String name = archive.getName();
        int extOff = name.lastIndexOf(46);
        if (extOff <= 0) {
            throw new RuntimeException("Not a valid Web Archive filename: " + name);
        }
        String ext = name.substring(extOff).toLowerCase();
        if (!ext.equals(".war")) {
            throw new RuntimeException("Not a recognized Web Archive: " + name);
        }
        name = name.substring(0, extOff);
        try {
            if (this.config.isUseArchiveNameAsContext()) {
                Path tmpDirectory = Files.createTempDirectory("arquillian-jetty", new FileAttribute[0]);
                Path archivePath = tmpDirectory.resolveSibling(archive.getName());
                Files.deleteIfExists(archivePath);
                exported = Files.createFile(archivePath, new FileAttribute[0]).toFile();
                exported.deleteOnExit();
            } else {
                exported = File.createTempFile(EXPORT_FILE_PREFIX, archive.getName(), EXPORT_DIR);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Could not create temporary File in " + EXPORT_DIR + " to write exported archive", e);
        }
        ((ZipExporter)archive.as(ZipExporter.class)).exportTo(exported, true);
        URI uri = exported.toURI();
        LOG.info("Webapp archive location: " + uri.toASCIIString());
        return new ArchiveApp(this.deploymentManager, this, uri.toASCIIString(), archive);
    }

    public ContextHandler createContextHandler(App app) throws Exception {
        Resource resource = Resource.newResource((String)app.getOriginId());
        File file = resource.getFile();
        if (!resource.exists()) {
            throw new IllegalStateException("App resouce does not exist " + resource);
        }
        Object context = file.getName();
        if (!FileID.isWebArchiveFile((File)file)) {
            throw new IllegalStateException("unable to create ContextHandler for " + app);
        }
        context = ((String)context).substring(0, ((String)context).length() - 4);
        if (((String)context).endsWith("/") && ((String)context).length() > 0) {
            context = ((String)context).substring(0, ((String)context).length() - 1);
        }
        WebAppContext webAppContext = new WebAppContext();
        webAppContext.setDisplayName((String)context);
        webAppContext.setLogUrlOnStart(true);
        String configuredConfigurationClasses = this.config.getConfigurationClasses();
        if (configuredConfigurationClasses != null && configuredConfigurationClasses.trim().length() > 0) {
            webAppContext.setConfigurationClasses(configuredConfigurationClasses.split(","));
        } else {
            webAppContext.addConfiguration(new Configuration[]{new JettyWebXmlConfiguration(), new AnnotationConfiguration()});
            webAppContext.addConfiguration(new Configuration[]{new FragmentConfiguration(), new EnvConfiguration(), new PlusConfiguration()});
        }
        if (((String)context).equalsIgnoreCase("root")) {
            context = "/";
        } else if (((String)context).toLowerCase(Locale.ENGLISH).startsWith("root-")) {
            int dash = ((String)context).toLowerCase(Locale.ENGLISH).indexOf(45);
            String virtual = ((String)context).substring(dash + 1);
            webAppContext.setVirtualHosts(new String[]{virtual});
            context = "/";
        }
        if (((String)context).charAt(0) != '/') {
            context = "/" + (String)context;
        }
        webAppContext.setContextPath((String)context);
        webAppContext.setWar(file.getAbsolutePath());
        if (this.config.hasDefaultsDescriptor()) {
            webAppContext.setDefaultsDescriptor(this.config.getDefaultsDescriptor().toASCIIString());
        }
        webAppContext.setExtractWAR(true);
        webAppContext.setParentLoaderPriority(this.config.getClassloaderBehavior() == JettyEmbeddedConfiguration.ClassLoaderBehavior.JAVA_SPEC);
        if (this.config.getTempDirectory() != null) {
            webAppContext.setAttribute("org.eclipse.jetty.webapp.basetempdir", (Object)this.config.getTempDirectory());
        }
        this.webAppContextProcessors.forEach(processor -> processor.process(webAppContext, ((ArchiveApp)app).archive));
        return webAppContext;
    }

    public void setDeploymentManager(DeploymentManager deploymentManager) {
        this.deploymentManager = deploymentManager;
    }

    static {
        File targetDir;
        File baseDir;
        LOG = Logger.getLogger(ArquillianAppProvider.class.getName());
        File systemDefaultTmpDir = new File(System.getProperty("java.io.tmpdir"));
        String baseDirVal = System.getProperty("basedir");
        File mavenTmpDir = null;
        if (baseDirVal != null && (baseDir = new File(baseDirVal)).exists() && baseDir.isDirectory() && (targetDir = new File(baseDir, "target")).exists() && targetDir.isDirectory()) {
            mavenTmpDir = new File(targetDir, "arquillian-jetty-temp");
            mavenTmpDir.mkdirs();
        }
        if (!(EXPORT_DIR = mavenTmpDir != null && mavenTmpDir.exists() && mavenTmpDir.isDirectory() ? mavenTmpDir : systemDefaultTmpDir).exists() || !EXPORT_DIR.isDirectory()) {
            throw new IllegalStateException("Could not obtain export directory \"" + EXPORT_DIR.getAbsolutePath() + "\"");
        }
    }

    private static class ArchiveApp
    extends App {
        private final Archive<?> archive;

        public ArchiveApp(DeploymentManager manager, AppProvider provider, String originId, Archive<?> archive) {
            super(manager, provider, originId);
            this.archive = archive;
        }
    }
}

