/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.jetty.embedded_11;

import jakarta.servlet.ServletContext;
import java.io.File;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.eclipse.jetty.deploy.App;
import org.eclipse.jetty.deploy.AppProvider;
import org.eclipse.jetty.deploy.DeploymentManager;
import org.eclipse.jetty.http.CookieCompliance;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.http2.server.HTTP2CServerConnectionFactory;
import org.eclipse.jetty.security.HashLoginService;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.servlet.ServletHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.webapp.WebAppContext;
import org.jboss.arquillian.container.jetty.EnvUtil;
import org.jboss.arquillian.container.jetty.embedded_11.ArquillianAppProvider;
import org.jboss.arquillian.container.jetty.embedded_11.JettyEmbeddedConfiguration;
import org.jboss.arquillian.container.jetty.embedded_11.WebAppContextProcessor;
import org.jboss.arquillian.container.spi.client.container.DeployableContainer;
import org.jboss.arquillian.container.spi.client.container.DeploymentException;
import org.jboss.arquillian.container.spi.client.container.LifecycleException;
import org.jboss.arquillian.container.spi.client.protocol.ProtocolDescription;
import org.jboss.arquillian.container.spi.client.protocol.metadata.HTTPContext;
import org.jboss.arquillian.container.spi.client.protocol.metadata.ProtocolMetaData;
import org.jboss.arquillian.container.spi.client.protocol.metadata.Servlet;
import org.jboss.arquillian.container.spi.context.annotation.DeploymentScoped;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.ApplicationScoped;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.spi.ServiceLoader;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.descriptor.api.Descriptor;

public class JettyEmbeddedContainer
implements DeployableContainer<JettyEmbeddedConfiguration> {
    private static final Logger log = Logger.getLogger(JettyEmbeddedContainer.class.getName());
    private Server server;
    private String listeningHost;
    private int listeningPort;
    private DeploymentManager deployer;
    private ArquillianAppProvider appProvider;
    private JettyEmbeddedConfiguration containerConfig;
    @Inject
    @DeploymentScoped
    private InstanceProducer<App> webAppContextProducer;
    @Inject
    @ApplicationScoped
    private InstanceProducer<ServletContext> servletContextInstanceProducer;
    @Inject
    private Instance<ServiceLoader> serviceLoader;

    public Class<JettyEmbeddedConfiguration> getConfigurationClass() {
        return JettyEmbeddedConfiguration.class;
    }

    public ProtocolDescription getDefaultProtocol() {
        return new ProtocolDescription("Servlet 5.0");
    }

    public void setup(JettyEmbeddedConfiguration containerConfig) {
        this.containerConfig = containerConfig;
    }

    public void start() throws LifecycleException {
        EnvUtil.assertMinimumJettyVersion((String)Server.getVersion(), (String)"11.0");
        try {
            ServerConnector connector;
            this.server = new Server();
            HttpConfiguration httpConfig = this.getHttpConfiguration();
            HttpConnectionFactory connectionFactory = new HttpConnectionFactory(httpConfig);
            if (this.containerConfig.isSsl()) {
                SslContextFactory.Server sslContextFactory = this.getSslContextFactory();
                this.server.addBean((Object)sslContextFactory);
                SslConnectionFactory sslConnectionFactory = new SslConnectionFactory(sslContextFactory, HttpVersion.HTTP_1_1.asString());
                sslConnectionFactory.setEnsureSecureRequestCustomizer(this.containerConfig.isSniRequired());
                connector = new ServerConnector(this.server, new ConnectionFactory[]{sslConnectionFactory, connectionFactory});
            } else {
                connector = new ServerConnector(this.server, new ConnectionFactory[]{connectionFactory});
            }
            if (this.containerConfig.isH2cEnabled()) {
                HTTP2CServerConnectionFactory http2CServerConnectionFactory = new HTTP2CServerConnectionFactory(httpConfig);
                connector.addConnectionFactory((ConnectionFactory)http2CServerConnectionFactory);
            }
            connector.setHost(this.containerConfig.getBindAddress());
            connector.setPort(this.containerConfig.getBindHttpPort());
            connector.setIdleTimeout(this.containerConfig.getIdleTimeoutMillis());
            this.server.setConnectors(new Connector[]{connector});
            ContextHandlerCollection contexts = new ContextHandlerCollection();
            this.deployer = new DeploymentManager();
            this.deployer.setContexts(contexts);
            Collection webAppContextProcessors = ((ServiceLoader)this.serviceLoader.get()).all(WebAppContextProcessor.class);
            this.appProvider = new ArquillianAppProvider(this.containerConfig, webAppContextProcessors);
            this.deployer.addAppProvider((AppProvider)this.appProvider);
            this.server.addBean((Object)this.deployer);
            this.server.setHandler((Handler)new HandlerList(new Handler[]{contexts, new DefaultHandler()}));
            if (this.containerConfig.isRealmPropertiesFileSet()) {
                String realmName = this.getRealmName();
                HashLoginService hashUserRealm = new HashLoginService(realmName, this.containerConfig.getRealmProperties().getAbsolutePath());
                this.server.addBean((Object)hashUserRealm);
            }
            if (this.containerConfig.areInferredEncodings()) {
                this.containerConfig.getInferredEncodings().forEach((s, s2) -> MimeTypes.getInferredEncodings().put(s, s2));
            }
            this.server.setDumpAfterStart(this.containerConfig.isDumpServerAfterStart());
            log.info("Starting Jetty Embedded Server " + Server.getVersion() + " [id:" + this.server.hashCode() + "]");
            this.server.start();
            this.listeningHost = connector.getHost();
            if (this.listeningHost == null) {
                this.listeningHost = this.containerConfig.getBindAddress();
            }
            this.listeningPort = connector.getLocalPort();
        }
        catch (Exception e) {
            throw new LifecycleException("Could not start container", (Throwable)e);
        }
    }

    private String getRealmName() {
        File realmProperties = this.containerConfig.getRealmProperties();
        String fileName = realmProperties.getName();
        int index = fileName.indexOf(46);
        if (index > -1) {
            fileName = fileName.substring(0, index);
        }
        return fileName;
    }

    public void stop() throws LifecycleException {
        try {
            log.info("Stopping Jetty Embedded Server [id:" + this.server.hashCode() + "]");
            this.server.stop();
        }
        catch (Exception e) {
            throw new LifecycleException("Could not stop container", (Throwable)e);
        }
    }

    public void deploy(Descriptor descriptor) throws DeploymentException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void undeploy(Descriptor descriptor) throws DeploymentException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public ProtocolMetaData deploy(Archive<?> archive) throws DeploymentException {
        try {
            App app = this.appProvider.createApp(archive);
            this.deployer.removeApp(app);
            WebAppContext webAppContext = this.getWebAppContext(app);
            if (this.containerConfig.areMimeTypesSet()) {
                MimeTypes mimeTypes = this.getMimeTypes();
                webAppContext.setMimeTypes(mimeTypes);
            }
            this.deployer.addApp(app);
            this.deployer.requestAppGoal(app, "started");
            this.webAppContextProducer.set((Object)app);
            this.servletContextInstanceProducer.set((Object)webAppContext.getServletContext());
            HTTPContext httpContext = new HTTPContext(this.listeningHost, this.listeningPort);
            ServletHandler servletHandler = webAppContext.getServletHandler();
            for (ServletHolder servlet : servletHandler.getServlets()) {
                httpContext.add(new Servlet(servlet.getName(), servlet.getContextPath()));
            }
            return new ProtocolMetaData().addContext((Object)httpContext);
        }
        catch (Exception e) {
            throw new DeploymentException("Could not deploy " + archive.getName(), (Throwable)e);
        }
    }

    private WebAppContext getWebAppContext(App app) throws Exception {
        ContextHandler handler = app.getContextHandler();
        if (!(handler instanceof WebAppContext)) {
            throw new DeploymentException("Deployment of raw ContextHandler's not supported by Arquillian");
        }
        WebAppContext webAppContext = (WebAppContext)handler;
        return webAppContext;
    }

    private MimeTypes getMimeTypes() {
        Map configuredMimeTypes = this.containerConfig.getMimeTypes();
        Set entries = configuredMimeTypes.entrySet();
        MimeTypes mimeTypes = new MimeTypes();
        entries.forEach(stringStringEntry -> mimeTypes.addMimeMapping((String)stringStringEntry.getKey(), (String)stringStringEntry.getValue()));
        return mimeTypes;
    }

    public void undeploy(Archive<?> archive) throws DeploymentException {
        App app = (App)this.webAppContextProducer.get();
        if (app != null) {
            this.deployer.requestAppGoal(app, "undeployed");
        }
    }

    private HttpConfiguration getHttpConfiguration() {
        SecureRequestCustomizer secureRequestCustomizer;
        HttpConfiguration httpConfig = this.containerConfig.getHttpConfiguration();
        if (httpConfig == null) {
            httpConfig = new HttpConfiguration();
            if (this.containerConfig.isHeaderBufferSizeSet()) {
                httpConfig.setRequestHeaderSize(this.containerConfig.getHeaderBufferSize());
                httpConfig.setResponseHeaderSize(this.containerConfig.getHeaderBufferSize());
            }
            if (this.containerConfig.getRequestCookieCompliance() != null) {
                httpConfig.setRequestCookieCompliance(CookieCompliance.from((String)this.containerConfig.getRequestCookieCompliance()));
            }
            if (this.containerConfig.getResponseCookieCompliance() != null) {
                httpConfig.setResponseCookieCompliance(CookieCompliance.from((String)this.containerConfig.getResponseCookieCompliance()));
            }
        }
        if ((secureRequestCustomizer = (SecureRequestCustomizer)httpConfig.getCustomizer(SecureRequestCustomizer.class)) == null) {
            secureRequestCustomizer = new SecureRequestCustomizer();
            httpConfig.addCustomizer((HttpConfiguration.Customizer)secureRequestCustomizer);
        }
        secureRequestCustomizer.setSniHostCheck(this.containerConfig.isSniHostCheck());
        secureRequestCustomizer.setSniRequired(this.containerConfig.isSniRequired());
        return httpConfig;
    }

    private SslContextFactory.Server getSslContextFactory() {
        SslContextFactory.Server sslContextFactory = new SslContextFactory.Server();
        if (this.containerConfig.getKeystorePath() != null) {
            sslContextFactory.setKeyStorePath(new File(this.containerConfig.getKeystorePath()).getAbsolutePath());
        }
        if (this.containerConfig.getKeystorePassword() != null) {
            sslContextFactory.setKeyStorePassword(this.containerConfig.getKeystorePassword());
        }
        if (this.containerConfig.getTrustStorePath() != null) {
            sslContextFactory.setTrustStorePath(new File(this.containerConfig.getTrustStorePath()).getAbsolutePath());
        }
        if (this.containerConfig.getTrustStorePassword() != null) {
            sslContextFactory.setTrustStorePassword(this.containerConfig.getTrustStorePassword());
        }
        sslContextFactory.setNeedClientAuth(this.containerConfig.isNeedClientAuth());
        sslContextFactory.setSniRequired(this.containerConfig.isSniRequired());
        return sslContextFactory;
    }
}

