/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.reloaded;

import java.lang.reflect.Method;
import org.jboss.arquillian.spi.Context;
import org.jboss.arquillian.spi.TestEnricher;
import org.jboss.arquillian.spi.event.container.BeforeUnDeploy;
import org.jboss.arquillian.spi.event.container.ContainerEvent;
import org.jboss.arquillian.spi.event.suite.EventHandler;
import org.jboss.beans.info.spi.BeanAccessMode;
import org.jboss.beans.metadata.plugins.builder.BeanMetaDataBuilderFactory;
import org.jboss.beans.metadata.spi.builder.BeanMetaDataBuilder;
import org.jboss.bootstrap.api.mc.server.MCServer;
import org.jboss.kernel.spi.dependency.KernelController;

public class ReloadedTestEnricher
implements TestEnricher {
    static final String BIND_NAME_TEST = "org.jboss.arquillian.CurrentTest";

    public void enrich(Context context, Object testCase) {
        MCServer server = (MCServer)context.get(MCServer.class);
        assert (server != null) : "MC Server was not set by the container";
        KernelController controller = server.getKernel().getController();
        BeanMetaDataBuilder bmdb = BeanMetaDataBuilderFactory.createBuilder((String)BIND_NAME_TEST, (String)testCase.getClass().getName()).setAccessMode(BeanAccessMode.ALL);
        try {
            controller.install(bmdb.getBeanMetaData(), testCase);
            context.getParentContext().register(BeforeUnDeploy.class, (EventHandler)new TestCaseUnInstaller());
        }
        catch (Throwable e) {
            throw new RuntimeException("Could not enrich " + testCase + " by installing the instance into MC", e);
        }
    }

    public Object[] resolve(Context context, Method method) {
        return new Object[method.getParameterTypes().length];
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TestCaseUnInstaller
    implements EventHandler<ContainerEvent> {
        private TestCaseUnInstaller() {
        }

        public void callback(Context context, ContainerEvent event) throws Exception {
            ((MCServer)context.get(MCServer.class)).getKernel().getController().uninstall((Object)ReloadedTestEnricher.BIND_NAME_TEST);
        }
    }
}

