/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.tomcat;

import java.io.IOException;
import java.net.URI;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.jboss.arquillian.container.spi.client.container.DeploymentException;
import org.jboss.arquillian.container.spi.client.protocol.metadata.HTTPContext;
import org.jboss.arquillian.container.spi.client.protocol.metadata.ProtocolMetaData;
import org.jboss.arquillian.container.spi.client.protocol.metadata.Servlet;
import org.jboss.arquillian.container.tomcat.TomcatConfiguration;

public class ProtocolMetadataParser<C extends TomcatConfiguration> {
    private static final Logger log = Logger.getLogger(ProtocolMetaData.class.getName());
    private final C configuration;
    protected String catalinaServletTemplate = "Catalina:j2eeType=Servlet,WebModule=//%s/%s,*";

    public ProtocolMetadataParser(C configuration) {
        this.configuration = configuration;
    }

    public ProtocolMetaData retrieveContextServletInfo(String context) throws DeploymentException {
        Set<ObjectInstance> servletMBeans;
        ProtocolMetaData protocolMetaData = new ProtocolMetaData();
        HTTPContext httpContext = new HTTPContext(((TomcatConfiguration)this.configuration).getBindAddress(), ((TomcatConfiguration)this.configuration).getBindHttpPort());
        JMXConnector jmxc = null;
        try {
            jmxc = this.connect(((TomcatConfiguration)this.configuration).getJmxUri());
        }
        catch (IOException ex) {
            throw new DeploymentException("Unable to contruct metadata for archive deployment.\nCan't connect to '" + ((TomcatConfiguration)this.configuration).getJmxUri() + "'.\n   Make sure JMX remote acces is enabled Tomcat's JVM - e.g. in startup.sh using $JAVA_OPTS.\n   Example (with no authentication):\n     -Dcom.sun.management.jmxremote.port=" + ((TomcatConfiguration)this.configuration).getJmxPort() + "\n     -Dcom.sun.management.jmxremote.ssl=false\n     -Dcom.sun.management.jmxremote.authenticate=false", (Throwable)ex);
        }
        try {
            servletMBeans = this.getServletMBeans(jmxc, context);
        }
        catch (IOException e) {
            throw new DeploymentException("Unable to construct metadata for archive deployment", (Throwable)e);
        }
        for (ObjectInstance oi : servletMBeans) {
            String servletName = oi.getObjectName().getKeyProperty("name");
            httpContext.add(new Servlet(servletName, context));
            if (!log.isLoggable(Level.FINE)) continue;
            log.fine("Added servlet " + oi.toString() + " to HttpContext for archive" + context);
        }
        protocolMetaData.addContext((Object)httpContext);
        return protocolMetaData;
    }

    protected JMXConnector connect(URI jmxUri) throws IOException {
        log.info("Connecting to JMX at " + jmxUri);
        JMXServiceURL url = new JMXServiceURL(jmxUri.toASCIIString());
        return JMXConnectorFactory.connect(url, null);
    }

    protected Set<ObjectInstance> getServletMBeans(JMXConnector jmxc, String context) throws IOException {
        ObjectName servletON;
        MBeanServerConnection mbsc = jmxc.getMBeanServerConnection();
        String catalinaServlet = String.format(this.catalinaServletTemplate, ((TomcatConfiguration)this.configuration).getJmxVirtualHost(), context);
        try {
            servletON = ObjectName.getInstance(catalinaServlet);
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalArgumentException("Unable to retrieve catalina MBeans for protocol metadata construction.\nFollowing object name is not valid: " + catalinaServlet, e);
        }
        catch (NullPointerException e) {
            throw new IllegalArgumentException("Unable to retrieve catalina MBeans for protocol metadata construction.\nObject name must not be null", e);
        }
        return mbsc.queryMBeans(servletON, null);
    }
}

