/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.tomcat;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.jboss.arquillian.container.spi.ConfigurationException;
import org.jboss.arquillian.container.spi.client.container.ContainerConfiguration;
import org.jboss.arquillian.container.tomcat.Validate;

public class TomcatConfiguration
implements ContainerConfiguration {
    private static final int MIN_PORT = 0;
    private static final int MAX_PORT = 65535;
    private String bindAddress = "localhost";
    private int bindHttpPort = 8080;
    private String user;
    private String pass;
    private int jmxPort = 8089;
    private int jmxServerPort = 0;
    private String jmxVirtualHost = "localhost";
    private String urlCharset = "ISO-8859-1";
    private String appBase = "webapps";
    private boolean unpackArchive = false;
    private URI jmxUri;
    private URL managerUrl;

    public void validate() throws ConfigurationException {
        Validate.notNullOrEmpty(this.bindAddress, "Bind address must not be null or empty");
        Validate.isInRange(this.jmxPort, 0, 65535, "JMX port must be in interval ]0,65535[, but was " + this.jmxPort);
        Validate.isInRange(this.jmxServerPort, 0, 65535, "JMX server port must be in interval ]0,65535[, but was " + this.jmxServerPort);
        this.jmxUri = this.createJmxUri();
        this.managerUrl = this.createManagerUrl();
    }

    public String getBindAddress() {
        return this.bindAddress;
    }

    public void setBindAddress(String bindAddress) {
        this.bindAddress = bindAddress;
    }

    public int getBindHttpPort() {
        return this.bindHttpPort;
    }

    public void setBindHttpPort(int bindHttpPort) {
        this.bindHttpPort = bindHttpPort;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPass() {
        return this.pass;
    }

    public void setPass(String pass) {
        this.pass = pass;
    }

    public int getJmxPort() {
        return this.jmxPort;
    }

    public void setJmxPort(int jmxPort) {
        this.jmxPort = jmxPort;
    }

    public int getJmxServerPort() {
        return this.jmxServerPort;
    }

    public void setJmxServerPort(int jmxServerPort) {
        this.jmxServerPort = jmxServerPort;
    }

    public String getAppBase() {
        return this.appBase;
    }

    public void setAppBase(String appBase) {
        this.appBase = appBase;
    }

    public boolean isUnpackArchive() {
        return this.unpackArchive;
    }

    public void setUnpackArchive(boolean unpackArchive) {
        this.unpackArchive = unpackArchive;
    }

    public void setUrlCharset(String urlCharset) {
        this.urlCharset = urlCharset;
    }

    public String getUrlCharset() {
        return this.urlCharset;
    }

    public void setJmxVirtualHost(String jmxVirtualHost) {
        this.jmxVirtualHost = jmxVirtualHost;
    }

    public String getJmxVirtualHost() {
        return this.jmxVirtualHost;
    }

    public URI getJmxUri() {
        return this.jmxUri;
    }

    public URL getManagerUrl() {
        return this.managerUrl;
    }

    protected URI createJmxUri() {
        try {
            String uriString;
            if (this.jmxServerPort != 0) {
                String template = "service:jmx:rmi://%s:%d/jndi/rmi://%s:%d/jmxrmi";
                uriString = String.format(template, this.bindAddress, this.jmxServerPort, this.bindAddress, this.jmxPort);
            } else {
                String template = "service:jmx:rmi:///jndi/rmi://%s:%d/jmxrmi";
                uriString = String.format(template, this.bindAddress, this.jmxPort);
            }
            return new URI(uriString);
        }
        catch (URISyntaxException e) {
            throw new ConfigurationException("JMX URI is not valid, please provide ", (Throwable)e);
        }
    }

    protected URL createManagerUrl() {
        try {
            String template = "http://%s:%d/manager";
            String urlString = String.format("http://%s:%d/manager", this.bindAddress, this.bindHttpPort);
            return new URL(urlString);
        }
        catch (MalformedURLException e) {
            throw new ConfigurationException("Manager URL is not valid, please provide ", (Throwable)e);
        }
    }
}

