/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.tomcat.embedded;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.catalina.Container;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Loader;
import org.apache.catalina.Service;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.loader.WebappLoader;
import org.apache.catalina.startup.Embedded;
import org.apache.catalina.startup.ExpandWar;
import org.jboss.arquillian.container.spi.client.container.DeployableContainer;
import org.jboss.arquillian.container.spi.client.container.DeploymentException;
import org.jboss.arquillian.container.spi.client.container.LifecycleException;
import org.jboss.arquillian.container.spi.client.protocol.ProtocolDescription;
import org.jboss.arquillian.container.spi.client.protocol.metadata.HTTPContext;
import org.jboss.arquillian.container.spi.client.protocol.metadata.ProtocolMetaData;
import org.jboss.arquillian.container.spi.client.protocol.metadata.Servlet;
import org.jboss.arquillian.container.spi.context.annotation.DeploymentScoped;
import org.jboss.arquillian.container.tomcat.embedded.EmbeddedContextConfig;
import org.jboss.arquillian.container.tomcat.embedded.EmbeddedWebappClassLoader;
import org.jboss.arquillian.container.tomcat.embedded.TomcatEmbeddedConfiguration;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.descriptor.api.Descriptor;
import org.jboss.shrinkwrap.tomcat_6.api.ShrinkWrapStandardContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Tomcat6EmbeddedContainer
implements DeployableContainer<TomcatEmbeddedConfiguration> {
    private static final Logger log = Logger.getLogger(Tomcat6EmbeddedContainer.class.getName());
    private static final String ENV_VAR = "${env.";
    private static final String TMPDIR_SYS_PROP = "java.io.tmpdir";
    private TomcatEmbeddedConfiguration configuration;
    private Embedded tomcat;
    private Host host;
    private Engine engine;
    private boolean wasStarted;
    private final List<String> failedUndeployments = new ArrayList<String>();
    @Inject
    @DeploymentScoped
    private InstanceProducer<StandardContext> standardContextProducer;

    public Class<TomcatEmbeddedConfiguration> getConfigurationClass() {
        return TomcatEmbeddedConfiguration.class;
    }

    public ProtocolDescription getDefaultProtocol() {
        return new ProtocolDescription("Servlet 2.5");
    }

    public void setup(TomcatEmbeddedConfiguration configuration) {
        String serverName = configuration.getServerName();
        if (serverName == null || "".equals(serverName)) {
            configuration.setServerName("arquillian-tomcat-embedded-6");
        }
        this.configuration = configuration;
    }

    public void start() throws LifecycleException {
        try {
            this.startTomcatEmbedded();
        }
        catch (Exception e) {
            throw new LifecycleException("Failed to start embedded Tomcat", (Throwable)e);
        }
    }

    public void stop() throws LifecycleException {
        try {
            this.removeFailedUnDeployments();
        }
        catch (Exception e) {
            throw new LifecycleException("Could not clean up", (Throwable)e);
        }
        if (this.wasStarted) {
            try {
                this.stopTomcatEmbedded();
            }
            catch (org.apache.catalina.LifecycleException e) {
                throw new LifecycleException("Failed to stop Tomcat", (Throwable)e);
            }
        }
    }

    public ProtocolMetaData deploy(Archive<?> archive) throws DeploymentException {
        try {
            StandardContext standardContext = (StandardContext)archive.as(ShrinkWrapStandardContext.class);
            if (archive.getName().startsWith("ROOT")) {
                standardContext.setPath("");
            }
            standardContext.addLifecycleListener((LifecycleListener)new EmbeddedContextConfig());
            standardContext.setUnpackWAR(this.configuration.isUnpackArchive());
            standardContext.setJ2EEServer("Arquillian-" + UUID.randomUUID().toString());
            standardContext.setParentClassLoader(Thread.currentThread().getContextClassLoader());
            if (standardContext.getUnpackWAR()) {
                this.deleteUnpackedWAR(standardContext);
            }
            WebappLoader webappLoader = new WebappLoader(standardContext.getParentClassLoader());
            webappLoader.setDelegate(standardContext.getDelegate());
            webappLoader.setLoaderClass(EmbeddedWebappClassLoader.class.getName());
            standardContext.setLoader((Loader)webappLoader);
            this.host.addChild((Container)standardContext);
            this.standardContextProducer.set((Object)standardContext);
            String contextPath = standardContext.getPath();
            HTTPContext httpContext = new HTTPContext(this.configuration.getBindAddress(), this.configuration.getBindHttpPort());
            for (String mapping : standardContext.findServletMappings()) {
                httpContext.add(new Servlet(standardContext.findServletMapping(mapping), contextPath));
            }
            return new ProtocolMetaData().addContext((Object)httpContext);
        }
        catch (Exception e) {
            throw new DeploymentException("Failed to deploy " + archive.getName(), (Throwable)e);
        }
    }

    public void undeploy(Archive<?> archive) throws DeploymentException {
        StandardContext standardContext = (StandardContext)this.standardContextProducer.get();
        if (standardContext != null) {
            this.host.removeChild((Container)standardContext);
            try {
                standardContext.stop();
                standardContext.destroy();
            }
            catch (Exception e) {
                log.log(Level.WARNING, "Error on undeployment of " + standardContext.getName(), e);
            }
            if (standardContext.getUnpackWAR()) {
                this.deleteUnpackedWAR(standardContext);
            }
        }
    }

    public void deploy(Descriptor descriptor) throws DeploymentException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void undeploy(Descriptor descriptor) throws DeploymentException {
        throw new UnsupportedOperationException("Not implemented");
    }

    protected void startTomcatEmbedded() throws UnknownHostException, org.apache.catalina.LifecycleException {
        this.tomcat = new Embedded();
        this.tomcat.setName(this.configuration.getServerName());
        String tomcatHome = this.configuration.getTomcatHome();
        File tomcatHomeFile = null;
        if (tomcatHome != null) {
            if (tomcatHome.startsWith(ENV_VAR)) {
                String sysVar = tomcatHome.substring(ENV_VAR.length(), tomcatHome.length() - 1);
                if ((tomcatHome = System.getProperty(sysVar)) != null && tomcatHome.length() > 0 && new File(tomcatHome).isAbsolute()) {
                    tomcatHomeFile = new File(tomcatHome);
                    log.info("Using tomcat home from environment variable: " + tomcatHome);
                }
            } else {
                tomcatHomeFile = new File(tomcatHome);
            }
        }
        if (tomcatHomeFile == null) {
            tomcatHomeFile = new File(System.getProperty(TMPDIR_SYS_PROP), "tomcat-embedded-6");
        }
        tomcatHomeFile.mkdirs();
        this.tomcat.setCatalinaBase(tomcatHomeFile.getAbsolutePath());
        this.tomcat.setCatalinaHome(tomcatHomeFile.getAbsolutePath());
        this.engine = this.tomcat.createEngine();
        this.engine.setName(this.configuration.getServerName());
        this.engine.setDefaultHost(this.configuration.getBindAddress());
        this.engine.setService((Service)this.tomcat);
        this.tomcat.setContainer((Container)this.engine);
        this.tomcat.addEngine(this.engine);
        File appBaseFile = new File(tomcatHomeFile, this.configuration.getAppBase());
        appBaseFile.mkdirs();
        this.host = this.tomcat.createHost(this.configuration.getBindAddress(), appBaseFile.getAbsolutePath());
        if (this.configuration.getTomcatWorkDir() != null) {
            ((StandardHost)this.host).setWorkDir(this.configuration.getTomcatWorkDir());
        }
        ((StandardHost)this.host).setUnpackWARs(this.configuration.isUnpackArchive());
        this.engine.addChild((Container)this.host);
        Connector connector = this.tomcat.createConnector(InetAddress.getByName(this.configuration.getBindAddress()), this.configuration.getBindHttpPort(), false);
        this.tomcat.addConnector(connector);
        connector.setContainer((Container)this.engine);
        this.tomcat.init();
        this.tomcat.start();
        this.wasStarted = true;
    }

    protected void stopTomcatEmbedded() throws org.apache.catalina.LifecycleException {
        this.tomcat.stop();
        this.tomcat.destroy();
    }

    protected void deleteUnpackedWAR(StandardContext standardContext) {
        File unpackDir;
        String path = standardContext.getPath();
        if ("".equals(path)) {
            path = "/ROOT";
        }
        if ((unpackDir = new File(this.host.getAppBase(), path.substring(1))).exists()) {
            ExpandWar.deleteDir((File)unpackDir);
        }
    }

    private void undeploy(String name) throws DeploymentException {
        Container child = this.host.findChild(name);
        if (child != null) {
            this.host.removeChild(child);
        }
    }

    private void removeFailedUnDeployments() throws IOException {
        ArrayList remainingDeployments = new ArrayList();
        for (String name : this.failedUndeployments) {
            try {
                this.undeploy(name);
            }
            catch (Exception e) {
                IOException ioe = new IOException();
                ioe.initCause(e);
                throw ioe;
            }
        }
        if (remainingDeployments.size() > 0) {
            log.severe("Failed to undeploy these artifacts: " + remainingDeployments);
        }
        this.failedUndeployments.clear();
    }
}

