/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.tomcat.managed_7;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.jboss.arquillian.container.spi.ConfigurationException;
import org.jboss.arquillian.container.tomcat.CommonTomcatConfiguration;
import org.jboss.arquillian.container.tomcat.Validate;

public class TomcatManagedConfiguration
extends CommonTomcatConfiguration {
    private boolean outputToConsole = true;
    private String catalinaHome = System.getenv("CATALINA_HOME");
    private String javaHome = System.getenv("JAVA_HOME");
    private String javaVmArguments = "-Xmx512m -XX:MaxPermSize=128m";
    private int startupTimeoutInSeconds = 120;
    private int shutdownTimeoutInSeconds = 45;
    private String workDir = null;
    private String serverConfig = "server.xml";

    public TomcatManagedConfiguration() {
        if (this.javaHome == null || "".equals(this.javaHome)) {
            this.javaHome = System.getProperty("java.home");
        }
    }

    public void validate() throws ConfigurationException {
        super.validate();
        Validate.configurationDirectoryExists((String)this.catalinaHome, (String)("Either CATALINA_HOME environment variable or catalinaHome property in Arquillian configuration must be set and point to a valid directory! " + this.catalinaHome + " is not valid directory!"));
        Validate.configurationDirectoryExists((String)this.javaHome, (String)("Either JAVA_HOME environment variable or javaHome property in Arquillian configuration must be set and point to a valid directory! " + this.javaHome + " is not valid directory!"));
        Validate.isValidFile((String)(this.catalinaHome + "/conf/" + this.serverConfig), (String)("The server configuration file denoted by serverConfig property has to exist! This file: " + this.catalinaHome + "/conf/" + this.serverConfig + " does not!"));
        this.setOutputToConsole(AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                String val = System.getProperty("org.apache.tomcat.writeconsole");
                return val == null || !"false".equals(val);
            }
        }));
    }

    public String getCatalinaHome() {
        return this.catalinaHome;
    }

    public void setCatalinaHome(String catalinaHome) {
        this.catalinaHome = catalinaHome;
    }

    public String getJavaHome() {
        return this.javaHome;
    }

    public void setJavaHome(String javaHome) {
        this.javaHome = javaHome;
    }

    public String getJavaVmArguments() {
        return this.javaVmArguments;
    }

    public void setJavaVmArguments(String javaVmArguments) {
        this.javaVmArguments = javaVmArguments;
    }

    public int getStartupTimeoutInSeconds() {
        return this.startupTimeoutInSeconds;
    }

    public void setStartupTimeoutInSeconds(int startupTimeoutInSeconds) {
        this.startupTimeoutInSeconds = startupTimeoutInSeconds;
    }

    public int getShutdownTimeoutInSeconds() {
        return this.shutdownTimeoutInSeconds;
    }

    public void setShutdownTimeoutInSeconds(int shutdownTimeoutInSeconds) {
        this.shutdownTimeoutInSeconds = shutdownTimeoutInSeconds;
    }

    public String getWorkDir() {
        return this.workDir;
    }

    public void setWorkDir(String workDir) {
        this.workDir = workDir;
    }

    public String getServerConfig() {
        return this.serverConfig;
    }

    public void setServerConfig(String serverConfig) {
        this.serverConfig = serverConfig;
    }

    public void setOutputToConsole(boolean outputToConsole) {
        this.outputToConsole = outputToConsole;
    }

    public boolean isOutputToConsole() {
        return this.outputToConsole;
    }

    @Deprecated
    public void setWriteOutputToConsole(boolean writeOutputToConsole) {
        this.setOutputToConsole(writeOutputToConsole);
    }

    @Deprecated
    public boolean isWriteOutputToConsole() {
        return this.isOutputToConsole();
    }
}

