/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.was.wlp_managed_8_5;

import com.sun.tools.attach.VirtualMachine;
import com.sun.tools.attach.VirtualMachineDescriptor;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.jboss.arquillian.container.spi.client.container.DeployableContainer;
import org.jboss.arquillian.container.spi.client.container.DeploymentException;
import org.jboss.arquillian.container.spi.client.container.LifecycleException;
import org.jboss.arquillian.container.spi.client.protocol.ProtocolDescription;
import org.jboss.arquillian.container.spi.client.protocol.metadata.HTTPContext;
import org.jboss.arquillian.container.spi.client.protocol.metadata.ProtocolMetaData;
import org.jboss.arquillian.container.spi.client.protocol.metadata.Servlet;
import org.jboss.arquillian.container.was.wlp_managed_8_5.WLPManagedContainerConfiguration;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.descriptor.api.Descriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WLPManagedContainer
implements DeployableContainer<WLPManagedContainerConfiguration> {
    private static final String className = WLPManagedContainer.class.getName();
    private static Logger log = Logger.getLogger(className);
    private WLPManagedContainerConfiguration containerConfiguration;
    private JMXConnector jmxConnector;
    private MBeanServerConnection mbsc;
    private Process wlpProcess;
    private Thread shutdownThread;

    public void setup(WLPManagedContainerConfiguration configuration) {
        if (log.isLoggable(Level.FINER)) {
            log.entering(className, "setup");
        }
        this.containerConfiguration = configuration;
        if (log.isLoggable(Level.FINER)) {
            log.exiting(className, "setup");
        }
    }

    public void start() throws LifecycleException {
        if (log.isLoggable(Level.FINER)) {
            log.entering(className, "start");
        }
        VirtualMachine wlpvm = null;
        String serviceURL = null;
        try {
            String vmid = this.findVirtualMachineIdByName(this.containerConfiguration.getServerName());
            if (vmid != null) {
                if (!this.containerConfiguration.isAllowConnectingToRunningServer()) {
                    throw new LifecycleException("Connecting to an already running server is not allowed");
                }
                wlpvm = VirtualMachine.attach(vmid);
                serviceURL = this.getVMLocalConnectorAddress(wlpvm);
                if (serviceURL == null) {
                    throw new LifecycleException("Unable to retrieve connector address for localConnector");
                }
            } else {
                ArrayList<String> cmd = new ArrayList<String>();
                cmd.add(System.getProperty("java.home") + "/bin/java");
                cmd.add("-javaagent:lib/bootstrap-agent.jar");
                cmd.add("-jar");
                cmd.add("lib/ws-launch.jar");
                cmd.add(this.containerConfiguration.getServerName());
                log.finer("Starting server with command: " + ((Object)cmd).toString());
                ProcessBuilder pb = new ProcessBuilder(cmd);
                pb.directory(new File(this.containerConfiguration.getWlpHome()));
                pb.redirectErrorStream();
                this.wlpProcess = pb.start();
                new Thread(new ConsoleConsumer()).start();
                final Process proc = this.wlpProcess;
                this.shutdownThread = new Thread(new Runnable(){

                    public void run() {
                        if (proc != null) {
                            proc.destroy();
                            try {
                                proc.waitFor();
                            }
                            catch (InterruptedException e) {
                                throw new RuntimeException(e);
                            }
                        }
                    }
                });
                Runtime.getRuntime().addShutdownHook(this.shutdownThread);
                int startupTimeout = this.containerConfiguration.getServerStartTimeout() * 1000;
                while (startupTimeout > 0 && serviceURL == null) {
                    startupTimeout -= 500;
                    Thread.sleep(500L);
                    if (vmid == null) {
                        vmid = this.findVirtualMachineIdByName(this.containerConfiguration.getServerName());
                    }
                    if (wlpvm == null && vmid != null) {
                        wlpvm = VirtualMachine.attach(vmid);
                    }
                    if (serviceURL != null || wlpvm == null) continue;
                    serviceURL = this.getVMLocalConnectorAddress(wlpvm);
                }
                if (serviceURL == null) {
                    throw new LifecycleException("Unable to retrieve connector address for localConnector of started VM");
                }
                log.finer("vmid: " + vmid);
            }
        }
        catch (Exception e) {
            throw new LifecycleException("Could not start container", (Throwable)e);
        }
        try {
            JMXServiceURL url = new JMXServiceURL(serviceURL);
            this.jmxConnector = JMXConnectorFactory.connect(url);
            this.mbsc = this.jmxConnector.getMBeanServerConnection();
        }
        catch (IOException e) {
            throw new LifecycleException("Connecting to the JMX MBean Server failed", (Throwable)e);
        }
        if (log.isLoggable(Level.FINER)) {
            log.exiting(className, "start");
        }
    }

    private String getVMLocalConnectorAddress(VirtualMachine wlpvm) throws IOException {
        String PROPERTY_NAME = "com.sun.management.jmxremote.localConnectorAddress";
        String serviceURL = wlpvm.getAgentProperties().getProperty(PROPERTY_NAME);
        if (serviceURL == null) {
            serviceURL = wlpvm.getSystemProperties().getProperty(PROPERTY_NAME);
        }
        if (log.isLoggable(Level.FINER)) {
            log.finer("service url: " + serviceURL);
        }
        return serviceURL;
    }

    private String findVirtualMachineIdByName(String serverName) {
        if (log.isLoggable(Level.FINER)) {
            log.entering(className, "findVirtualMachineIdByName");
        }
        List<VirtualMachineDescriptor> vmds = VirtualMachine.list();
        for (VirtualMachineDescriptor vmd : vmds) {
            String displayName = vmd.displayName();
            if (log.isLoggable(Level.FINER)) {
                log.finer("VMD displayName: " + displayName);
                log.finer("VMD id: " + vmd.id());
            }
            if (!displayName.contains(serverName) || !displayName.contains("ws-server.jar") && !displayName.contains("ws-launch.jar")) continue;
            if (log.isLoggable(Level.FINER)) {
                log.exiting(className, "findVirtualMachineIdByName", vmd.id());
            }
            return vmd.id();
        }
        if (log.isLoggable(Level.FINER)) {
            log.exiting(className, "findVirtualMachineIdByName");
        }
        return null;
    }

    public ProtocolMetaData deploy(Archive<?> archive) throws DeploymentException {
        if (log.isLoggable(Level.FINER)) {
            log.entering(className, "deploy");
            log.finer("Archive provided to deploy method: " + archive.toString(true));
        }
        String dropInDir = this.getDropInDirectory();
        File exportedArchiveLocation = new File(dropInDir, archive.getName());
        ((ZipExporter)archive.as(ZipExporter.class)).exportTo(exportedArchiveLocation, true);
        this.waitForApplicationTargetState(this.createDeploymentName(archive.getName()), true, this.containerConfiguration.getAppDeployTimeout());
        ProtocolMetaData metaData = new ProtocolMetaData();
        HTTPContext httpContext = new HTTPContext("localhost", this.containerConfiguration.getHttpPort());
        httpContext.add(new Servlet("ArquillianServletRunner", this.createDeploymentName(archive.getName())));
        metaData.addContext((Object)httpContext);
        if (log.isLoggable(Level.FINER)) {
            log.exiting(className, "deploy");
        }
        return metaData;
    }

    public void undeploy(Archive<?> archive) throws DeploymentException {
        String dropInDir;
        File exportedArchiveLocation;
        if (log.isLoggable(Level.FINER)) {
            log.entering(className, "undeploy");
        }
        if (!(exportedArchiveLocation = new File(dropInDir = this.getDropInDirectory(), archive.getName())).delete()) {
            throw new DeploymentException("Unable to delete archive from dropIn directory");
        }
        this.waitForApplicationTargetState(this.createDeploymentName(archive.getName()), false, this.containerConfiguration.getAppUndeployTimeout());
        if (log.isLoggable(Level.FINER)) {
            log.exiting(className, "undeploy");
        }
    }

    private String getDropInDirectory() {
        String dropInDir = this.containerConfiguration.getWlpHome() + "/usr/servers/" + this.containerConfiguration.getServerName() + "/dropins";
        if (log.isLoggable(Level.FINER)) {
            log.finer("dropInDir: " + dropInDir);
        }
        return dropInDir;
    }

    private String createDeploymentName(String archiveName) {
        return archiveName.substring(0, archiveName.lastIndexOf("."));
    }

    private void waitForApplicationTargetState(String applicationName, boolean targetState, int timeout) throws DeploymentException {
        if (log.isLoggable(Level.FINER)) {
            log.entering(className, "waitForMBeanTargetState");
        }
        ObjectName appMBean = null;
        try {
            appMBean = new ObjectName("WebSphere:service=com.ibm.websphere.application.ApplicationMBean,name=" + applicationName);
        }
        catch (MalformedObjectNameException e) {
            throw new DeploymentException("The generated object name is wrong. The applicationName used was '" + applicationName + "'", (Throwable)e);
        }
        catch (NullPointerException e) {
            throw new DeploymentException("This should never happen", (Throwable)e);
        }
        try {
            int timeleft = timeout * 1000;
            while (this.mbsc.isRegistered(appMBean) != targetState) {
                Thread.sleep(100L);
                if (timeleft <= 0) {
                    throw new DeploymentException("Timeout while waiting for ApplicationMBean to reach targetState");
                }
                timeleft -= 100;
            }
            if (targetState) {
                String applicationState = null;
                while (applicationState == null || !applicationState.contentEquals("STARTED")) {
                    Thread.sleep(100L);
                    applicationState = (String)this.mbsc.getAttribute(appMBean, "State");
                    if (timeleft <= 0) {
                        throw new DeploymentException("Timeout while waiting for ApplicationState to reach STARTED");
                    }
                    timeleft -= 100;
                }
            }
        }
        catch (Exception e) {
            throw new DeploymentException("Exception while checking application state.", (Throwable)e);
        }
        if (log.isLoggable(Level.FINER)) {
            log.exiting(className, "waitForMBeanTargetState");
        }
    }

    public void stop() throws LifecycleException {
        if (log.isLoggable(Level.FINER)) {
            log.entering(className, "stop");
        }
        try {
            this.jmxConnector.close();
        }
        catch (IOException e) {
            throw new LifecycleException("Communication with the MBean Server failed.", (Throwable)e);
        }
        if (this.shutdownThread != null) {
            Runtime.getRuntime().removeShutdownHook(this.shutdownThread);
            this.shutdownThread = null;
        }
        try {
            if (this.wlpProcess != null) {
                this.wlpProcess.destroy();
                this.wlpProcess.waitFor();
                this.wlpProcess = null;
            }
        }
        catch (Exception e) {
            throw new LifecycleException("Could not stop container", (Throwable)e);
        }
        if (log.isLoggable(Level.FINER)) {
            log.exiting(className, "stop");
        }
    }

    public ProtocolDescription getDefaultProtocol() {
        if (log.isLoggable(Level.FINER)) {
            log.entering(className, "getDefaultProtocol");
        }
        String defaultProtocol = "Servlet 3.0";
        if (log.isLoggable(Level.FINER)) {
            log.exiting(className, "getDefaultProtocol", defaultProtocol);
        }
        return new ProtocolDescription(defaultProtocol);
    }

    public Class<WLPManagedContainerConfiguration> getConfigurationClass() {
        return WLPManagedContainerConfiguration.class;
    }

    public void deploy(Descriptor descriptor) throws DeploymentException {
    }

    public void undeploy(Descriptor descriptor) throws DeploymentException {
    }

    private class ConsoleConsumer
    implements Runnable {
        private ConsoleConsumer() {
        }

        public void run() {
            InputStream stream = WLPManagedContainer.this.wlpProcess.getInputStream();
            boolean writeOutput = WLPManagedContainer.this.containerConfiguration.isOutputToConsole();
            try {
                int num;
                byte[] buf = new byte[32];
                while ((num = stream.read(buf)) != -1) {
                    if (!writeOutput) continue;
                    System.out.write(buf, 0, num);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

