/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.was.wlp_managed_8_5;

import java.io.File;
import org.jboss.arquillian.container.spi.ConfigurationException;
import org.jboss.arquillian.container.spi.client.container.ContainerConfiguration;

public class WLPManagedContainerConfiguration
implements ContainerConfiguration {
    private String wlpHome;
    private String serverName;
    private int httpPort;
    private int serverStartTimeout = 30;
    private int appDeployTimeout = 2;
    private int appUndeployTimeout = 2;
    private boolean allowConnectingToRunningServer = Boolean.parseBoolean(System.getProperty("org.jboss.arquillian.container.was.wlp_managed_8_5.allowConnectingToRunningServer", "false"));
    private boolean outputToConsole = true;

    public void validate() throws ConfigurationException {
        File wlpHomeDir = new File(this.wlpHome);
        if (!wlpHomeDir.isDirectory()) {
            throw new ConfigurationException("wlpHome provided is not valid: " + this.wlpHome);
        }
        if (!this.serverName.matches("^[A-Za-z][A-Za-z0-9]*$")) {
            throw new ConfigurationException("serverName provided is not valid: '" + this.serverName + "'");
        }
        if (this.httpPort > 65535 || this.httpPort <= 0) {
            throw new ConfigurationException("httpPort provided is not valid: " + this.httpPort);
        }
    }

    public String getWlpHome() {
        return this.wlpHome;
    }

    public void setWlpHome(String wlpHome) {
        this.wlpHome = wlpHome;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public int getHttpPort() {
        return this.httpPort;
    }

    public void setHttpPort(int httpPort) {
        this.httpPort = httpPort;
    }

    public boolean isAllowConnectingToRunningServer() {
        return this.allowConnectingToRunningServer;
    }

    public boolean isOutputToConsole() {
        return this.outputToConsole;
    }

    public void setOutputToConsole(boolean outputToConsole) {
        this.outputToConsole = outputToConsole;
    }

    public int getServerStartTimeout() {
        return this.serverStartTimeout;
    }

    public void setServerStartTimeout(int serverStartTimeout) {
        this.serverStartTimeout = serverStartTimeout;
    }

    public int getAppDeployTimeout() {
        return this.appDeployTimeout;
    }

    public void setAppDeployTimeout(int appDeployTimeout) {
        this.appDeployTimeout = appDeployTimeout;
    }

    public int getAppUndeployTimeout() {
        return this.appUndeployTimeout;
    }

    public void setAppUndeployTimeout(int appUndeployTimeout) {
        this.appUndeployTimeout = appUndeployTimeout;
    }
}

