/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.was.wlp_managed_8_5;

import com.sun.tools.attach.VirtualMachine;
import com.sun.tools.attach.VirtualMachineDescriptor;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.jboss.arquillian.container.spi.client.container.DeployableContainer;
import org.jboss.arquillian.container.spi.client.container.DeploymentException;
import org.jboss.arquillian.container.spi.client.container.LifecycleException;
import org.jboss.arquillian.container.spi.client.protocol.ProtocolDescription;
import org.jboss.arquillian.container.spi.client.protocol.metadata.HTTPContext;
import org.jboss.arquillian.container.spi.client.protocol.metadata.ProtocolMetaData;
import org.jboss.arquillian.container.spi.client.protocol.metadata.Servlet;
import org.jboss.arquillian.container.was.wlp_managed_8_5.WLPManagedContainerConfiguration;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.descriptor.api.Descriptor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WLPManagedContainer
implements DeployableContainer<WLPManagedContainerConfiguration> {
    private static final String className = WLPManagedContainer.class.getName();
    private static Logger log = Logger.getLogger(className);
    private WLPManagedContainerConfiguration containerConfiguration;
    private JMXConnector jmxConnector;
    private MBeanServerConnection mbsc;
    private Process wlpProcess;
    private Thread shutdownThread;

    public void setup(WLPManagedContainerConfiguration configuration) {
        if (log.isLoggable(Level.FINER)) {
            log.entering(className, "setup");
        }
        this.containerConfiguration = configuration;
        if (log.isLoggable(Level.FINER)) {
            log.exiting(className, "setup");
        }
    }

    public void start() throws LifecycleException {
        String serviceURL;
        block17: {
            if (log.isLoggable(Level.FINER)) {
                log.entering(className, "start");
            }
            VirtualMachine wlpvm = null;
            serviceURL = null;
            try {
                String vmid = this.findVirtualMachineIdByName(this.containerConfiguration.getServerName());
                if (vmid != null) {
                    if (!this.containerConfiguration.isAllowConnectingToRunningServer()) {
                        throw new LifecycleException("Connecting to an already running server is not allowed");
                    }
                    wlpvm = VirtualMachine.attach(vmid);
                    serviceURL = this.getVMLocalConnectorAddress(wlpvm);
                    if (serviceURL == null) {
                        throw new LifecycleException("Unable to retrieve connector address for localConnector");
                    }
                    break block17;
                }
                ArrayList<String> cmd = new ArrayList<String>();
                String javaVmArguments = this.containerConfiguration.getJavaVmArguments();
                cmd.add(System.getProperty("java.home") + "/bin/java");
                if (!javaVmArguments.equals("")) {
                    cmd.add(javaVmArguments);
                }
                cmd.add("-javaagent:lib/bootstrap-agent.jar");
                cmd.add("-jar");
                cmd.add("lib/ws-launch.jar");
                cmd.add(this.containerConfiguration.getServerName());
                log.finer("Starting server with command: " + ((Object)cmd).toString());
                ProcessBuilder pb = new ProcessBuilder(cmd);
                pb.directory(new File(this.containerConfiguration.getWlpHome()));
                pb.redirectErrorStream();
                this.wlpProcess = pb.start();
                new Thread(new ConsoleConsumer()).start();
                final Process proc = this.wlpProcess;
                this.shutdownThread = new Thread(new Runnable(){

                    public void run() {
                        if (proc != null) {
                            proc.destroy();
                            try {
                                proc.waitFor();
                            }
                            catch (InterruptedException e) {
                                throw new RuntimeException(e);
                            }
                        }
                    }
                });
                Runtime.getRuntime().addShutdownHook(this.shutdownThread);
                int startupTimeout = this.containerConfiguration.getServerStartTimeout() * 1000;
                while (startupTimeout > 0 && serviceURL == null) {
                    startupTimeout -= 500;
                    Thread.sleep(500L);
                    int ev = Integer.MIN_VALUE;
                    IllegalThreadStateException itse = null;
                    try {
                        ev = this.wlpProcess.exitValue();
                    }
                    catch (IllegalThreadStateException e) {
                        itse = e;
                    }
                    if (itse == null) {
                        throw new LifecycleException("Process terminated prematurely; ev = " + ev);
                    }
                    if (vmid == null) {
                        vmid = this.findVirtualMachineIdByName(this.containerConfiguration.getServerName());
                    }
                    if (wlpvm == null && vmid != null) {
                        wlpvm = VirtualMachine.attach(vmid);
                    }
                    if (serviceURL != null || wlpvm == null) continue;
                    serviceURL = this.getVMLocalConnectorAddress(wlpvm);
                }
                if (serviceURL == null) {
                    throw new LifecycleException("Unable to retrieve connector address for localConnector of started VM");
                }
                log.finer("vmid: " + vmid);
            }
            catch (Exception e) {
                throw new LifecycleException("Could not start container", (Throwable)e);
            }
        }
        try {
            JMXServiceURL url = new JMXServiceURL(serviceURL);
            this.jmxConnector = JMXConnectorFactory.connect(url);
            this.mbsc = this.jmxConnector.getMBeanServerConnection();
        }
        catch (IOException e) {
            throw new LifecycleException("Connecting to the JMX MBean Server failed", (Throwable)e);
        }
        if (log.isLoggable(Level.FINER)) {
            log.exiting(className, "start");
        }
    }

    private String getVMLocalConnectorAddress(VirtualMachine wlpvm) throws IOException {
        String PROPERTY_NAME = "com.sun.management.jmxremote.localConnectorAddress";
        String serviceURL = wlpvm.getAgentProperties().getProperty(PROPERTY_NAME);
        if (serviceURL == null) {
            serviceURL = wlpvm.getSystemProperties().getProperty(PROPERTY_NAME);
        }
        if (log.isLoggable(Level.FINER)) {
            log.finer("service url: " + serviceURL);
        }
        return serviceURL;
    }

    private String findVirtualMachineIdByName(String serverName) {
        if (log.isLoggable(Level.FINER)) {
            log.entering(className, "findVirtualMachineIdByName");
        }
        List<VirtualMachineDescriptor> vmds = VirtualMachine.list();
        for (VirtualMachineDescriptor vmd : vmds) {
            String displayName = vmd.displayName();
            if (log.isLoggable(Level.FINER)) {
                log.finer("VMD displayName: " + displayName);
                log.finer("VMD id: " + vmd.id());
            }
            if (!displayName.contains(serverName) || !displayName.contains("ws-server.jar") && !displayName.contains("ws-launch.jar")) continue;
            if (log.isLoggable(Level.FINER)) {
                log.exiting(className, "findVirtualMachineIdByName", vmd.id());
            }
            return vmd.id();
        }
        if (log.isLoggable(Level.FINER)) {
            log.exiting(className, "findVirtualMachineIdByName");
        }
        return null;
    }

    public ProtocolMetaData deploy(Archive<?> archive) throws DeploymentException {
        if (log.isLoggable(Level.FINER)) {
            log.entering(className, "deploy");
            log.finer("Archive provided to deploy method: " + archive.toString(true));
        }
        String archiveName = archive.getName();
        String archiveType = this.createDeploymentType(archiveName);
        String deployName = this.createDeploymentName(archiveName);
        try {
            File exportedArchiveLocation;
            if (this.containerConfiguration.isDeployTypeXML()) {
                if (!(archiveType.equalsIgnoreCase("ear") || archiveType.equalsIgnoreCase("war") || archiveType.equalsIgnoreCase("eba"))) {
                    throw new DeploymentException("Invalid archive type: " + archiveType + ".  Valid archive types are ear, war, and eba.");
                }
                String appDir = this.getAppDirectory();
                exportedArchiveLocation = new File(appDir, archiveName);
                ((ZipExporter)archive.as(ZipExporter.class)).exportTo(exportedArchiveLocation, true);
                Document document = this.readServerXML();
                this.addApplication(document, deployName, archiveName, archiveType);
                this.writeServerXML(document);
            } else {
                String dropInDir = this.getDropInDirectory();
                exportedArchiveLocation = new File(dropInDir, archiveName);
                ((ZipExporter)archive.as(ZipExporter.class)).exportTo(exportedArchiveLocation, true);
            }
            this.waitForApplicationTargetState(deployName, true, this.containerConfiguration.getAppDeployTimeout());
            ProtocolMetaData metaData = new ProtocolMetaData();
            HTTPContext httpContext = new HTTPContext("localhost", this.getHttpPort());
            httpContext.add(new Servlet("ArquillianServletRunner", deployName));
            metaData.addContext((Object)httpContext);
            if (log.isLoggable(Level.FINER)) {
                log.exiting(className, "deploy");
            }
            return metaData;
        }
        catch (Exception e) {
            throw new DeploymentException("Exception while deploying application.", (Throwable)e);
        }
    }

    private int getHttpPort() throws DeploymentException {
        int httpPort;
        if (log.isLoggable(Level.FINER)) {
            log.entering(className, "getHttpPort");
        }
        if ((httpPort = this.containerConfiguration.getHttpPort()) == 0) {
            httpPort = this.getHttpPortFromChannelFWMBean("defaultHttpEndpoint");
        }
        if (log.isLoggable(Level.FINER)) {
            log.exiting(className, "getHttpPort", httpPort);
        }
        return httpPort;
    }

    private int getHttpPortFromChannelFWMBean(String endpointName) throws DeploymentException {
        int httpPort;
        if (log.isLoggable(Level.FINER)) {
            log.entering(className, "getHttpPortFromChannelFWMBean", endpointName);
        }
        ObjectName endpointMBean = null;
        try {
            endpointMBean = new ObjectName("WebSphere:feature=channelfw,type=endpoint,name=" + endpointName);
        }
        catch (MalformedObjectNameException e) {
            throw new DeploymentException("The generated object name is wrong. The endpointName used was '" + endpointName + "'", (Throwable)e);
        }
        catch (NullPointerException e) {
            throw new DeploymentException("This should never happen", (Throwable)e);
        }
        try {
            if (!this.mbsc.isRegistered(endpointMBean)) {
                throw new DeploymentException("The Channel Framework MBean with endpointName '" + endpointName + "' does not exist.");
            }
            httpPort = (Integer)this.mbsc.getAttribute(endpointMBean, "Port");
            log.finer("httpPort: " + httpPort);
        }
        catch (Exception e) {
            throw new DeploymentException("Exception while retrieving httpPort information from Channel Framework MBean. The httpPort can also be manually configured in the arquillian container configuration.", (Throwable)e);
        }
        if (log.isLoggable(Level.FINER)) {
            log.exiting(className, "getHttpPortFromChannelFWMBean", httpPort);
        }
        return httpPort;
    }

    public void undeploy(Archive<?> archive) throws DeploymentException {
        if (log.isLoggable(Level.FINER)) {
            log.entering(className, "undeploy");
        }
        String archiveName = archive.getName();
        String deployName = this.createDeploymentName(archiveName);
        try {
            if (this.containerConfiguration.isDeployTypeXML()) {
                Document document = this.readServerXML();
                this.removeApplication(document);
                this.writeServerXML(document);
                this.waitForApplicationTargetState(deployName, false, this.containerConfiguration.getAppUndeployTimeout());
                String appDir = this.getAppDirectory();
                File exportedArchiveLocation = new File(appDir, archiveName);
                if (!exportedArchiveLocation.delete()) {
                    throw new DeploymentException("Unable to delete archive from apps directory");
                }
            } else {
                String dropInDir = this.getDropInDirectory();
                File exportedArchiveLocation = new File(dropInDir, archiveName);
                if (!exportedArchiveLocation.delete()) {
                    throw new DeploymentException("Unable to delete archive from dropIn directory");
                }
                this.waitForApplicationTargetState(deployName, false, this.containerConfiguration.getAppUndeployTimeout());
            }
        }
        catch (Exception e) {
            throw new DeploymentException("Exception while undeploying application.", (Throwable)e);
        }
        if (log.isLoggable(Level.FINER)) {
            log.exiting(className, "undeploy");
        }
    }

    private String getDropInDirectory() {
        String dropInDir = this.containerConfiguration.getWlpHome() + "/usr/servers/" + this.containerConfiguration.getServerName() + "/dropins";
        if (log.isLoggable(Level.FINER)) {
            log.finer("dropInDir: " + dropInDir);
        }
        return dropInDir;
    }

    private String getAppDirectory() {
        String appDir = this.containerConfiguration.getWlpHome() + "/usr/servers/" + this.containerConfiguration.getServerName() + "/apps";
        if (log.isLoggable(Level.FINER)) {
            log.finer("appDir: " + appDir);
        }
        return appDir;
    }

    private String getServerXML() {
        String serverXML = this.containerConfiguration.getWlpHome() + "/usr/servers/" + this.containerConfiguration.getServerName() + "/server.xml";
        if (log.isLoggable(Level.FINER)) {
            log.finer("server.xml: " + serverXML);
        }
        return serverXML;
    }

    private String createDeploymentName(String archiveName) {
        return archiveName.substring(0, archiveName.lastIndexOf("."));
    }

    private String createDeploymentType(String archiveName) {
        return archiveName.substring(archiveName.lastIndexOf(".") + 1);
    }

    private Document readServerXML() throws DeploymentException {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            return documentBuilder.parse(new File(this.getServerXML()));
        }
        catch (Exception e) {
            throw new DeploymentException("Exception while reading server.xml file.", (Throwable)e);
        }
    }

    private void writeServerXML(Document doc) throws DeploymentException {
        try {
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer tr = tf.newTransformer();
            tr.setOutputProperty("indent", "yes");
            DOMSource source = new DOMSource(doc);
            StreamResult res = new StreamResult(new File(this.getServerXML()));
            tr.transform(source, res);
        }
        catch (Exception e) {
            throw new DeploymentException("Exception wile writing server.xml file.", (Throwable)e);
        }
    }

    private Element createApplication(Document doc, String deploymentName, String archiveName, String type) {
        Element application = doc.createElement("application");
        application.setAttribute("id", deploymentName);
        application.setAttribute("location", archiveName);
        application.setAttribute("name", deploymentName);
        application.setAttribute("type", type);
        if (this.containerConfiguration.getSharedLib() != null) {
            Element sharedLib = doc.createElement("classloader");
            sharedLib.setAttribute("commonLibraryRef", this.containerConfiguration.getSharedLib());
            application.appendChild(sharedLib);
        }
        return application;
    }

    private void addApplication(Document doc, String deployName, String archiveName, String type) {
        NodeList rootList = doc.getElementsByTagName("server");
        Node root = rootList.item(0);
        root.appendChild(this.createApplication(doc, deployName, archiveName, type));
    }

    private void removeApplication(Document doc) {
        Node server = doc.getElementsByTagName("server").item(0);
        NodeList serverlist = server.getChildNodes();
        for (int i = 0; serverlist.getLength() > i; ++i) {
            Node node = serverlist.item(i);
            if (!node.getNodeName().equals("application")) continue;
            node.getParentNode().removeChild(node);
        }
    }

    private void waitForApplicationTargetState(String applicationName, boolean targetState, int timeout) throws DeploymentException {
        if (log.isLoggable(Level.FINER)) {
            log.entering(className, "waitForMBeanTargetState");
        }
        ObjectName appMBean = null;
        try {
            appMBean = new ObjectName("WebSphere:service=com.ibm.websphere.application.ApplicationMBean,name=" + applicationName);
        }
        catch (MalformedObjectNameException e) {
            throw new DeploymentException("The generated object name is wrong. The applicationName used was '" + applicationName + "'", (Throwable)e);
        }
        catch (NullPointerException e) {
            throw new DeploymentException("This should never happen", (Throwable)e);
        }
        try {
            int timeleft = timeout * 1000;
            while (this.mbsc.isRegistered(appMBean) != targetState) {
                Thread.sleep(100L);
                if (timeleft <= 0) {
                    throw new DeploymentException("Timeout while waiting for ApplicationMBean to reach targetState");
                }
                timeleft -= 100;
            }
            if (targetState) {
                String applicationState = null;
                while (applicationState == null || !applicationState.contentEquals("STARTED")) {
                    Thread.sleep(100L);
                    applicationState = (String)this.mbsc.getAttribute(appMBean, "State");
                    if (timeleft <= 0) {
                        throw new DeploymentException("Timeout while waiting for ApplicationState to reach STARTED");
                    }
                    timeleft -= 100;
                }
            }
        }
        catch (Exception e) {
            throw new DeploymentException("Exception while checking application state.", (Throwable)e);
        }
        if (log.isLoggable(Level.FINER)) {
            log.exiting(className, "waitForMBeanTargetState");
        }
    }

    public void stop() throws LifecycleException {
        if (log.isLoggable(Level.FINER)) {
            log.entering(className, "stop");
        }
        try {
            this.jmxConnector.close();
        }
        catch (IOException e) {
            throw new LifecycleException("Communication with the MBean Server failed.", (Throwable)e);
        }
        if (this.shutdownThread != null) {
            Runtime.getRuntime().removeShutdownHook(this.shutdownThread);
            this.shutdownThread = null;
        }
        try {
            if (this.wlpProcess != null) {
                this.wlpProcess.destroy();
                this.wlpProcess.waitFor();
                this.wlpProcess = null;
            }
        }
        catch (Exception e) {
            throw new LifecycleException("Could not stop container", (Throwable)e);
        }
        if (log.isLoggable(Level.FINER)) {
            log.exiting(className, "stop");
        }
    }

    public ProtocolDescription getDefaultProtocol() {
        if (log.isLoggable(Level.FINER)) {
            log.entering(className, "getDefaultProtocol");
        }
        String defaultProtocol = "Servlet 3.0";
        if (log.isLoggable(Level.FINER)) {
            log.exiting(className, "getDefaultProtocol", defaultProtocol);
        }
        return new ProtocolDescription(defaultProtocol);
    }

    public Class<WLPManagedContainerConfiguration> getConfigurationClass() {
        return WLPManagedContainerConfiguration.class;
    }

    public void deploy(Descriptor descriptor) throws DeploymentException {
    }

    public void undeploy(Descriptor descriptor) throws DeploymentException {
    }

    private class ConsoleConsumer
    implements Runnable {
        private ConsoleConsumer() {
        }

        public void run() {
            InputStream stream = WLPManagedContainer.this.wlpProcess.getInputStream();
            boolean writeOutput = WLPManagedContainer.this.containerConfiguration.isOutputToConsole();
            try {
                int num;
                byte[] buf = new byte[32];
                while ((num = stream.read(buf)) != -1) {
                    if (!writeOutput) continue;
                    System.out.write(buf, 0, num);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

