/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.was.wlp_managed_8_5;

import java.io.File;
import org.jboss.arquillian.container.spi.ConfigurationException;
import org.jboss.arquillian.container.spi.client.container.ContainerConfiguration;

public class WLPManagedContainerConfiguration
implements ContainerConfiguration {
    private String wlpHome;
    private String serverName = "defaultServer";
    private int httpPort = 0;
    private int serverStartTimeout = 30;
    private int appDeployTimeout = 20;
    private int appUndeployTimeout = 2;
    private String sharedLib = null;
    private String deployType = "dropins";
    private String javaVmArguments = "";
    private boolean allowConnectingToRunningServer = Boolean.parseBoolean(System.getProperty("org.jboss.arquillian.container.was.wlp_managed_8_5.allowConnectingToRunningServer", "false"));
    private boolean outputToConsole = true;

    public void validate() throws ConfigurationException {
        if (this.wlpHome != null) {
            File wlpHomeDir = new File(this.wlpHome);
            File bsAgentJar = new File(this.wlpHome + "/lib/bootstrap-agent.jar");
            File wsLaunchJar = new File(this.wlpHome + "/lib/ws-launch.jar");
            if (!(wlpHomeDir.isDirectory() && bsAgentJar.isFile() && wsLaunchJar.isFile())) {
                throw new ConfigurationException("wlpHome provided is not valid: " + this.wlpHome);
            }
        } else {
            throw new ConfigurationException("wlpHome is required for initialization");
        }
        if (!this.serverName.matches("^[A-Za-z][A-Za-z0-9]*$")) {
            throw new ConfigurationException("serverName provided is not valid: '" + this.serverName + "'");
        }
        if (this.httpPort > 65535 || this.httpPort < 0) {
            throw new ConfigurationException("httpPort provided is not valid: " + this.httpPort);
        }
        if (!this.deployType.equalsIgnoreCase("xml") && !this.deployType.equalsIgnoreCase("dropins")) {
            throw new ConfigurationException("deployType provided is not valid: " + this.deployType + ".  deployType should be xml or dropins.");
        }
        if (this.sharedLib != null && !this.sharedLib.isEmpty() && !this.deployType.equalsIgnoreCase("xml")) {
            throw new ConfigurationException("deployType must be set to xml when sharedLib is not empty");
        }
    }

    public String getWlpHome() {
        return this.wlpHome;
    }

    public void setWlpHome(String wlpHome) {
        this.wlpHome = wlpHome;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public int getHttpPort() {
        return this.httpPort;
    }

    public void setHttpPort(int httpPort) {
        this.httpPort = httpPort;
    }

    public void setSharedLib(String sharedLib) {
        this.sharedLib = sharedLib;
    }

    public String getSharedLib() {
        return this.sharedLib;
    }

    public void setDeployType(String deployType) {
        this.deployType = deployType;
    }

    public String getDeployType() {
        return this.deployType;
    }

    public boolean isAllowConnectingToRunningServer() {
        return this.allowConnectingToRunningServer;
    }

    public void setAllowConnectingToRunningServer(boolean allowConnectingToRunningServer) {
        this.allowConnectingToRunningServer = allowConnectingToRunningServer;
    }

    public boolean isOutputToConsole() {
        return this.outputToConsole;
    }

    public void setOutputToConsole(boolean outputToConsole) {
        this.outputToConsole = outputToConsole;
    }

    public int getServerStartTimeout() {
        return this.serverStartTimeout;
    }

    public void setServerStartTimeout(int serverStartTimeout) {
        this.serverStartTimeout = serverStartTimeout;
    }

    public int getAppDeployTimeout() {
        return this.appDeployTimeout;
    }

    public void setAppDeployTimeout(int appDeployTimeout) {
        this.appDeployTimeout = appDeployTimeout;
    }

    public int getAppUndeployTimeout() {
        return this.appUndeployTimeout;
    }

    public void setAppUndeployTimeout(int appUndeployTimeout) {
        this.appUndeployTimeout = appUndeployTimeout;
    }

    public boolean isDeployTypeXML() {
        return this.deployType.equalsIgnoreCase("xml");
    }

    public boolean isDeployTypeDropins() {
        return this.deployType.equalsIgnoreCase("dropins");
    }

    public String getJavaVmArguments() {
        return this.javaVmArguments;
    }

    public void setJavaVmArguments(String javaVmArguments) {
        this.javaVmArguments = javaVmArguments;
    }
}

