/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.was.wlp_managed_8_5;

import com.sun.tools.attach.VirtualMachine;
import com.sun.tools.attach.VirtualMachineDescriptor;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.jboss.arquillian.container.spi.client.container.DeployableContainer;
import org.jboss.arquillian.container.spi.client.container.DeploymentException;
import org.jboss.arquillian.container.spi.client.container.LifecycleException;
import org.jboss.arquillian.container.spi.client.protocol.ProtocolDescription;
import org.jboss.arquillian.container.spi.client.protocol.metadata.HTTPContext;
import org.jboss.arquillian.container.spi.client.protocol.metadata.ProtocolMetaData;
import org.jboss.arquillian.container.spi.client.protocol.metadata.Servlet;
import org.jboss.arquillian.container.test.api.Testable;
import org.jboss.arquillian.container.was.wlp_managed_8_5.WLPManagedContainerConfiguration;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.Node;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.api.spec.EnterpriseArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.descriptor.api.Descriptor;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WLPManagedContainer
implements DeployableContainer<WLPManagedContainerConfiguration> {
    private static final String className = WLPManagedContainer.class.getName();
    private static Logger log = Logger.getLogger(className);
    private static final String javaVmArgumentsDelimiter = " ";
    private static final String javaVmArgumentsIndicator = "-";
    private WLPManagedContainerConfiguration containerConfiguration;
    private JMXConnector jmxConnector;
    private MBeanServerConnection mbsc;
    private Process wlpProcess;
    private Thread shutdownThread;

    public void setup(WLPManagedContainerConfiguration configuration) {
        if (log.isLoggable(Level.FINER)) {
            log.entering(className, "setup");
        }
        this.containerConfiguration = configuration;
        if (log.isLoggable(Level.FINER)) {
            log.exiting(className, "setup");
        }
    }

    public void start() throws LifecycleException {
        String serviceURL;
        block19: {
            if (log.isLoggable(Level.FINER)) {
                log.entering(className, "start");
            }
            VirtualMachine wlpvm = null;
            serviceURL = null;
            try {
                String vmid = this.findVirtualMachineIdByName(this.containerConfiguration.getServerName());
                if (vmid != null) {
                    if (!this.containerConfiguration.isAllowConnectingToRunningServer()) {
                        throw new LifecycleException("Connecting to an already running server is not allowed");
                    }
                    wlpvm = VirtualMachine.attach(vmid);
                    serviceURL = this.getVMLocalConnectorAddress(wlpvm);
                    if (serviceURL == null) {
                        throw new LifecycleException("Unable to retrieve connector address for localConnector");
                    }
                    break block19;
                }
                if (this.containerConfiguration.isAddLocalConnector()) {
                    String serverXML = this.getServerXML();
                    if ("defaultServer".equals(this.containerConfiguration.getServerName()) && !new File(serverXML).exists()) {
                        serverXML = this.getDefaultServerXML();
                    }
                    Document document = this.readServerXML(serverXML);
                    this.addFeatures(document, "localConnector-1.0");
                    this.writeServerXML(document, serverXML);
                }
                ArrayList<String> cmd = new ArrayList<String>();
                String javaVmArguments = this.containerConfiguration.getJavaVmArguments();
                cmd.add(System.getProperty("java.home") + "/bin/java");
                cmd.add("-Dcom.ibm.ws.logging.console.log.level=INFO");
                if (!javaVmArguments.equals("")) {
                    cmd.addAll(this.parseJvmArgs(javaVmArguments));
                }
                cmd.add("-javaagent:lib/bootstrap-agent.jar");
                cmd.add("-jar");
                cmd.add("lib/ws-launch.jar");
                cmd.add(this.containerConfiguration.getServerName());
                log.finer("Starting server with command: " + ((Object)cmd).toString());
                ProcessBuilder pb = new ProcessBuilder(cmd);
                pb.directory(new File(this.containerConfiguration.getWlpHome()));
                pb.redirectErrorStream(true);
                this.wlpProcess = pb.start();
                new Thread(new ConsoleConsumer()).start();
                final Process proc = this.wlpProcess;
                this.shutdownThread = new Thread(new Runnable(){

                    public void run() {
                        if (proc != null) {
                            proc.destroy();
                            try {
                                proc.waitFor();
                            }
                            catch (InterruptedException e) {
                                throw new RuntimeException(e);
                            }
                        }
                    }
                });
                Runtime.getRuntime().addShutdownHook(this.shutdownThread);
                int startupTimeout = this.containerConfiguration.getServerStartTimeout() * 1000;
                while (startupTimeout > 0 && serviceURL == null) {
                    startupTimeout -= 500;
                    Thread.sleep(500L);
                    int ev = Integer.MIN_VALUE;
                    IllegalThreadStateException itse = null;
                    try {
                        ev = this.wlpProcess.exitValue();
                    }
                    catch (IllegalThreadStateException e) {
                        itse = e;
                    }
                    if (itse == null) {
                        throw new LifecycleException("Process terminated prematurely; ev = " + ev);
                    }
                    if (vmid == null) {
                        vmid = this.findVirtualMachineIdByName(this.containerConfiguration.getServerName());
                    }
                    if (wlpvm == null && vmid != null) {
                        wlpvm = VirtualMachine.attach(vmid);
                    }
                    if (serviceURL != null || wlpvm == null) continue;
                    serviceURL = this.getVMLocalConnectorAddress(wlpvm);
                }
                if (serviceURL == null) {
                    throw new LifecycleException("Unable to retrieve connector address for localConnector of started VM");
                }
                log.finer("vmid: " + vmid);
            }
            catch (Exception e) {
                throw new LifecycleException("Could not start container", (Throwable)e);
            }
        }
        try {
            JMXServiceURL url = new JMXServiceURL(serviceURL);
            this.jmxConnector = JMXConnectorFactory.connect(url);
            this.mbsc = this.jmxConnector.getMBeanServerConnection();
        }
        catch (IOException e) {
            throw new LifecycleException("Connecting to the JMX MBean Server failed", (Throwable)e);
        }
        if (log.isLoggable(Level.FINER)) {
            log.exiting(className, "start");
        }
    }

    private List<String> parseJvmArgs(String javaVmArguments) {
        ArrayList<String> parsedJavaVmArguments = new ArrayList<String>();
        String[] splitJavaVmArguments = javaVmArguments.split(javaVmArgumentsDelimiter);
        if (splitJavaVmArguments.length > 1) {
            for (String javaVmArgument : splitJavaVmArguments) {
                if (javaVmArgument.trim().length() <= 0) continue;
                if (javaVmArgument.startsWith(javaVmArgumentsIndicator)) {
                    parsedJavaVmArguments.add(javaVmArgument);
                    continue;
                }
                String javaVmArgumentExtension = javaVmArgument;
                javaVmArgument = (String)parsedJavaVmArguments.remove(parsedJavaVmArguments.size() - 1) + javaVmArgumentsDelimiter + javaVmArgumentExtension;
                parsedJavaVmArguments.add(javaVmArgument);
            }
        } else {
            parsedJavaVmArguments.add(javaVmArguments);
        }
        return parsedJavaVmArguments;
    }

    private String getVMLocalConnectorAddress(VirtualMachine wlpvm) throws IOException {
        String PROPERTY_NAME = "com.sun.management.jmxremote.localConnectorAddress";
        String serviceURL = wlpvm.getAgentProperties().getProperty(PROPERTY_NAME);
        if (serviceURL == null) {
            serviceURL = wlpvm.getSystemProperties().getProperty(PROPERTY_NAME);
        }
        if (log.isLoggable(Level.FINER)) {
            log.finer("service url: " + serviceURL);
        }
        return serviceURL;
    }

    private String findVirtualMachineIdByName(String serverName) {
        if (log.isLoggable(Level.FINER)) {
            log.entering(className, "findVirtualMachineIdByName");
        }
        List<VirtualMachineDescriptor> vmds = VirtualMachine.list();
        for (VirtualMachineDescriptor vmd : vmds) {
            String displayName = vmd.displayName();
            if (log.isLoggable(Level.FINER)) {
                log.finer("VMD displayName: " + displayName);
                log.finer("VMD id: " + vmd.id());
            }
            if (!displayName.contains(serverName) || !displayName.contains("ws-server.jar") && !displayName.contains("ws-launch.jar")) continue;
            if (log.isLoggable(Level.FINER)) {
                log.exiting(className, "findVirtualMachineIdByName", vmd.id());
            }
            return vmd.id();
        }
        if (log.isLoggable(Level.FINER)) {
            log.exiting(className, "findVirtualMachineIdByName");
        }
        return null;
    }

    public ProtocolMetaData deploy(Archive<?> archive) throws DeploymentException {
        if (log.isLoggable(Level.FINER)) {
            log.entering(className, "deploy");
            log.finer("Archive provided to deploy method: " + archive.toString(true));
        }
        this.waitForVerifyApps();
        String archiveName = archive.getName();
        String archiveType = this.createDeploymentType(archiveName);
        String deployName = this.createDeploymentName(archiveName);
        try {
            File exportedArchiveLocation;
            if (this.containerConfiguration.isDeployTypeXML()) {
                if (!(archiveType.equalsIgnoreCase("ear") || archiveType.equalsIgnoreCase("war") || archiveType.equalsIgnoreCase("eba"))) {
                    throw new DeploymentException("Invalid archive type: " + archiveType + ".  Valid archive types are ear, war, and eba.");
                }
                String appDir = this.getAppDirectory();
                exportedArchiveLocation = new File(appDir, archiveName);
                ((ZipExporter)archive.as(ZipExporter.class)).exportTo(exportedArchiveLocation, true);
                Document document = this.readServerXML();
                this.addApplication(document, deployName, archiveName, archiveType);
                this.writeServerXML(document);
            } else {
                String dropInDir = this.getDropInDirectory();
                exportedArchiveLocation = new File(dropInDir, archiveName);
                ((ZipExporter)archive.as(ZipExporter.class)).exportTo(exportedArchiveLocation, true);
            }
            this.waitForApplicationTargetState(new String[]{deployName}, true, this.containerConfiguration.getAppDeployTimeout());
            ProtocolMetaData metaData = new ProtocolMetaData();
            HTTPContext httpContext = new HTTPContext("localhost", this.getHttpPort());
            List<String> contextRoots = new ArrayList<String>();
            if (archive instanceof EnterpriseArchive) {
                contextRoots = this.findArquillianContextRoots((EnterpriseArchive)archive, deployName);
            } else {
                contextRoots.add(deployName);
            }
            for (String contextRoot : contextRoots) {
                httpContext.add(new Servlet("ArquillianServletRunner", contextRoot));
            }
            metaData.addContext((Object)httpContext);
            if (log.isLoggable(Level.FINER)) {
                log.exiting(className, "deploy");
            }
            return metaData;
        }
        catch (Exception e) {
            throw new DeploymentException("Exception while deploying application.", (Throwable)e);
        }
    }

    private void waitForVerifyApps() throws DeploymentException {
        String verifyApps = this.containerConfiguration.getVerifyApps();
        if (verifyApps != null && verifyApps.length() > 0) {
            String[] verifyAppArray = verifyApps.split(",");
            HashSet<String> verifyAppSet = new HashSet<String>();
            for (int i = 0; i < verifyAppArray.length; ++i) {
                String appToVerify = verifyAppArray[i];
                if ((appToVerify = appToVerify.trim()).length() <= 0) continue;
                verifyAppSet.add(appToVerify);
            }
            int totalTimeout = this.containerConfiguration.getVerifyAppDeployTimeout() * verifyAppSet.size();
            this.waitForApplicationTargetState(verifyAppSet.toArray(new String[verifyAppSet.size()]), true, totalTimeout);
        }
    }

    private List<String> findArquillianContextRoots(EnterpriseArchive ear, String deployName) throws DeploymentException {
        ArrayList<String> contextRoots = new ArrayList<String>();
        int testableWarCounter = 0;
        int totalWarCounter = 0;
        WebArchive latestWar = null;
        for (ArchivePath path : ear.getContent().keySet()) {
            if (!path.get().endsWith("war")) continue;
            WebArchive war = (WebArchive)ear.getAsType(WebArchive.class, path);
            ++totalWarCounter;
            if (Testable.isArchiveToTest((Archive)war)) {
                contextRoots.add(this.getContextRoot(ear, war));
                ++testableWarCounter;
            }
            latestWar = war;
        }
        if (testableWarCounter == 0) {
            if (totalWarCounter == 1) {
                contextRoots.add(this.getContextRoot(ear, latestWar));
            } else {
                contextRoots.add(deployName);
            }
        }
        return contextRoots;
    }

    private String getContextRoot(EnterpriseArchive ear, WebArchive war) throws DeploymentException {
        Node applicationXmlNode = ear.get("META-INF/application.xml");
        if (applicationXmlNode != null && applicationXmlNode.getAsset() != null) {
            InputStream input;
            block5: {
                String string;
                input = null;
                try {
                    input = ear.get("META-INF/application.xml").getAsset().openStream();
                    Document applicationXml = this.readXML(input);
                    XPath xPath = XPathFactory.newInstance().newXPath();
                    XPathExpression ctxRootSelector = xPath.compile("//module/web[web-uri/text()='" + war.getName() + "']/context-root");
                    String ctxRoot = ctxRootSelector.evaluate(applicationXml);
                    if (ctxRoot == null || ctxRoot.trim().length() <= 0) break block5;
                    string = ctxRoot;
                }
                catch (Exception e) {
                    try {
                        throw new DeploymentException("Unable to retrieve context-root from application.xml");
                    }
                    catch (Throwable throwable) {
                        WLPManagedContainer.closeQuietly(input);
                        throw throwable;
                    }
                }
                WLPManagedContainer.closeQuietly(input);
                return string;
            }
            WLPManagedContainer.closeQuietly(input);
        }
        return this.createDeploymentName(war.getName());
    }

    private static void closeQuietly(Closeable closable) {
        try {
            if (closable != null) {
                closable.close();
            }
        }
        catch (IOException e) {
            log.log(Level.WARNING, "Exception while closing Closeable", e);
        }
    }

    private int getHttpPort() throws DeploymentException {
        int httpPort;
        if (log.isLoggable(Level.FINER)) {
            log.entering(className, "getHttpPort");
        }
        if ((httpPort = this.containerConfiguration.getHttpPort()) == 0) {
            httpPort = this.getHttpPortFromChannelFWMBean("defaultHttpEndpoint");
        }
        if (log.isLoggable(Level.FINER)) {
            log.exiting(className, "getHttpPort", httpPort);
        }
        return httpPort;
    }

    private int getHttpPortFromChannelFWMBean(String endpointName) throws DeploymentException {
        int httpPort;
        if (log.isLoggable(Level.FINER)) {
            log.entering(className, "getHttpPortFromChannelFWMBean", endpointName);
        }
        ObjectName endpointMBean = null;
        try {
            endpointMBean = new ObjectName("WebSphere:feature=channelfw,type=endpoint,name=" + endpointName);
        }
        catch (MalformedObjectNameException e) {
            throw new DeploymentException("The generated object name is wrong. The endpointName used was '" + endpointName + "'", (Throwable)e);
        }
        catch (NullPointerException e) {
            throw new DeploymentException("This should never happen", (Throwable)e);
        }
        try {
            if (!this.mbsc.isRegistered(endpointMBean)) {
                throw new DeploymentException("The Channel Framework MBean with endpointName '" + endpointName + "' does not exist.");
            }
            httpPort = (Integer)this.mbsc.getAttribute(endpointMBean, "Port");
            log.finer("httpPort: " + httpPort);
        }
        catch (Exception e) {
            throw new DeploymentException("Exception while retrieving httpPort information from Channel Framework MBean. The httpPort can also be manually configured in the arquillian container configuration.", (Throwable)e);
        }
        if (log.isLoggable(Level.FINER)) {
            log.exiting(className, "getHttpPortFromChannelFWMBean", httpPort);
        }
        return httpPort;
    }

    public void undeploy(Archive<?> archive) throws DeploymentException {
        block12: {
            if (log.isLoggable(Level.FINER)) {
                log.entering(className, "undeploy");
            }
            String archiveName = archive.getName();
            String deployName = this.createDeploymentName(archiveName);
            try {
                if (this.containerConfiguration.isDeployTypeXML()) {
                    Document document = this.readServerXML();
                    this.removeApplication(document);
                    this.writeServerXML(document);
                    this.waitForApplicationTargetState(new String[]{deployName}, false, this.containerConfiguration.getAppUndeployTimeout());
                    String appDir = this.getAppDirectory();
                    File exportedArchiveLocation = new File(appDir, archiveName);
                    if (!this.containerConfiguration.isFailSafeUndeployment()) {
                        try {
                            if (!Files.deleteIfExists(exportedArchiveLocation.toPath())) {
                                throw new DeploymentException("Archive already deleted from apps directory");
                            }
                            break block12;
                        }
                        catch (IOException e) {
                            throw new DeploymentException("Unable to delete archive from apps directory", (Throwable)e);
                        }
                    }
                    try {
                        Files.deleteIfExists(exportedArchiveLocation.toPath());
                    }
                    catch (IOException e) {
                        log.log(Level.WARNING, "Unable to delete archive from apps directory -> failsafe -> file marked for delete on exit", e);
                        exportedArchiveLocation.deleteOnExit();
                    }
                    break block12;
                }
                String dropInDir = this.getDropInDirectory();
                File exportedArchiveLocation = new File(dropInDir, archiveName);
                if (!exportedArchiveLocation.delete()) {
                    throw new DeploymentException("Unable to delete archive from dropIn directory");
                }
                this.waitForApplicationTargetState(new String[]{deployName}, false, this.containerConfiguration.getAppUndeployTimeout());
            }
            catch (Exception e) {
                throw new DeploymentException("Exception while undeploying application.", (Throwable)e);
            }
        }
        if (log.isLoggable(Level.FINER)) {
            log.exiting(className, "undeploy");
        }
    }

    private String getDropInDirectory() {
        String dropInDir = this.containerConfiguration.getWlpHome() + "/usr/servers/" + this.containerConfiguration.getServerName() + "/dropins";
        if (log.isLoggable(Level.FINER)) {
            log.finer("dropInDir: " + dropInDir);
        }
        return dropInDir;
    }

    private String getAppDirectory() {
        String appDir = this.containerConfiguration.getWlpHome() + "/usr/servers/" + this.containerConfiguration.getServerName() + "/apps";
        if (log.isLoggable(Level.FINER)) {
            log.finer("appDir: " + appDir);
        }
        return appDir;
    }

    private String getServerXML() {
        String serverXML = this.containerConfiguration.getWlpHome() + "/usr/servers/" + this.containerConfiguration.getServerName() + "/server.xml";
        if (log.isLoggable(Level.FINER)) {
            log.finer("server.xml: " + serverXML);
        }
        return serverXML;
    }

    private String getDefaultServerXML() {
        String serverXML = this.containerConfiguration.getWlpHome() + "/templates/servers/defaultServer/server.xml";
        if (log.isLoggable(Level.FINER)) {
            log.finer("default server.xml: " + serverXML);
        }
        return serverXML;
    }

    private String createDeploymentName(String archiveName) {
        return archiveName.substring(0, archiveName.lastIndexOf("."));
    }

    private String createDeploymentType(String archiveName) {
        return archiveName.substring(archiveName.lastIndexOf(".") + 1);
    }

    private Document readServerXML() throws DeploymentException {
        return this.readServerXML(this.getServerXML());
    }

    private Document readServerXML(String serverXML) throws DeploymentException {
        Document document;
        FileInputStream input = null;
        try {
            input = new FileInputStream(new File(serverXML));
            document = this.readXML(input);
        }
        catch (Exception e) {
            try {
                throw new DeploymentException("Exception while reading server.xml file.", (Throwable)e);
            }
            catch (Throwable throwable) {
                WLPManagedContainer.closeQuietly(input);
                throw throwable;
            }
        }
        WLPManagedContainer.closeQuietly(input);
        return document;
    }

    private Document readXML(InputStream input) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        return documentBuilder.parse(input);
    }

    private void writeServerXML(Document doc) throws DeploymentException {
        this.writeServerXML(doc, this.getServerXML());
    }

    private void writeServerXML(Document doc, String serverXML) throws DeploymentException {
        try {
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer tr = tf.newTransformer();
            tr.setOutputProperty("indent", "yes");
            DOMSource source = new DOMSource(doc);
            StreamResult res = new StreamResult(new File(serverXML));
            tr.transform(source, res);
        }
        catch (Exception e) {
            throw new DeploymentException("Exception wile writing server.xml file.", (Throwable)e);
        }
    }

    private Element createFeature(Document doc, String featureName) {
        Element feature = doc.createElement("feature");
        feature.appendChild(doc.createTextNode(featureName));
        return feature;
    }

    private void addFeatures(Document doc, String featureNames) {
        NodeList rootList = doc.getElementsByTagName("featureManager");
        org.w3c.dom.Node featureManager = rootList.item(0);
        for (String featureName : featureNames.split(",")) {
            if (this.checkFeatureAlreadyThere(featureName, featureManager.getChildNodes())) continue;
            featureManager.appendChild(this.createFeature(doc, featureName));
        }
    }

    private boolean checkFeatureAlreadyThere(String featureName, NodeList featureManagerList) {
        for (int i = 0; i < featureManagerList.getLength(); ++i) {
            org.w3c.dom.Node featureText;
            org.w3c.dom.Node feature = featureManagerList.item(i);
            if (!"feature".equals(feature.getNodeName()) || (featureText = feature.getFirstChild()) == null || !featureText.getTextContent().trim().equals(featureName)) continue;
            return true;
        }
        return false;
    }

    private Element createApplication(Document doc, String deploymentName, String archiveName, String type) throws DeploymentException {
        Element application = doc.createElement("application");
        application.setAttribute("id", deploymentName);
        application.setAttribute("location", archiveName);
        application.setAttribute("name", deploymentName);
        application.setAttribute("type", type);
        if (this.containerConfiguration.getSharedLib() != null || this.containerConfiguration.getApiTypeVisibility() != null) {
            Element classloader = doc.createElement("classloader");
            if (this.containerConfiguration.getSharedLib() != null) {
                classloader.setAttribute("commonLibraryRef", this.containerConfiguration.getSharedLib());
            }
            if (this.containerConfiguration.getApiTypeVisibility() != null) {
                classloader.setAttribute("apiTypeVisibility", this.containerConfiguration.getApiTypeVisibility());
            }
            application.appendChild(classloader);
        }
        if (this.containerConfiguration.getSecurityConfiguration() != null) {
            FileInputStream input = null;
            try {
                input = new FileInputStream(new File(this.containerConfiguration.getSecurityConfiguration()));
                Document securityConfiguration = this.readXML(input);
                application.appendChild(doc.adoptNode(securityConfiguration.getDocumentElement().cloneNode(true)));
            }
            catch (Exception e) {
                try {
                    throw new DeploymentException("Exception while reading " + this.containerConfiguration.getSecurityConfiguration() + " file.", (Throwable)e);
                }
                catch (Throwable throwable) {
                    WLPManagedContainer.closeQuietly(input);
                    throw throwable;
                }
            }
            WLPManagedContainer.closeQuietly(input);
        }
        return application;
    }

    private void addApplication(Document doc, String deployName, String archiveName, String type) throws DOMException, DeploymentException {
        NodeList rootList = doc.getElementsByTagName("server");
        org.w3c.dom.Node root = rootList.item(0);
        root.appendChild(this.createApplication(doc, deployName, archiveName, type));
    }

    private void removeApplication(Document doc) {
        org.w3c.dom.Node server = doc.getElementsByTagName("server").item(0);
        NodeList serverlist = server.getChildNodes();
        for (int i = 0; serverlist.getLength() > i; ++i) {
            org.w3c.dom.Node node = serverlist.item(i);
            if (!node.getNodeName().equals("application")) continue;
            node.getParentNode().removeChild(node);
        }
    }

    private void logAllApps() {
        try {
            log.info("Listing all apps...");
            Set<ObjectInstance> allApps = this.mbsc.queryMBeans(null, null);
            log.info("Size of results: " + allApps.size());
            for (ObjectInstance app : allApps) {
                log.info(app.getObjectName().toString());
            }
        }
        catch (IOException e) {
            log.warning("Could not print list of all apps. Exception thrown is: " + e.getMessage());
        }
    }

    private void waitForApplicationTargetState(String[] applicationNames, boolean targetState, int timeout) throws DeploymentException {
        if (log.isLoggable(Level.FINER)) {
            log.entering(className, "waitForApplicationTargetState");
        }
        HashMap<ObjectName, AppStatus> appMBeans = new HashMap<ObjectName, AppStatus>();
        for (String applicationName : applicationNames) {
            ObjectName appMBean = null;
            try {
                appMBean = new ObjectName("WebSphere:service=com.ibm.websphere.application.ApplicationMBean,name=" + applicationName);
            }
            catch (MalformedObjectNameException e) {
                throw new DeploymentException("The generated object name is wrong. The applicationName used was '" + applicationName + "'", (Throwable)e);
            }
            catch (NullPointerException e) {
                throw new DeploymentException("This should never happen", (Throwable)e);
            }
            appMBeans.put(appMBean, AppStatus.INITIAL);
        }
        try {
            this.checkApplicationStatus(appMBeans, targetState, timeout);
        }
        catch (Exception e) {
            throw new DeploymentException("Exception while checking application state.", (Throwable)e);
        }
        if (log.isLoggable(Level.FINER)) {
            log.exiting(className, "waitForApplicationTargetState");
        }
    }

    private void checkApplicationStatus(Map<ObjectName, AppStatus> appMBeans, boolean targetState, int timeout) throws Exception {
        int timeleft = timeout * 1000;
        do {
            for (Map.Entry<ObjectName, AppStatus> entry : appMBeans.entrySet()) {
                ObjectName appMBean = entry.getKey();
                AppStatus status = entry.getValue();
                if (status == AppStatus.INITIAL && this.mbsc.isRegistered(appMBean) == targetState) {
                    status = AppStatus.MATCHES_TARGET_STATE;
                }
                if (status == AppStatus.MATCHES_TARGET_STATE) {
                    if (targetState) {
                        String applicationState = (String)this.mbsc.getAttribute(appMBean, "State");
                        if (applicationState.contentEquals("STARTED")) {
                            status = AppStatus.FINISHED;
                        }
                    } else {
                        status = AppStatus.FINISHED;
                    }
                }
                appMBeans.put(appMBean, status);
            }
            if (this.allAppsReady(appMBeans)) {
                return;
            }
            Thread.sleep(100L);
        } while ((timeleft -= 100) > 0);
        this.logAllApps();
        String appMessageStatus = "";
        for (Map.Entry<ObjectName, AppStatus> entry : appMBeans.entrySet()) {
            String appName = entry.getKey().getCanonicalName();
            AppStatus status = entry.getValue();
            if (status == AppStatus.INITIAL) {
                appMessageStatus = appMessageStatus + "Timeout while waiting for \"" + appName + "\" ApplicationMBean to reach targetState.\n";
                continue;
            }
            if (status != AppStatus.MATCHES_TARGET_STATE) continue;
            appMessageStatus = appMessageStatus + "Timeout while waiting for \"" + appName + "\" ApplicationState to reach STARTED.\n";
        }
        throw new DeploymentException(appMessageStatus);
    }

    private boolean allAppsReady(Map<ObjectName, AppStatus> appMBeans) {
        for (AppStatus status : appMBeans.values()) {
            if (status == AppStatus.FINISHED) continue;
            return false;
        }
        return true;
    }

    public void stop() throws LifecycleException {
        if (log.isLoggable(Level.FINER)) {
            log.entering(className, "stop");
        }
        try {
            this.jmxConnector.close();
        }
        catch (IOException e) {
            throw new LifecycleException("Communication with the MBean Server failed.", (Throwable)e);
        }
        if (this.shutdownThread != null) {
            Runtime.getRuntime().removeShutdownHook(this.shutdownThread);
            this.shutdownThread = null;
        }
        try {
            if (this.wlpProcess != null) {
                this.wlpProcess.destroy();
                this.wlpProcess.waitFor();
                this.wlpProcess = null;
            }
        }
        catch (Exception e) {
            throw new LifecycleException("Could not stop container", (Throwable)e);
        }
        if (log.isLoggable(Level.FINER)) {
            log.exiting(className, "stop");
        }
    }

    public ProtocolDescription getDefaultProtocol() {
        if (log.isLoggable(Level.FINER)) {
            log.entering(className, "getDefaultProtocol");
        }
        String defaultProtocol = "Servlet 3.0";
        if (log.isLoggable(Level.FINER)) {
            log.exiting(className, "getDefaultProtocol", defaultProtocol);
        }
        return new ProtocolDescription(defaultProtocol);
    }

    public Class<WLPManagedContainerConfiguration> getConfigurationClass() {
        return WLPManagedContainerConfiguration.class;
    }

    public void deploy(Descriptor descriptor) throws DeploymentException {
    }

    public void undeploy(Descriptor descriptor) throws DeploymentException {
    }

    private class ConsoleConsumer
    implements Runnable {
        private ConsoleConsumer() {
        }

        public void run() {
            InputStream stream = WLPManagedContainer.this.wlpProcess.getInputStream();
            boolean writeOutput = WLPManagedContainer.this.containerConfiguration.isOutputToConsole();
            try {
                int num;
                byte[] buf = new byte[32];
                while ((num = stream.read(buf)) != -1) {
                    if (!writeOutput) continue;
                    System.out.write(buf, 0, num);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum AppStatus {
        INITIAL,
        MATCHES_TARGET_STATE,
        FINISHED;

    }
}

