/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.was.wlp_remote_8_5;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.fluent.Executor;
import org.apache.http.client.fluent.Request;
import org.apache.http.entity.ContentType;
import org.jboss.arquillian.container.was.wlp_remote_8_5.WLPRemoteContainerConfiguration;

public class WLPRestClient {
    private static final String className = WLPRestClient.class.getName();
    private static Logger log = Logger.getLogger(className);
    private WLPRemoteContainerConfiguration configuration;
    private static final String IBMJMX_CONNECTOR_REST = "/IBMJMXConnectorREST";
    private static final String FILE_ENDPOINT = "/IBMJMXConnectorREST/file/";
    private static final String MBEANS_ENDPOINT = "/IBMJMXConnectorREST/mbeans/";
    private static final String UTF_8 = "UTF-8";
    private static final String STARTED = "STARTED";
    private final Executor executor;

    public WLPRestClient(WLPRemoteContainerConfiguration configuration) {
        this.configuration = configuration;
        this.executor = Executor.newInstance().auth(new HttpHost(configuration.getHostName()), configuration.getUsername(), configuration.getPassword());
    }

    public void deploy(File archive) throws ClientProtocolException, IOException {
        if (log.isLoggable(Level.FINER)) {
            log.entering(className, "deploy");
        }
        String deployPath = String.format("${wlp.user.dir}/servers/%s/dropins/%s", this.configuration.getServerName(), archive.getName());
        String serverRestEndpoint = String.format("https://%s:%d%s%s", this.configuration.getHostName(), this.configuration.getHttpsPort(), FILE_ENDPOINT, URLEncoder.encode(deployPath, UTF_8));
        HttpResponse result = this.executor.execute(Request.Post((String)serverRestEndpoint).useExpectContinue().version(HttpVersion.HTTP_1_1).bodyFile(archive, ContentType.DEFAULT_BINARY)).returnResponse();
        if (log.isLoggable(Level.FINE)) {
            log.fine("While deploying file " + archive.getName() + ", server returned response: " + result.getStatusLine().getStatusCode());
        }
        if (!this.isSuccessful(result)) {
            throw new ClientProtocolException("Could not deploy application to server, server returned response: " + result);
        }
        if (log.isLoggable(Level.FINER)) {
            log.exiting(className, "deploy");
        }
    }

    public void undeploy(String applicationName) throws ClientProtocolException, IOException {
        if (log.isLoggable(Level.FINER)) {
            log.entering(className, "undeploy");
        }
        String deployPath = String.format("${wlp.user.dir}/servers/%s/dropins/%s", this.configuration.getServerName(), applicationName);
        String serverRestEndpoint = String.format("https://%s:%d%s%s", this.configuration.getHostName(), this.configuration.getHttpsPort(), FILE_ENDPOINT, URLEncoder.encode(deployPath, UTF_8));
        HttpResponse result = this.executor.execute(Request.Delete((String)serverRestEndpoint).useExpectContinue().version(HttpVersion.HTTP_1_1)).returnResponse();
        if (!this.isSuccessful(result)) {
            throw new ClientProtocolException("Unable to undeploy application " + applicationName + ", server returned response: " + result.getStatusLine());
        }
        log.fine("File " + applicationName + " was deleted");
        if (log.isLoggable(Level.FINER)) {
            log.exiting(className, "undeploy", result);
        }
    }

    public boolean isServerUp() throws ClientProtocolException, IOException {
        String hostName;
        HttpResponse result;
        if (log.isLoggable(Level.FINER)) {
            log.entering(className, "isServerUp");
        }
        if (!this.isSuccessful(result = this.executor.execute(Request.Get((String)(hostName = String.format("https://%s:%d%s", this.configuration.getHostName(), this.configuration.getHttpsPort(), IBMJMX_CONNECTOR_REST)))).returnResponse())) {
            throw new ClientProtocolException("Could not successfully connect to REST endpoint, server returned response: " + result);
        }
        if (log.isLoggable(Level.FINER)) {
            log.exiting(className, "isServerUp");
        }
        return this.isSuccessful(result);
    }

    public String getServerName() throws ClientProtocolException, IOException {
        if (log.isLoggable(Level.FINER)) {
            log.entering(className, "getServerName");
        }
        String restEndpoint = String.format("https://%s:%d%sWebSphere:feature=kernel,name=ServerInfo/attributes/Name", this.configuration.getHostName(), this.configuration.getHttpsPort(), MBEANS_ENDPOINT);
        String jsonResponse = this.executor.execute(Request.Get((String)restEndpoint)).returnContent().asString();
        String serverName = this.parseJsonResponse(jsonResponse);
        if (log.isLoggable(Level.FINER)) {
            log.exiting(className, "isServerUp");
        }
        return serverName;
    }

    public boolean isApplicationStarted(String applicationName) {
        if (log.isLoggable(Level.FINER)) {
            log.entering(className, "isApplicationStarted");
        }
        String restEndpoint = String.format("https://%s:%d%sWebSphere:service=com.ibm.websphere.application.ApplicationMBean,name=%s/attributes/State", this.configuration.getHostName(), this.configuration.getHttpsPort(), MBEANS_ENDPOINT, applicationName);
        String status = "";
        try {
            String jsonResponse = this.executor.execute(Request.Get((String)restEndpoint)).returnContent().asString();
            status = this.parseJsonResponse(jsonResponse);
        }
        catch (ClientProtocolException e) {
            log.finest("Expected error occurred while checking if application " + applicationName + " is already started, app may not have been deployed yet. Ok to continue. " + (Object)((Object)e));
            status = "error";
        }
        catch (IOException e) {
            log.severe("IOException occurred while checking if application " + applicationName + " is already started " + e);
            status = "error";
        }
        boolean applicationState = STARTED.equals(status);
        if (log.isLoggable(Level.FINER)) {
            log.exiting(className, "isApplicationStarted", applicationState);
        }
        return applicationState;
    }

    private String parseJsonResponse(String jsonString) {
        ObjectMapper mapper = new ObjectMapper();
        String value = "";
        try {
            Map result = (Map)mapper.readValue(jsonString.getBytes(), Map.class);
            value = (String)result.get("value");
        }
        catch (JsonParseException e) {
            log.severe("Error parsing Json response " + (Object)((Object)e));
        }
        catch (JsonMappingException e) {
            log.severe("Error mapping Json response " + (Object)((Object)e));
        }
        catch (IOException e) {
            log.severe("IOException while parsing Json response " + e);
        }
        return value;
    }

    private boolean isSuccessful(HttpResponse response) {
        return response.getStatusLine().getStatusCode() >= 200 && response.getStatusLine().getStatusCode() <= 204;
    }
}

