/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.wls;

import org.jboss.arquillian.container.spi.ConfigurationException;
import org.jboss.arquillian.container.wls.CommonWebLogicConfiguration;
import org.jboss.arquillian.container.wls.Validate;

public class CommonManagedWebLogicConfiguration
extends CommonWebLogicConfiguration {
    private static final String DEFAULT_WIN_STARTUP_SCRIPT = "bin\\\\startWebLogic.cmd";
    private static final String DEFAULT_LINUX_STARTUP_SCRIPT = "./bin/startWebLogic.sh";
    private static final String DEFAULT_WIN_SHUTDOWN_SCRIPT = "bin\\\\stopWebLogic.cmd";
    private static final String DEFAULT_LINUX_SHUTDOWN_SCRIPT = "./bin/stopWebLogic.sh";
    private String middlewareHome = System.getenv("MW_HOME");
    private String domainDirectory;
    private String jvmOptions;
    private int timeout = 60;
    private boolean outputToConsole = false;
    private boolean allowConnectingToRunningServer = false;
    private String startServerScript;
    private String stopServerScript;

    public void validate() throws ConfigurationException {
        String os;
        Validate.directoryExists(this.middlewareHome, "The middlewareHome resolved to " + this.middlewareHome + " and could not be located. Verify the property in arquillian.xml");
        Validate.directoryExists(this.domainDirectory, "The domainDirectory resolved to " + this.domainDirectory + " and could not be located. Verify the property in arquillian.xml");
        if (this.startServerScript != null && this.startServerScript.length() > 0) {
            Validate.isValidFile(this.startServerScript, "The startServerScript resolved to " + this.startServerScript + " and could not be located. Verify the property in arquillian.xml");
        } else {
            os = System.getProperty("os.name").toLowerCase();
            this.startServerScript = os.startsWith("windows") ? DEFAULT_WIN_STARTUP_SCRIPT : DEFAULT_LINUX_STARTUP_SCRIPT;
        }
        if (this.stopServerScript != null && this.stopServerScript.length() > 0) {
            Validate.isValidFile(this.stopServerScript, "The stopServerScript resolved to " + this.stopServerScript + " and could not be located. Verify the property in arquillian.xml");
        } else {
            os = System.getProperty("os.name").toLowerCase();
            this.stopServerScript = os.startsWith("windows") ? DEFAULT_WIN_SHUTDOWN_SCRIPT : DEFAULT_LINUX_SHUTDOWN_SCRIPT;
        }
        super.validate();
    }

    public String getMiddlewareHome() {
        return this.middlewareHome;
    }

    public void setMiddlewareHome(String middlewareHome) {
        this.middlewareHome = middlewareHome;
    }

    public String getDomainDirectory() {
        return this.domainDirectory;
    }

    public void setDomainDirectory(String domainDirectory) {
        this.domainDirectory = domainDirectory;
    }

    public String getJvmOptions() {
        return this.jvmOptions;
    }

    public void setJvmOptions(String jvmOptions) {
        this.jvmOptions = jvmOptions;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public boolean isOutputToConsole() {
        return this.outputToConsole;
    }

    public void setOutputToConsole(boolean outputToConsole) {
        this.outputToConsole = outputToConsole;
    }

    public boolean isAllowConnectingToRunningServer() {
        return this.allowConnectingToRunningServer;
    }

    public void setAllowConnectingToRunningServer(boolean allowConnectingToRunningServer) {
        this.allowConnectingToRunningServer = allowConnectingToRunningServer;
    }

    public String getStartServerScript() {
        return this.startServerScript;
    }

    public void setStartServerScript(String startServerScript) {
        this.startServerScript = startServerScript;
    }

    public String getStopServerScript() {
        return this.stopServerScript;
    }

    public void setStopServerScript(String stopServerScript) {
        this.stopServerScript = stopServerScript;
    }
}

