/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.wls;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.jboss.arquillian.container.spi.client.container.DeploymentException;
import org.jboss.arquillian.container.spi.client.container.LifecycleException;
import org.jboss.arquillian.container.spi.client.protocol.metadata.ProtocolMetaData;
import org.jboss.arquillian.container.wls.CommonWebLogicConfiguration;
import org.jboss.arquillian.container.wls.HttpContextBuilder;
import org.jboss.arquillian.container.wls.WebLogicJMXLibClassLoader;

public class WebLogicJMXClient {
    private static final ThreadLocal<String> trustStorePath = new ThreadLocal();
    private static final ThreadLocal<String> trustStorePassword = new ThreadLocal();
    private CommonWebLogicConfiguration configuration;
    private MBeanServerConnection connection;
    private JMXConnector connector;
    private ObjectName domainRuntimeService;
    private ClassLoader jmxLibraryClassLoader;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebLogicJMXClient(CommonWebLogicConfiguration configuration) throws LifecycleException {
        this.configuration = configuration;
        try {
            this.domainRuntimeService = new ObjectName("com.bea:Name=DomainRuntimeService,Type=weblogic.management.mbeanservers.domainruntime.DomainRuntimeServiceMBean");
        }
        catch (MalformedObjectNameException objectNameEx) {
            throw new IllegalStateException(objectNameEx);
        }
        try {
            this.setConfiguredTrustStore();
            this.initWebLogicJMXLibClassLoader();
            this.createConnection();
        }
        finally {
            this.revertToInitialState();
        }
    }

    public ProtocolMetaData deploy(String deploymentName, File deploymentArchive) throws DeploymentException {
        this.doDeploy(deploymentName, deploymentArchive);
        return this.verifyDeployment(deploymentName);
    }

    public ProtocolMetaData verifyDeployment(String deploymentName) throws DeploymentException {
        try {
            this.setConfiguredTrustStore();
            try {
                ProtocolMetaData protocolMetaData = new ProtocolMetaData().addContext((Object)new HttpContextBuilder(deploymentName, this.configuration, this.connection, this.domainRuntimeService).createContext());
                return protocolMetaData;
            }
            catch (Exception ex) {
                throw new DeploymentException("Failed to populate the HTTPContext with the deployment details", (Throwable)ex);
            }
        }
        finally {
            this.revertToInitialState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undeploy(String deploymentName) throws DeploymentException {
        try {
            this.setConfiguredTrustStore();
            this.invokeUndeployOperation(deploymentName);
        }
        finally {
            this.revertToInitialState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void verifyUndeployment(String deploymentName) throws DeploymentException {
        try {
            this.setConfiguredTrustStore();
            ObjectName deployment = null;
            try {
                deployment = new HttpContextBuilder(deploymentName, this.configuration, this.connection, this.domainRuntimeService).findMatchingDeployment(deploymentName);
            }
            catch (Exception ex) {
                throw new DeploymentException("Failed to obtain the status of the deployment.", (Throwable)ex);
            }
            if (deployment != null) {
                throw new DeploymentException("Failed to undeploy the deployed application.");
            }
        }
        finally {
            this.revertToInitialState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws LifecycleException {
        try {
            this.setConfiguredTrustStore();
            this.closeConnection();
        }
        finally {
            this.revertToInitialState();
        }
    }

    private void invokeUndeployOperation(String deploymentName) throws DeploymentException {
        try {
            ObjectName domainRuntime = (ObjectName)this.connection.getAttribute(this.domainRuntimeService, "DomainRuntime");
            ObjectName deploymentManager = (ObjectName)this.connection.getAttribute(domainRuntime, "DeploymentManager");
            ObjectName appDeploymentRuntime = (ObjectName)this.connection.invoke(deploymentManager, "lookupAppDeploymentRuntime", new Object[]{deploymentName}, new String[]{String.class.getName()});
            ObjectName deploymentProgressObject = (ObjectName)this.connection.invoke(appDeploymentRuntime, "undeploy", new Object[0], new String[0]);
            this.processDeploymentProgress(deploymentName, deploymentManager, deploymentProgressObject);
        }
        catch (DeploymentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DeploymentException(e.getMessage(), (Throwable)e);
        }
    }

    private void doDeploy(String deploymentName, File deploymentArchive) throws DeploymentException {
        try {
            ObjectName domainRuntime = (ObjectName)this.connection.getAttribute(this.domainRuntimeService, "DomainRuntime");
            ObjectName deploymentManager = (ObjectName)this.connection.getAttribute(domainRuntime, "DeploymentManager");
            ObjectName deploymentProgressObject = (ObjectName)this.connection.invoke(deploymentManager, "deploy", new Object[]{deploymentName, deploymentArchive.getAbsolutePath(), null}, new String[]{String.class.getName(), String.class.getName(), String.class.getName()});
            this.processDeploymentProgress(deploymentName, deploymentManager, deploymentProgressObject);
        }
        catch (DeploymentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DeploymentException(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processDeploymentProgress(String appName, ObjectName deploymentManager, ObjectName deploymentProgressObject) throws Exception {
        if (deploymentProgressObject != null) {
            block3: {
                try {
                    String state = this.waitForDeployToComplete(deploymentProgressObject, 200);
                    if (!state.equals("STATE_FAILED")) break block3;
                    String[] targets = (String[])this.connection.getAttribute(deploymentProgressObject, "FailedTargets");
                    RuntimeException[] exceptions = (RuntimeException[])this.connection.invoke(deploymentProgressObject, "getExceptions", new Object[]{targets[0]}, new String[]{String.class.getName()});
                    throw new DeploymentException("Deployment Failed on server: " + exceptions[0].getMessage(), (Throwable)exceptions[0]);
                }
                catch (Throwable throwable) {
                    this.connection.invoke(deploymentManager, "removeDeploymentProgressObject", new Object[]{appName}, new String[]{"java.lang.String"});
                    throw throwable;
                }
            }
            this.connection.invoke(deploymentManager, "removeDeploymentProgressObject", new Object[]{appName}, new String[]{"java.lang.String"});
        }
    }

    private String waitForDeployToComplete(ObjectName progressObj, int timeToWaitInSecs) throws Exception {
        for (int i = 0; i < timeToWaitInSecs; ++i) {
            String state = (String)this.connection.getAttribute(progressObj, "State");
            if ("STATE_COMPLETED".equals(state) || "STATE_FAILED".equals(state)) {
                return state;
            }
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
        }
        return "STATE_UNKNOWN";
    }

    private void initWebLogicJMXLibClassLoader() {
        File wlHome = new File(this.configuration.getJmxClientJarPath());
        try {
            URL[] urls = new URL[]{wlHome.toURI().toURL()};
            this.jmxLibraryClassLoader = new WebLogicJMXLibClassLoader(urls, Thread.currentThread().getContextClassLoader());
            Thread.currentThread().setContextClassLoader(this.jmxLibraryClassLoader);
        }
        catch (MalformedURLException urlEx) {
            throw new RuntimeException("The constructed path to weblogic.jar appears to be invalid. Verify that you have access to this jar and it's dependencies.", urlEx);
        }
    }

    private void createConnection() throws LifecycleException {
        if (this.connection != null) {
            return;
        }
        String protocol = this.configuration.getJmxProtocol();
        String hostname = this.configuration.getJmxHost();
        int portNum = this.configuration.getJmxPort();
        String domainRuntimeMBeanServerURL = "/jndi/weblogic.management.mbeanservers.domainruntime";
        try {
            JMXServiceURL serviceURL = new JMXServiceURL(protocol, hostname, portNum, domainRuntimeMBeanServerURL);
            HashMap<String, String> props = new HashMap<String, String>();
            props.put("java.naming.security.principal", this.configuration.getAdminUserName());
            props.put("java.naming.security.credentials", this.configuration.getAdminPassword());
            props.put("jmx.remote.protocol.provider.pkgs", "weblogic.management.remote");
            this.connector = JMXConnectorFactory.connect(serviceURL, props);
            this.connection = this.connector.getMBeanServerConnection();
        }
        catch (IOException ioEx) {
            throw new LifecycleException("Failed to obtain a connection to the MBean Server.", (Throwable)ioEx);
        }
    }

    private void closeConnection() throws LifecycleException {
        try {
            if (this.connector != null) {
                this.connector.close();
            }
        }
        catch (IOException ioEx) {
            throw new LifecycleException("Failed to close the connection to the MBean Server.", (Throwable)ioEx);
        }
    }

    private void setConfiguredTrustStore() {
        this.stashInitialState();
        this.setupState();
    }

    private void stashInitialState() {
        if (trustStorePath.get() == null && trustStorePassword.get() == null) {
            trustStorePath.set(System.getProperty("javax.net.ssl.trustStore"));
            trustStorePassword.set(System.getProperty("javax.net.ssl.trustStorePassword"));
        }
    }

    private void setupState() {
        if (this.configuration.isUseDemoTrust() || this.configuration.isUseCustomTrust() || this.configuration.isUseJavaStandardTrust()) {
            System.setProperty("javax.net.ssl.trustStore", this.configuration.getTrustStoreLocation());
            String trustStorePassword = this.configuration.getTrustStorePassword();
            if (trustStorePassword != null && !trustStorePassword.equals("")) {
                System.setProperty("javax.net.ssl.trustStorePassword", trustStorePassword);
            }
        }
    }

    private void revertToInitialState() {
        if (trustStorePath.get() != null && trustStorePassword.get() != null) {
            System.setProperty("javax.net.ssl.trustStore", trustStorePath.get());
            System.setProperty("javax.net.ssl.trustStorePassword", trustStorePassword.get());
            trustStorePath.set(null);
            trustStorePassword.set(null);
        }
    }
}

