/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.wls;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.arquillian.container.spi.client.container.LifecycleException;
import org.jboss.arquillian.container.wls.CommonManagedWebLogicConfiguration;
import org.jboss.arquillian.container.wls.rest.RESTUtils;

public class WebLogicServerControl {
    private static final Logger logger = Logger.getLogger(WebLogicServerControl.class.getName());
    private CommonManagedWebLogicConfiguration configuration;

    public WebLogicServerControl(CommonManagedWebLogicConfiguration configuration) {
        this.configuration = configuration;
    }

    public void startServer() throws LifecycleException {
        new StartupAdminServerCommand().execute();
    }

    public void stopServer() throws LifecycleException {
        new ShutdownAdminServerCommand().execute();
    }

    public boolean isServerRunning() {
        boolean isRunning = false;
        try {
            isRunning = RESTUtils.isServerRunning(this.configuration, logger);
        }
        catch (Exception e) {
            if (logger.getLevel().intValue() <= Level.FINE.intValue()) {
                e.printStackTrace();
            }
            logger.log(Level.ALL, e.getMessage());
        }
        return isRunning;
    }

    private class ConsoleConsumer
    implements Runnable {
        private Process process;
        private boolean writeOutput;

        private ConsoleConsumer(Process process, boolean writeOutput) {
            this.process = process;
            this.writeOutput = writeOutput;
        }

        public void run() {
            InputStream stream = this.process.getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
            String line = null;
            try {
                while ((line = reader.readLine()) != null) {
                    if (!this.writeOutput) continue;
                    System.out.println(line);
                }
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }

    private class ShutdownAdminServerCommand
    extends ShellCommand {
        private ShutdownAdminServerCommand() {
        }

        public void execute() throws LifecycleException {
            Process process = null;
            try {
                long start;
                List<String> command = this.getCommand();
                ProcessBuilder builder = new ProcessBuilder(command);
                builder.directory(new File(WebLogicServerControl.this.configuration.getDomainDirectory()));
                builder.environment().put("MW_HOME", WebLogicServerControl.this.configuration.getMiddlewareHome());
                builder.redirectErrorStream(true);
                process = builder.start();
                Thread consoleConsumer = new Thread(new ConsoleConsumer(process, WebLogicServerControl.this.configuration.isOutputToConsole()));
                consoleConsumer.setDaemon(true);
                consoleConsumer.start();
                int timeout = WebLogicServerControl.this.configuration.getTimeout();
                long now = start = System.currentTimeMillis() / 1000L;
                boolean serverAvailable = true;
                while (now - start < (long)timeout && serverAvailable && (serverAvailable = WebLogicServerControl.this.isServerRunning())) {
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException interruptedEx) {
                        logger.log(Level.INFO, "Container shutdown interrupted");
                        throw interruptedEx;
                    }
                    now = System.currentTimeMillis() / 1000L;
                }
                if (serverAvailable) {
                    process.destroy();
                    throw new TimeoutException(String.format("The shutdown script could not complete in %d seconds.", WebLogicServerControl.this.configuration.getTimeout()));
                }
                logger.log(Level.INFO, "Stopped WebLogic Server.");
                return;
            }
            catch (Exception ex) {
                throw new LifecycleException("Container shutdown failed.", (Throwable)ex);
            }
        }

        protected String getScript() {
            return WebLogicServerControl.this.configuration.getStopServerScript();
        }
    }

    private class StartupAdminServerCommand
    extends ShellCommand {
        private StartupAdminServerCommand() {
        }

        public void execute() throws LifecycleException {
            Process process = null;
            List<String> command = this.getCommand();
            ProcessBuilder builder = new ProcessBuilder(command);
            try {
                long start;
                builder.directory(new File(WebLogicServerControl.this.configuration.getDomainDirectory()));
                builder.environment().put("MW_HOME", WebLogicServerControl.this.configuration.getMiddlewareHome());
                String jvmOptions = WebLogicServerControl.this.configuration.getJvmOptions();
                if (jvmOptions != null && jvmOptions.length() > 0) {
                    builder.environment().put("JAVA_OPTIONS", WebLogicServerControl.this.configuration.getJvmOptions());
                }
                builder.redirectErrorStream(true);
                process = this.createProcess(builder);
                int timeout = WebLogicServerControl.this.configuration.getTimeout();
                long now = start = System.currentTimeMillis() / 1000L;
                boolean serverAvailable = false;
                while (now - start < (long)timeout && !serverAvailable) {
                    serverAvailable = WebLogicServerControl.this.isServerRunning();
                    if (serverAvailable) continue;
                    if (this.processHasDied(process)) {
                        process.destroy();
                        process = this.createProcess(builder);
                    }
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException interruptedEx) {
                        logger.log(Level.INFO, "Container startup interrupted");
                        throw interruptedEx;
                    }
                    now = System.currentTimeMillis() / 1000L;
                }
                if (!serverAvailable) {
                    process.destroy();
                    throw new TimeoutException(String.format("The startup script could not complete in %d seconds.", WebLogicServerControl.this.configuration.getTimeout()));
                }
                Thread.sleep(1000L);
                logger.log(Level.INFO, "Started WebLogic Server.");
                return;
            }
            catch (Exception ex) {
                throw new LifecycleException("Container startup failed.", (Throwable)ex);
            }
        }

        private Process createProcess(ProcessBuilder builder) throws IOException {
            Process process = builder.start();
            Thread consoleConsumer = new Thread(new ConsoleConsumer(process, WebLogicServerControl.this.configuration.isOutputToConsole()));
            consoleConsumer.setDaemon(true);
            consoleConsumer.start();
            return process;
        }

        protected String getScript() {
            return WebLogicServerControl.this.configuration.getStartServerScript();
        }

        private boolean processHasDied(Process process) {
            try {
                process.exitValue();
                return true;
            }
            catch (IllegalThreadStateException illegalEx) {
                return false;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class ShellCommand {
        private ShellCommand() {
        }

        protected abstract void execute() throws LifecycleException;

        protected abstract String getScript();

        protected final List<String> getCommand() {
            ArrayList<String> command = new ArrayList<String>();
            command.addAll(this.getShellInterpreter());
            command.add(this.getScript());
            return command;
        }

        private List<String> getShellInterpreter() {
            ArrayList<String> shellCommands = new ArrayList<String>();
            String os = System.getProperty("os.name").toLowerCase();
            if (os.startsWith("windows")) {
                shellCommands.add("cmd.exe");
                shellCommands.add("/c");
            } else {
                String shell = System.getenv("SHELL");
                if (shell == null) {
                    shellCommands.add("sh");
                    shellCommands.add("-c");
                } else {
                    shellCommands.add(shell);
                    shellCommands.add("-c");
                }
            }
            return shellCommands;
        }
    }
}

