/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.wls.embedded_12_1;

import java.io.File;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.embeddable.EJBContainer;
import javax.naming.Context;
import org.jboss.arquillian.container.spi.client.container.DeployableContainer;
import org.jboss.arquillian.container.spi.client.container.DeploymentException;
import org.jboss.arquillian.container.spi.client.container.LifecycleException;
import org.jboss.arquillian.container.spi.client.protocol.ProtocolDescription;
import org.jboss.arquillian.container.spi.client.protocol.metadata.ProtocolMetaData;
import org.jboss.arquillian.container.spi.context.annotation.ContainerScoped;
import org.jboss.arquillian.container.wls.ShrinkWrapUtil;
import org.jboss.arquillian.container.wls.embedded_12_1.WebLogicEmbeddedConfiguration;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.descriptor.api.Descriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebLogicContainer
implements DeployableContainer<WebLogicEmbeddedConfiguration> {
    private static final Logger logger = Logger.getLogger(WebLogicContainer.class.getName());
    private EJBContainer ejbContainer;
    private WebLogicEmbeddedConfiguration configuration;
    @Inject
    @ContainerScoped
    private InstanceProducer<Context> ctx;

    public Class<WebLogicEmbeddedConfiguration> getConfigurationClass() {
        return WebLogicEmbeddedConfiguration.class;
    }

    public void setup(WebLogicEmbeddedConfiguration configuration) {
        this.configuration = configuration;
    }

    public void start() throws LifecycleException {
        logger.log(Level.FINE, "Starting container - initialization system properties.");
        if (this.configuration.isOutputToConsole()) {
            System.setProperty("weblogic.server.embed.debug", "true");
            System.setProperty("weblogic.StdoutDebugEnabled", "true");
        }
    }

    public void stop() throws LifecycleException {
        logger.log(Level.FINE, "Starting container - nothing to do here.");
    }

    public ProtocolDescription getDefaultProtocol() {
        return new ProtocolDescription("Local");
    }

    public ProtocolMetaData deploy(Archive<?> archive) throws DeploymentException {
        if (this.ejbContainer != null) {
            throw new DeploymentException("The embedded container does not support multiple deployments in a single test.");
        }
        logger.log(Level.FINE, "Deploying archive {0}", archive);
        File deployment = ShrinkWrapUtil.toFile(archive);
        String deploymentName = this.getDeploymentName(archive);
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("javax.ejb.embeddable.appName", deploymentName);
        props.put("javax.ejb.embeddable.modules", deployment);
        this.ejbContainer = EJBContainer.createEJBContainer(props);
        this.ctx.set((Object)this.ejbContainer.getContext());
        return new ProtocolMetaData();
    }

    public void undeploy(Archive<?> archive) throws DeploymentException {
        logger.log(Level.FINE, "Undeploying archive {0}", archive);
        if (this.ejbContainer != null) {
            this.ejbContainer.close();
            this.ejbContainer = null;
        }
    }

    public void deploy(Descriptor descriptor) throws DeploymentException {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public void undeploy(Descriptor descriptor) throws DeploymentException {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    private String getDeploymentName(Archive<?> archive) {
        String archiveFilename = archive.getName();
        int indexOfDot = archiveFilename.indexOf(".");
        if (indexOfDot != -1) {
            return archiveFilename.substring(0, indexOfDot);
        }
        return archiveFilename;
    }
}

