/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.se.api;

import org.jboss.arquillian.container.se.api.ClassPath;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.ArchivePaths;
import org.jboss.shrinkwrap.api.GenericArchive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.ClassAsset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;

public final class ClassPathDirectory {
    private static final ArchivePath MARKER_FILE_ARCHIVE_PATH = ArchivePaths.create((String)"META-INF/arquillian.se.container.ClassPathDirectory");

    private ClassPathDirectory() {
    }

    static Builder builder(String name, ClassPath.Builder classPathBuilder) {
        return new Builder(name, classPathBuilder);
    }

    public static boolean isRepresentedBy(Archive<?> archive) {
        return archive.contains(MARKER_FILE_ARCHIVE_PATH);
    }

    public static boolean isMarkerFileArchivePath(ArchivePath path) {
        return path.equals(MARKER_FILE_ARCHIVE_PATH);
    }

    public static final class Builder {
        private final ClassPath.Builder classPathBuilder;
        private final GenericArchive archive;

        private Builder(String name, ClassPath.Builder classPathBuilder) {
            this.classPathBuilder = classPathBuilder;
            this.archive = (GenericArchive)((GenericArchive)ShrinkWrap.create(GenericArchive.class, (String)name)).add((Asset)EmptyAsset.INSTANCE, MARKER_FILE_ARCHIVE_PATH);
        }

        public Builder addClass(Class<?> clazz) {
            this.archive.add((Asset)new ClassAsset(clazz), "/" + clazz.getName());
            return this;
        }

        public Builder addResource(Asset resource, String target) {
            this.archive.add(resource, target);
            return this;
        }

        public ClassPath.Builder buildAndUp() {
            return this.classPathBuilder.addArchive((Archive<?>)this.archive);
        }
    }
}

