/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.se.managed.util;

import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;

public class Await {
    private static final long DEFAULT_SLEEP_INTERVAL = 100L;
    private final long delay;
    private final long sleepInterval;
    private final Callable<Boolean> condition;

    public Await(long delay, Callable<Boolean> condition) {
        this(100L, delay, condition);
    }

    public Await(long sleepInterval, long delay, Callable<Boolean> condition) {
        this.delay = TimeUnit.SECONDS.toMillis(delay);
        this.sleepInterval = sleepInterval;
        this.condition = condition;
    }

    public boolean start() {
        long start = System.currentTimeMillis();
        do {
            try {
                if (this.condition.call().booleanValue()) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                Thread.sleep(this.sleepInterval);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return false;
            }
        } while (!this.isTimeoutExpired(start));
        return false;
    }

    private boolean isTimeoutExpired(long start) {
        return System.currentTimeMillis() - start >= this.delay;
    }
}

