/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.se.managed.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import org.jboss.arquillian.container.se.api.ClassPathDirectory;
import org.jboss.arquillian.container.spi.client.container.DeploymentException;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.Node;
import org.jboss.shrinkwrap.api.asset.ClassAsset;

public class FileDeploymentUtils {
    private static final char DELIMITER_RESOURCE_PATH = '/';
    private static final char DELIMITER_CLASS_NAME_PATH = '.';
    private static final String EXTENSION_CLASS = ".class";

    public static void materializeClass(File entryDirectory, ClassAsset classAsset) throws DeploymentException, IOException {
        File classDirectory;
        if (classAsset.getSource().getPackage() != null) {
            classDirectory = new File(entryDirectory, classAsset.getSource().getPackage().getName().replace('.', File.separatorChar));
            if (!classDirectory.mkdirs()) {
                throw new DeploymentException("Could not create class package directory: " + classDirectory);
            }
        } else {
            classDirectory = entryDirectory;
        }
        File classFile = new File(classDirectory, classAsset.getSource().getSimpleName().concat(EXTENSION_CLASS));
        classFile.createNewFile();
        try (InputStream in = classAsset.openStream();
             FileOutputStream out = new FileOutputStream(classFile);){
            FileDeploymentUtils.copy(in, out);
        }
    }

    public static void materializeSubdirectories(File entryDirectory, Node node) throws DeploymentException, IOException {
        for (Node child : node.getChildren()) {
            if (child.getAsset() == null) {
                FileDeploymentUtils.materializeSubdirectories(entryDirectory, child);
                continue;
            }
            if (ClassPathDirectory.isMarkerFileArchivePath((ArchivePath)child.getPath())) continue;
            File resourceFile = new File(entryDirectory, child.getPath().get().replace('/', File.separatorChar));
            File resoureDirectory = resourceFile.getParentFile();
            if (!resoureDirectory.exists() && !resoureDirectory.mkdirs()) {
                throw new DeploymentException("Could not create class path directory: " + entryDirectory);
            }
            resourceFile.createNewFile();
            try (InputStream in = child.getAsset().openStream();
                 FileOutputStream out = new FileOutputStream(resourceFile);){
                FileDeploymentUtils.copy(in, out);
            }
            child.getPath().get();
        }
    }

    public static void copy(InputStream in, OutputStream out) throws IOException {
        byte[] buffer = new byte[8192];
        int n = 0;
        while (-1 != (n = in.read(buffer))) {
            out.write(buffer, 0, n);
        }
        out.flush();
    }

    public static void deleteRecursively(Path directory) throws IOException {
        Files.walkFileTree(directory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public static void deleteContent(Path directory) throws IOException {
        Files.walkFileTree(directory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }
        });
    }
}

