/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.drone.appium.extension.webdriver;

import io.appium.java_client.AppiumDriver;
import io.appium.java_client.android.AndroidDriver;
import io.appium.java_client.ios.IOSDriver;
import io.appium.java_client.windows.WindowsDriver;
import java.net.URL;
import org.jboss.arquillian.config.descriptor.api.ArquillianDescriptor;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.drone.spi.Configurator;
import org.jboss.arquillian.drone.spi.Destructor;
import org.jboss.arquillian.drone.spi.DronePoint;
import org.jboss.arquillian.drone.spi.Instantiator;
import org.jboss.arquillian.drone.webdriver.configuration.WebDriverConfiguration;
import org.jboss.arquillian.drone.webdriver.factory.CapabilitiesOptionsMapper;
import org.jboss.arquillian.drone.webdriver.factory.ChromeDriverFactory;
import org.jboss.arquillian.drone.webdriver.spi.BrowserCapabilities;
import org.jboss.arquillian.drone.webdriver.spi.BrowserCapabilitiesRegistry;
import org.jboss.arquillian.drone.webdriver.utils.Validate;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.remote.DesiredCapabilities;

public class AppiumDriverFactory
implements Configurator<AppiumDriver, WebDriverConfiguration>,
Instantiator<AppiumDriver, WebDriverConfiguration>,
Destructor<AppiumDriver> {
    @Inject
    private Instance<BrowserCapabilitiesRegistry> registryInstance;

    public void destroyInstance(AppiumDriver instance) {
        instance.quit();
    }

    public int getPrecedence() {
        return 0;
    }

    public AppiumDriver createInstance(WebDriverConfiguration configuration) {
        Capabilities capabilities = this.getCapabilities(configuration);
        String platform = (String)capabilities.getCapability("platformName");
        if (Validate.empty((String)platform)) {
            throw new IllegalArgumentException("You have to specify platformName");
        }
        platform = platform.toLowerCase();
        Class driverClass = "Android".toLowerCase().equals(platform) ? AndroidDriver.class : ("iOS".toLowerCase().equals(platform) ? IOSDriver.class : ("Windows".toLowerCase().equals(platform) ? WindowsDriver.class : AppiumDriver.class));
        URL remoteAddress = configuration.getRemoteAddress();
        try {
            if (remoteAddress == null) {
                return (AppiumDriver)driverClass.getConstructor(Capabilities.class).newInstance(capabilities);
            }
            return (AppiumDriver)driverClass.getConstructor(URL.class, Capabilities.class).newInstance(remoteAddress, capabilities);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Capabilities getCapabilities(WebDriverConfiguration configuration) {
        DesiredCapabilities capabilities = new DesiredCapabilities(configuration.getCapabilities());
        String browser = (String)capabilities.getCapability("browserName");
        if (browser != null) {
            browser = browser.toLowerCase();
        }
        if ("Chrome".toLowerCase().equals(browser)) {
            ChromeOptions chromeOptions = new ChromeOptions();
            CapabilitiesOptionsMapper.mapCapabilities((Object)chromeOptions, (DesiredCapabilities)capabilities, (String)ChromeDriverFactory.BROWSER_CAPABILITIES);
            capabilities.setCapability("chromeOptions", (Object)chromeOptions);
        }
        return capabilities;
    }

    public WebDriverConfiguration createConfiguration(ArquillianDescriptor descriptor, DronePoint<AppiumDriver> dronePoint) {
        BrowserCapabilities browser = ((BrowserCapabilitiesRegistry)this.registryInstance.get()).getEntryFor("appium");
        return new WebDriverConfiguration(browser).configure(descriptor, dronePoint.getQualifier());
    }
}

