/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.drone.browserstack.extension.webdriver;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Logger;
import org.arquillian.drone.browserstack.extension.local.BrowserStackLocalRunner;
import org.arquillian.drone.browserstack.extension.utils.Utils;
import org.arquillian.drone.browserstack.extension.webdriver.BrowserStackDriver;
import org.jboss.arquillian.config.descriptor.api.ArquillianDescriptor;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.drone.spi.Configurator;
import org.jboss.arquillian.drone.spi.Destructor;
import org.jboss.arquillian.drone.spi.DronePoint;
import org.jboss.arquillian.drone.spi.Instantiator;
import org.jboss.arquillian.drone.webdriver.configuration.WebDriverConfiguration;
import org.jboss.arquillian.drone.webdriver.spi.BrowserCapabilities;
import org.jboss.arquillian.drone.webdriver.spi.BrowserCapabilitiesRegistry;
import org.openqa.selenium.Capabilities;

public class BrowserStackDriverFactory
implements Configurator<BrowserStackDriver, WebDriverConfiguration>,
Instantiator<BrowserStackDriver, WebDriverConfiguration>,
Destructor<BrowserStackDriver> {
    private static final Logger log = Logger.getLogger(BrowserStackDriverFactory.class.getName());
    @Inject
    private Instance<BrowserCapabilitiesRegistry> registryInstance;

    public WebDriverConfiguration createConfiguration(ArquillianDescriptor arquillianDescriptor, DronePoint<BrowserStackDriver> dronePoint) {
        BrowserCapabilitiesRegistry registry = (BrowserCapabilitiesRegistry)this.registryInstance.get();
        BrowserCapabilities browser = registry.getEntryFor("browserstack");
        WebDriverConfiguration configuration = new WebDriverConfiguration(browser).configure(arquillianDescriptor, dronePoint.getQualifier());
        return configuration;
    }

    public void destroyInstance(BrowserStackDriver browserStackDriver) {
        browserStackDriver.quit();
    }

    public BrowserStackDriver createInstance(WebDriverConfiguration configuration) {
        Capabilities capabilities = configuration.getCapabilities();
        String url = (String)capabilities.getCapability("url");
        String accessKey = null;
        if (Utils.isNullOrEmpty(url)) {
            String username = (String)capabilities.getCapability("username");
            accessKey = (String)capabilities.getCapability("access.key");
            if (Utils.isNullOrEmpty(accessKey)) {
                accessKey = (String)capabilities.getCapability("automate.key");
            }
            if (Utils.isNullOrEmpty(username) || Utils.isNullOrEmpty(accessKey)) {
                throw new IllegalArgumentException("You have to specify either an username and an access.key or the whole url in your arquillian descriptor");
            }
            url = "http://" + username + ":" + accessKey + "@hub.browserstack.com/wd/hub";
        }
        try {
            URL browserStackUrl = new URL(url);
            boolean isSetBrowserStackLocal = capabilities.is("browserstack.local");
            boolean isSetBrowserStackLocalManaged = capabilities.is("browserstack.local.managed");
            if (isSetBrowserStackLocal && isSetBrowserStackLocalManaged) {
                if (Utils.isNullOrEmpty(accessKey)) {
                    accessKey = url.substring(url.lastIndexOf(":") + 1, url.indexOf("@"));
                }
                String additionalArgs = (String)capabilities.getCapability("browserstack.local.args");
                String localBinary = (String)capabilities.getCapability("browserstack.local.binary");
                BrowserStackLocalRunner.getBrowserStackLocalInstance().runBrowserStackLocal(accessKey, additionalArgs, localBinary);
            }
            return new BrowserStackDriver(browserStackUrl, capabilities, isSetBrowserStackLocal, isSetBrowserStackLocalManaged);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("The BrowserStack url: " + url + " has been detected as a malformed URL. ", e);
        }
    }

    public int getPrecedence() {
        return 0;
    }
}

