/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.drone.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.core.spi.Validate;
import org.jboss.arquillian.drone.api.annotation.Drone;
import org.jboss.arquillian.drone.impl.DroneContext;
import org.jboss.arquillian.drone.impl.DroneRegistry;
import org.jboss.arquillian.drone.impl.MethodContext;
import org.jboss.arquillian.drone.impl.SecurityActions;
import org.jboss.arquillian.drone.spi.Destructor;
import org.jboss.arquillian.test.spi.event.suite.After;
import org.jboss.arquillian.test.spi.event.suite.AfterClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DroneDestructor {
    private static final Logger log = Logger.getLogger(DroneDestructor.class.getName());
    @Inject
    private Instance<DroneRegistry> registry;
    @Inject
    private Instance<DroneContext> droneContext;
    @Inject
    private Instance<MethodContext> methodContext;

    public void destroyClassScopedDrone(@Observes AfterClass event) {
        Class clazz = event.getTestClass().getJavaClass();
        for (Field f : SecurityActions.getFieldsWithAnnotation(clazz, Drone.class)) {
            Class<?> typeClass = f.getType();
            Class<? extends Annotation> qualifier = SecurityActions.getQualifier(f);
            Destructor destructor = this.getDestructorFor(typeClass);
            Object instance = ((DroneContext)this.droneContext.get()).get(typeClass, qualifier);
            if (instance != null) {
                destructor.destroyInstance(instance);
            }
            ((DroneContext)this.droneContext.get()).remove(typeClass, qualifier);
        }
    }

    public void destroyMethodScopedDrone(@Observes After event) {
        Method method = event.getTestMethod();
        Class<?>[] parameterTypes = method.getParameterTypes();
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        for (int i = 0; i < parameterTypes.length; ++i) {
            if (!SecurityActions.isAnnotationPresent(parameterAnnotations[i], Drone.class)) continue;
            Validate.notNull((Object)this.methodContext.get(), (String)"Drone registry should not be null");
            Class<? extends Annotation> qualifier = SecurityActions.getQualifier(parameterAnnotations[i]);
            Destructor destructor = this.getDestructorFor(parameterTypes[i]);
            DroneContext context = ((MethodContext)this.methodContext.get()).get(method);
            Validate.notNull((Object)context, (String)"Method context should not be null");
            Object instance = context.get(parameterTypes[i], qualifier);
            if (instance != null) {
                destructor.destroyInstance(instance);
            }
            context.remove(parameterTypes[i], qualifier);
        }
    }

    private Destructor getDestructorFor(Class<?> typeClass) {
        Destructor<?> destructor = ((DroneRegistry)this.registry.get()).getDestructorFor(typeClass);
        if (destructor == null) {
            throw new IllegalArgumentException("No destructor was found for object of type " + typeClass.getName());
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Using destructor defined in class: " + destructor.getClass().getName() + ", with precedence " + destructor.getPrecedence());
        }
        return destructor;
    }
}

