/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.drone.impl;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.core.spi.ServiceLoader;
import org.jboss.arquillian.drone.impl.DroneRegistryImpl;
import org.jboss.arquillian.drone.spi.Configurator;
import org.jboss.arquillian.drone.spi.Destructor;
import org.jboss.arquillian.drone.spi.DroneRegistry;
import org.jboss.arquillian.drone.spi.Instantiator;
import org.jboss.arquillian.drone.spi.Sortable;
import org.jboss.arquillian.test.spi.annotation.SuiteScoped;
import org.jboss.arquillian.test.spi.event.suite.BeforeSuite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DroneRegistrar {
    @Inject
    @SuiteScoped
    private InstanceProducer<DroneRegistry> droneRegistry;
    @Inject
    private Instance<ServiceLoader> serviceLoader;
    private static final Comparator<Sortable> SORTABLE_COMPARATOR = new Comparator<Sortable>(){

        @Override
        public int compare(Sortable o1, Sortable o2) {
            return new Integer(o1.getPrecedence()).compareTo(new Integer(o2.getPrecedence()));
        }
    };

    public void register(@Observes BeforeSuite event) {
        this.droneRegistry.set((Object)new DroneRegistryImpl());
        this.registerConfigurators();
        this.registerInstantiators();
        this.registerDestructors();
    }

    private void registerConfigurators() {
        ArrayList list = new ArrayList(((ServiceLoader)this.serviceLoader.get()).all(Configurator.class));
        Collections.sort(list, SORTABLE_COMPARATOR);
        for (Configurator configurator : list) {
            Class<?> type = DroneRegistrar.getFirstGenericParameterType(configurator.getClass(), Configurator.class);
            if (type == null) continue;
            ((DroneRegistry)this.droneRegistry.get()).registerConfiguratorFor(type, configurator);
        }
    }

    public void registerInstantiators() {
        ArrayList list = new ArrayList(((ServiceLoader)this.serviceLoader.get()).all(Instantiator.class));
        Collections.sort(list, SORTABLE_COMPARATOR);
        for (Instantiator instantiator : list) {
            Class<?> type = DroneRegistrar.getFirstGenericParameterType(instantiator.getClass(), Instantiator.class);
            if (type == null) continue;
            ((DroneRegistry)this.droneRegistry.get()).registerInstantiatorFor(type, instantiator);
        }
    }

    public void registerDestructors() {
        ArrayList list = new ArrayList(((ServiceLoader)this.serviceLoader.get()).all(Destructor.class));
        Collections.sort(list, SORTABLE_COMPARATOR);
        for (Destructor destructor : list) {
            Class<?> type = DroneRegistrar.getFirstGenericParameterType(destructor.getClass(), Destructor.class);
            if (type == null) continue;
            ((DroneRegistry)this.droneRegistry.get()).registerDestructorFor(type, destructor);
        }
    }

    private static Class<?> getFirstGenericParameterType(Class<?> clazz, Class<?> rawType) {
        for (Type interfaceType : clazz.getGenericInterfaces()) {
            ParameterizedType ptype;
            if (!(interfaceType instanceof ParameterizedType) || !rawType.isAssignableFrom((Class)(ptype = (ParameterizedType)interfaceType).getRawType())) continue;
            return (Class)ptype.getActualTypeArguments()[0];
        }
        return null;
    }
}

