/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.drone.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.arquillian.config.descriptor.api.ArquillianDescriptor;
import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.drone.api.annotation.Default;
import org.jboss.arquillian.drone.api.annotation.Drone;
import org.jboss.arquillian.drone.configuration.ConfigurationMapper;
import org.jboss.arquillian.drone.impl.DroneContextImpl;
import org.jboss.arquillian.drone.impl.InstanceOrCallableInstanceImpl;
import org.jboss.arquillian.drone.impl.SecurityActions;
import org.jboss.arquillian.drone.impl.Validate;
import org.jboss.arquillian.drone.spi.Configurator;
import org.jboss.arquillian.drone.spi.Destructor;
import org.jboss.arquillian.drone.spi.DroneConfiguration;
import org.jboss.arquillian.drone.spi.DroneContext;
import org.jboss.arquillian.drone.spi.DroneRegistry;
import org.jboss.arquillian.drone.spi.InstanceOrCallableInstance;
import org.jboss.arquillian.drone.spi.Instantiator;
import org.jboss.arquillian.drone.spi.event.AfterDroneConfigured;
import org.jboss.arquillian.drone.spi.event.BeforeDroneConfigured;
import org.jboss.arquillian.drone.spi.event.DroneConfigurationEvent;
import org.jboss.arquillian.test.spi.annotation.ClassScoped;
import org.jboss.arquillian.test.spi.event.suite.Before;
import org.jboss.arquillian.test.spi.event.suite.BeforeClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DroneConfigurator {
    private static Logger log = Logger.getLogger(DroneConfigurator.class.getName());
    @Inject
    @ClassScoped
    private InstanceProducer<DroneContext> droneContext;
    @Inject
    private Instance<ArquillianDescriptor> arquillianDescriptor;
    @Inject
    private Event<DroneConfigurationEvent> droneConfigurationEvent;

    public void prepareGlobalDroneConfiguration(@Observes(precedence=10) BeforeClass event, DroneRegistry registry) {
        this.droneContext.set((Object)new DroneContextImpl());
        GlobalDroneFactory configurator = new GlobalDroneFactory();
        this.droneConfigurationEvent.fire((Object)new BeforeDroneConfigured((Configurator)configurator, GlobalDrone.class, Default.class));
        DroneConfiguration configuration = configurator.createConfiguration((ArquillianDescriptor)this.arquillianDescriptor.get(), Default.class);
        InstanceOrCallableInstanceImpl droneConfiguration = new InstanceOrCallableInstanceImpl(configuration);
        ((DroneContext)this.droneContext.get()).add(configuration.getClass(), Default.class, (InstanceOrCallableInstance)droneConfiguration);
        this.droneConfigurationEvent.fire((Object)new AfterDroneConfigured((InstanceOrCallableInstance)droneConfiguration, GlobalDrone.class, Default.class));
    }

    public void prepareDroneConfiguration(@Observes BeforeClass event, DroneRegistry registry) {
        List<Field> fields = SecurityActions.getFieldsWithAnnotation(event.getTestClass().getJavaClass(), Drone.class);
        for (Field f : fields) {
            Class<?> droneType = f.getType();
            Class<? extends Annotation> qualifier = SecurityActions.getQualifier(f);
            log.log(Level.FINE, "Configuring Drone for field {0}, argument {1}", new Object[]{f.getName()});
            this.configureDrone(registry, droneType, qualifier);
        }
    }

    public void configureDrone(@Observes Before event, DroneRegistry registry) {
        Method method = event.getTestMethod();
        Map<Integer, Annotation[]> droneParameters = SecurityActions.getParametersWithAnnotation(method, Drone.class);
        Class<?>[] parameters = method.getParameterTypes();
        for (int i = 0; i < parameters.length; ++i) {
            if (!droneParameters.containsKey(i)) continue;
            Class<?> droneType = parameters[i];
            Class<? extends Annotation> qualifier = SecurityActions.getQualifier(droneParameters.get(i));
            log.log(Level.FINE, "Configuring Drone for method {0}, argument {1}", new Object[]{method.getName(), parameters[i].getName()});
            this.configureDrone(registry, droneType, qualifier);
        }
    }

    private void configureDrone(DroneRegistry registry, Class<?> droneType, Class<? extends Annotation> qualifier) {
        Validate.stateNotNull(this.arquillianDescriptor.get(), "ArquillianDescriptor should not be null");
        Validate.stateNotNull(this.droneContext.get(), "DroneContext should be available while working with method scoped instances");
        Configurator configurator = (Configurator)registry.getEntryFor(droneType, Configurator.class);
        this.droneConfigurationEvent.fire((Object)new BeforeDroneConfigured(configurator, droneType, qualifier));
        DroneConfiguration configuration = configurator.createConfiguration((ArquillianDescriptor)this.arquillianDescriptor.get(), qualifier);
        InstanceOrCallableInstanceImpl droneConfiguration = new InstanceOrCallableInstanceImpl(configuration);
        ((DroneContext)this.droneContext.get()).add(configuration.getClass(), qualifier, (InstanceOrCallableInstance)droneConfiguration);
        this.droneConfigurationEvent.fire((Object)new AfterDroneConfigured((InstanceOrCallableInstance)droneConfiguration, droneType, qualifier));
    }

    public static class GlobalDrone {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class GlobalDroneFactory
    implements Configurator<GlobalDrone, GlobalDroneConfiguration>,
    Instantiator<GlobalDrone, GlobalDroneConfiguration>,
    Destructor<GlobalDrone> {
        public GlobalDroneConfiguration createConfiguration(ArquillianDescriptor descriptor, Class<? extends Annotation> qualifier) {
            return new GlobalDroneConfiguration().configure(descriptor, (Class)qualifier);
        }

        public GlobalDrone createInstance(GlobalDroneConfiguration configuration) {
            return new GlobalDrone();
        }

        public void destroyInstance(GlobalDrone instance) {
        }

        public int getPrecedence() {
            return 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class GlobalDroneConfiguration
    implements DroneConfiguration<GlobalDroneConfiguration> {
        public static final String CONFIGURATION_NAME = "drone";
        public static final int DEFAULT_INSTANTIATION_TIMEOUT = 60;
        private int instantiationTimeoutInSeconds = 60;

        public String getConfigurationName() {
            return CONFIGURATION_NAME;
        }

        public GlobalDroneConfiguration configure(ArquillianDescriptor descriptor, Class<? extends Annotation> qualifier) {
            ConfigurationMapper.fromArquillianDescriptor((ArquillianDescriptor)descriptor, (DroneConfiguration)this, Default.class);
            ConfigurationMapper.fromSystemConfiguration((DroneConfiguration)this, Default.class);
            if (Boolean.parseBoolean(SecurityActions.getProperty("arquillian.debug"))) {
                this.instantiationTimeoutInSeconds = 0;
            }
            return this;
        }

        public int getInstantiationTimeoutInSeconds() {
            return this.instantiationTimeoutInSeconds;
        }

        public void setInstantiationTimeoutInSeconds(int instantiationTimeoutInSeconds) {
            this.instantiationTimeoutInSeconds = instantiationTimeoutInSeconds;
        }
    }
}

