/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.drone.impl;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.core.spi.ServiceLoader;
import org.jboss.arquillian.drone.impl.PrecedenceComparator;
import org.jboss.arquillian.drone.spi.DroneContext;
import org.jboss.arquillian.drone.spi.DroneInstanceEnhancer;
import org.jboss.arquillian.drone.spi.Enhancer;
import org.jboss.arquillian.drone.spi.InstanceOrCallableInstance;
import org.jboss.arquillian.drone.spi.Sortable;
import org.jboss.arquillian.drone.spi.event.AfterDroneDeenhanced;
import org.jboss.arquillian.drone.spi.event.AfterDroneEnhanced;
import org.jboss.arquillian.drone.spi.event.AfterDroneInstantiated;
import org.jboss.arquillian.drone.spi.event.BeforeDroneDeenhanced;
import org.jboss.arquillian.drone.spi.event.BeforeDroneDestroyed;
import org.jboss.arquillian.drone.spi.event.BeforeDroneEnhanced;
import org.jboss.arquillian.drone.spi.event.DroneEnhancementEvent;

public class DroneEnhancer {
    private static final Logger log = Logger.getLogger(DroneEnhancer.class.getName());
    @Inject
    private Instance<ServiceLoader> serviceLoader;
    @Inject
    private Event<DroneEnhancementEvent> droneEnhancementEvent;

    public void enhanceDrone(@Observes AfterDroneInstantiated droneInstance, DroneContext context) {
        ArrayList enhancers = new ArrayList(((ServiceLoader)this.serviceLoader.get()).all(DroneInstanceEnhancer.class));
        enhancers.addAll(((ServiceLoader)this.serviceLoader.get()).all(Enhancer.class));
        Collections.sort(enhancers, PrecedenceComparator.getInstance());
        InstanceOrCallableInstance browser = droneInstance.getInstance();
        Class type = droneInstance.getDroneType();
        Class qualifier = droneInstance.getQualifier();
        for (Sortable candidate : enhancers) {
            Object newBrowser;
            DroneInstanceEnhancer enhancer;
            if (candidate instanceof DroneInstanceEnhancer) {
                enhancer = (DroneInstanceEnhancer)candidate;
                if (!enhancer.canEnhance(browser, type, qualifier)) continue;
                log.log(Level.FINE, "Enhancing {0} @{1} using enhancer {2} with precedence {3}", new Object[]{type.getSimpleName(), qualifier.getSimpleName(), enhancer.getClass().getName(), enhancer.getPrecedence()});
                this.droneEnhancementEvent.fire((Object)new BeforeDroneEnhanced(enhancer, browser, type, qualifier));
                newBrowser = enhancer.enhance(browser.asInstance(type), qualifier);
                browser.set(newBrowser);
                this.droneEnhancementEvent.fire((Object)new AfterDroneEnhanced(browser, type, qualifier));
                continue;
            }
            if (!(candidate instanceof Enhancer) || !(enhancer = (Enhancer)candidate).canEnhance(type, qualifier)) continue;
            log.log(Level.WARNING, "Deprecated Enhancer type, please implement DroneInstanceEnhancer instead. Enhancing {0} @{1} using enhancer {2} with precedence {3}", new Object[]{type.getSimpleName(), qualifier.getSimpleName(), enhancer.getClass().getName(), enhancer.getPrecedence()});
            this.droneEnhancementEvent.fire((Object)new BeforeDroneEnhanced(new DeprecatedEnhancerWrap(enhancer), browser, type, qualifier));
            newBrowser = enhancer.enhance(browser.asInstance(type), qualifier);
            browser.set(newBrowser);
            this.droneEnhancementEvent.fire((Object)new AfterDroneEnhanced(browser, type, qualifier));
        }
    }

    public void deenhanceDrone(@Observes BeforeDroneDestroyed droneInstance, DroneContext context) {
        ArrayList enhancers = new ArrayList(((ServiceLoader)this.serviceLoader.get()).all(DroneInstanceEnhancer.class));
        enhancers.addAll(((ServiceLoader)this.serviceLoader.get()).all(Enhancer.class));
        Collections.sort(enhancers, PrecedenceComparator.getReversedOrder());
        InstanceOrCallableInstance browser = droneInstance.getInstance();
        Class type = droneInstance.getDroneType();
        Class qualifier = droneInstance.getQualifier();
        for (Sortable candidate : enhancers) {
            Object newBrowser;
            DroneInstanceEnhancer enhancer;
            if (candidate instanceof DroneInstanceEnhancer) {
                enhancer = (DroneInstanceEnhancer)candidate;
                if (!enhancer.canEnhance(browser, type, qualifier)) continue;
                log.log(Level.FINE, "Deenhancing {0} @{1} using enhancer {2} with precedence {3}", new Object[]{type.getSimpleName(), qualifier.getSimpleName(), enhancer.getClass().getName(), enhancer.getPrecedence()});
                this.droneEnhancementEvent.fire((Object)new BeforeDroneDeenhanced(enhancer, browser, type, qualifier));
                newBrowser = enhancer.deenhance(browser.asInstance(type), qualifier);
                browser.set(newBrowser);
                this.droneEnhancementEvent.fire((Object)new AfterDroneDeenhanced(browser, type, qualifier));
                continue;
            }
            if (!(candidate instanceof Enhancer) || !(enhancer = (Enhancer)candidate).canEnhance(type, qualifier)) continue;
            log.log(Level.WARNING, "Deprecated Enhancer type, please implement DroneInstanceEnhancer instead. Deenhancing {0} @{1} using enhancer {2} with precedence {3}", new Object[]{type.getSimpleName(), qualifier.getSimpleName(), enhancer.getClass().getName(), enhancer.getPrecedence()});
            this.droneEnhancementEvent.fire((Object)new BeforeDroneDeenhanced(new DeprecatedEnhancerWrap(enhancer), browser, type, qualifier));
            newBrowser = enhancer.deenhance(browser.asInstance(type), qualifier);
            browser.set(newBrowser);
            this.droneEnhancementEvent.fire((Object)new AfterDroneDeenhanced(browser, type, qualifier));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Deprecated
    private static class DeprecatedEnhancerWrap<T>
    implements DroneInstanceEnhancer<T> {
        private final Enhancer<T> deprecated;

        public DeprecatedEnhancerWrap(Enhancer<T> deprecated) {
            this.deprecated = deprecated;
        }

        public int getPrecedence() {
            return this.deprecated.getPrecedence();
        }

        public boolean canEnhance(InstanceOrCallableInstance instance, Class<?> droneType, Class<? extends Annotation> qualifier) {
            return this.deprecated.canEnhance(droneType, qualifier);
        }

        public T enhance(T instance, Class<? extends Annotation> qualifier) {
            return (T)this.deprecated.enhance(instance, qualifier);
        }

        public T deenhance(T enhancedInstance, Class<? extends Annotation> qualifier) {
            return (T)this.deprecated.deenhance(enhancedInstance, qualifier);
        }
    }
}

