/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.drone.impl;

import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.core.spi.ServiceLoader;
import org.jboss.arquillian.drone.impl.InstanceOrCallableInstanceImpl;
import org.jboss.arquillian.drone.spi.DroneConfiguration;
import org.jboss.arquillian.drone.spi.DroneContext;
import org.jboss.arquillian.drone.spi.DroneRegistry;
import org.jboss.arquillian.drone.spi.InstanceOrCallableInstance;
import org.jboss.arquillian.drone.spi.Instantiator;
import org.jboss.arquillian.drone.spi.event.AfterDroneCallableCreated;
import org.jboss.arquillian.drone.spi.event.AfterDroneConfigured;
import org.jboss.arquillian.drone.spi.event.BeforeDroneCallableCreated;
import org.jboss.arquillian.drone.spi.event.DroneLifecycleEvent;

public class DroneCallableCreator {
    private static final Logger log = Logger.getLogger(DroneCallableCreator.class.getName());
    @Inject
    private Instance<ServiceLoader> serviceLoader;
    @Inject
    private Event<DroneLifecycleEvent> droneLifeCycleEvent;

    public void createDroneCallable(@Observes AfterDroneConfigured event, DroneRegistry registry, DroneContext droneContext) {
        Class type = event.getDroneType();
        Class qualifier = event.getQualifier();
        final DroneConfiguration configuration = (DroneConfiguration)event.getConfiguration().asInstance(DroneConfiguration.class);
        final Instantiator instantiator = (Instantiator)registry.getEntryFor(type, Instantiator.class);
        if (log.isLoggable(Level.FINE)) {
            log.fine("Using instantiator defined in class: " + instantiator.getClass().getName() + ", with precedence " + instantiator.getPrecedence());
        }
        this.droneLifeCycleEvent.fire((Object)new BeforeDroneCallableCreated(instantiator, type, qualifier));
        Callable<Object> instanceCallable = new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return instantiator.createInstance(configuration);
            }
        };
        InstanceOrCallableInstanceImpl futureDrone = new InstanceOrCallableInstanceImpl(instanceCallable);
        droneContext.add(type, qualifier, (InstanceOrCallableInstance)futureDrone);
        this.droneLifeCycleEvent.fire((Object)new AfterDroneCallableCreated((InstanceOrCallableInstance)futureDrone, type, qualifier));
    }
}

