/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.drone.impl;

import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.arquillian.drone.spi.DroneContext;
import org.jboss.arquillian.drone.spi.InstanceOrCallableInstance;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DroneContextImpl
implements DroneContext {
    private final Map<QualifiedKey, DroneInstanceContext> cache = new ConcurrentHashMap<QualifiedKey, DroneInstanceContext>();

    public InstanceOrCallableInstance get(Class<?> key, Class<? extends Annotation> qualifier) {
        DroneInstanceContext context = this.cache.get(new QualifiedKey(key, qualifier));
        if (context == null) {
            return null;
        }
        if (context.isEmpty()) {
            throw new IllegalStateException("Unable to retrieve Drone instance, it was not initialized yet");
        }
        return context.peek();
    }

    public DroneContext add(Class<?> key, Class<? extends Annotation> qualifier, InstanceOrCallableInstance instance) {
        QualifiedKey k = new QualifiedKey(key, qualifier);
        DroneInstanceContext context = this.cache.get(k);
        if (context == null) {
            context = new DroneInstanceContext();
            this.cache.put(k, context);
        }
        context.push(instance);
        return this;
    }

    public DroneContext remove(Class<?> key, Class<? extends Annotation> qualifier) {
        QualifiedKey k = new QualifiedKey(key, qualifier);
        DroneInstanceContext context = this.cache.get(k);
        if (context == null) {
            return this;
        }
        context.pop();
        if (context.isEmpty()) {
            this.cache.remove(k);
        }
        return this;
    }

    static class DroneInstanceContext {
        private final Stack<InstanceOrCallableInstance> stack = new Stack();

        public DroneInstanceContext push(InstanceOrCallableInstance object) {
            this.stack.push(object);
            return this;
        }

        public InstanceOrCallableInstance peek() {
            if (this.isEmpty()) {
                throw new IllegalStateException("Unable to retrieve Drone instance, it was not initialized yet");
            }
            return this.stack.peek();
        }

        public InstanceOrCallableInstance pop() {
            if (this.isEmpty()) {
                throw new IllegalStateException("Unable to retrieve Drone instance, it was not initialized yet");
            }
            return this.stack.pop();
        }

        public boolean isEmpty() {
            return this.stack.isEmpty();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class QualifiedKey {
        private final Class<?> key;
        private final Class<? extends Annotation> qualifier;

        public QualifiedKey(Class<?> key, Class<? extends Annotation> qualifier) {
            this.key = key;
            this.qualifier = qualifier;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.qualifier == null ? 0 : this.qualifier.hashCode());
            result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            QualifiedKey other = (QualifiedKey)obj;
            if (this.qualifier == null ? other.qualifier != null : !this.qualifier.equals(other.qualifier)) {
                return false;
            }
            return !(this.key == null ? other.key != null : !this.key.equals(other.key));
        }

        public String toString() {
            return this.key.getName() + "/" + this.qualifier.getSimpleName();
        }
    }
}

