/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.drone.impl;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.jboss.arquillian.core.api.Injector;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.ApplicationScoped;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.core.api.event.ManagerStopping;
import org.jboss.arquillian.core.spi.context.ApplicationContext;
import org.jboss.arquillian.core.spi.context.IdBoundContext;
import org.jboss.arquillian.core.spi.context.NonIdBoundContext;
import org.jboss.arquillian.drone.spi.DroneRegistry;
import org.jboss.arquillian.test.spi.context.ClassContext;
import org.jboss.arquillian.test.spi.context.SuiteContext;
import org.jboss.arquillian.test.spi.context.TestContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DroneExecutorService {
    @Inject
    @ApplicationScoped
    private InstanceProducer<DroneExecutorService> serviceProducer;
    private ExecutorService executorService;

    private void register(@Observes DroneRegistry registry, Injector injector) {
        this.executorService = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new ContextualThreadFactory((ContextHolder)injector.inject((Object)new ContextHolder())), new ThreadPoolExecutor.CallerRunsPolicy());
        this.serviceProducer.set((Object)this);
    }

    private void shutdown(@Observes ManagerStopping event) {
        if (this.executorService != null) {
            this.executorService.shutdownNow();
        }
    }

    public <T> Future<T> submit(Callable<T> task) {
        return this.executorService.submit(task);
    }

    public <T> Future<T> submit(Runnable task, T result) {
        return this.executorService.submit(task, result);
    }

    public Future<?> submit(Runnable task) {
        return this.executorService.submit(task);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ContextHolder {
        @Inject
        private Instance<ApplicationContext> applicationContextInst;
        private ApplicationContext applicationContext;
        private Object applicationContextActive;
        @Inject
        private Instance<SuiteContext> suiteContextInst;
        private SuiteContext suiteContext;
        private Object suiteContextActive;
        @Inject
        private Instance<ClassContext> classContextInst;
        private ClassContext classContext;
        private Class<?> classContextId;
        @Inject
        private Instance<TestContext> testContextInst;
        private TestContext testContext;
        private Object testContextId;

        private ContextHolder() {
        }

        public void setState() {
            this.applicationContext = (ApplicationContext)this.applicationContextInst.get();
            this.applicationContextActive = this.applicationContext.isActive() ? "" : null;
            this.suiteContext = (SuiteContext)this.suiteContextInst.get();
            this.suiteContextActive = this.suiteContext.isActive() ? "" : null;
            this.classContext = (ClassContext)this.classContextInst.get();
            this.classContextId = (Class)this.classContext.getActiveId();
            this.testContext = (TestContext)this.testContextInst.get();
            this.testContextId = this.testContext.getActiveId();
        }

        public void activate() {
            this.activateIfPreviouslyActive((NonIdBoundContext)this.applicationContext, this.applicationContextActive);
            this.activateIfPreviouslyActive((NonIdBoundContext)this.suiteContext, this.suiteContextActive);
            this.activateIfPreviouslyActive((IdBoundContext)this.classContext, (Object)this.classContextId);
            this.activateIfPreviouslyActive((IdBoundContext)this.testContext, (Object)this.testContextId);
        }

        public void deactivate() {
            this.deactivateIfActive((IdBoundContext<?>)this.testContext);
            this.deactivateIfActive((IdBoundContext<?>)this.classContext);
            this.deactivateIfActive((NonIdBoundContext)this.suiteContext);
            this.deactivateIfActive((NonIdBoundContext)this.applicationContext);
        }

        private <T> void activateIfPreviouslyActive(IdBoundContext<T> context, T id) {
            if (id != null) {
                context.activate(id);
            }
        }

        private void activateIfPreviouslyActive(NonIdBoundContext context, Object id) {
            if (id != null) {
                context.activate();
            }
        }

        private void deactivateIfActive(IdBoundContext<?> context) {
            if (context.isActive()) {
                context.deactivate();
            }
        }

        private void deactivateIfActive(NonIdBoundContext context) {
            if (context.isActive()) {
                context.deactivate();
            }
        }
    }

    private class ContextualRunnable
    implements Runnable {
        private Runnable delegate;
        private ContextHolder holder;

        public ContextualRunnable(Runnable r, ContextHolder holder) {
            this.delegate = r;
            this.holder = holder;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                this.holder.activate();
                this.delegate.run();
            }
            finally {
                this.holder.deactivate();
            }
        }
    }

    private class ContextualThreadFactory
    implements ThreadFactory {
        private ThreadFactory delegate = Executors.defaultThreadFactory();
        private ContextHolder holder;

        public ContextualThreadFactory(ContextHolder holder) {
            this.holder = holder;
        }

        public Thread newThread(Runnable r) {
            this.holder.setState();
            return this.delegate.newThread(new ContextualRunnable(r, this.holder));
        }
    }
}

