/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.drone.impl;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.arquillian.config.descriptor.api.ArquillianDescriptor;
import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.drone.impl.CachingCallableImpl;
import org.jboss.arquillian.drone.impl.Validate;
import org.jboss.arquillian.drone.spi.CachingCallable;
import org.jboss.arquillian.drone.spi.Configurator;
import org.jboss.arquillian.drone.spi.DroneConfiguration;
import org.jboss.arquillian.drone.spi.DroneContext;
import org.jboss.arquillian.drone.spi.DroneRegistry;
import org.jboss.arquillian.drone.spi.InjectionPoint;
import org.jboss.arquillian.drone.spi.Instantiator;
import org.jboss.arquillian.drone.spi.command.PrepareDrone;
import org.jboss.arquillian.drone.spi.event.AfterDroneCallableCreated;
import org.jboss.arquillian.drone.spi.event.AfterDroneConfigured;
import org.jboss.arquillian.drone.spi.event.BeforeDroneCallableCreated;
import org.jboss.arquillian.drone.spi.event.BeforeDroneConfigured;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DroneConfigurator {
    private static Logger logger = Logger.getLogger(DroneConfigurator.class.getName());
    @Inject
    private Instance<DroneContext> droneContext;
    @Inject
    private Instance<ArquillianDescriptor> arquillianDescriptor;
    @Inject
    private Event<BeforeDroneConfigured> beforeDroneConfiguredEvent;
    @Inject
    private Event<AfterDroneConfigured> afterDroneConfiguredEvent;
    @Inject
    private Event<BeforeDroneCallableCreated> beforeDroneCallableCreatedEvent;
    @Inject
    private Event<AfterDroneCallableCreated> afterDroneCallableCreatedEvent;

    public void prepareDrone(@Observes PrepareDrone command, DroneRegistry registry) {
        InjectionPoint injectionPoint = command.getInjectionPoint();
        this.configureDrone(registry, injectionPoint);
        this.createDroneCallable(registry, injectionPoint);
    }

    private <DRONE> void configureDrone(DroneRegistry registry, InjectionPoint<DRONE> injectionPoint) {
        DroneConfiguration configuration;
        ArquillianDescriptor descriptor = (ArquillianDescriptor)this.arquillianDescriptor.get();
        DroneContext context = (DroneContext)this.droneContext.get();
        Validate.stateNotNull(descriptor, "ArquillianDescriptor should not be null", new Object[0]);
        Validate.stateNotNull(context, "DroneContext should be available while working with method scoped instances", new Object[0]);
        if (context.isDroneConfigurationStored(injectionPoint)) {
            logger.log(Level.WARNING, "Couldn''t configure drone for injection point {0}, because it was already configured!", injectionPoint);
            return;
        }
        Configurator configurator = (Configurator)registry.getEntryFor(injectionPoint.getDroneType(), Configurator.class);
        this.beforeDroneConfiguredEvent.fire((Object)new BeforeDroneConfigured(configurator, injectionPoint));
        if (!context.isDroneConfigurationStored(injectionPoint)) {
            configuration = configurator.createConfiguration(descriptor, injectionPoint);
            context.storeDroneConfiguration(injectionPoint, configuration);
        } else {
            configuration = context.getDroneConfiguration(injectionPoint, DroneConfiguration.class);
        }
        this.afterDroneConfiguredEvent.fire((Object)new AfterDroneConfigured(configuration, injectionPoint));
    }

    private <DRONE> void createDroneCallable(DroneRegistry registry, final InjectionPoint<DRONE> injectionPoint) {
        final DroneContext context = (DroneContext)this.droneContext.get();
        if (context.isFutureDroneStored(injectionPoint)) {
            logger.log(Level.WARNING, "Couldn''t create drone callable for injection point {0}, because it was already created!", injectionPoint);
            return;
        }
        final Instantiator instantiator = (Instantiator)registry.getEntryFor(injectionPoint.getDroneType(), Instantiator.class);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Using instantiator defined in class: " + instantiator.getClass().getName() + ", " + "with precedence " + instantiator.getPrecedence());
        }
        this.beforeDroneCallableCreatedEvent.fire((Object)new BeforeDroneCallableCreated(instantiator, injectionPoint));
        CachingCallableImpl futureDrone = new CachingCallableImpl<DRONE>(){

            @Override
            protected DRONE createInstance() throws Exception {
                DroneConfiguration configuration = context.getDroneConfiguration(injectionPoint, DroneConfiguration.class);
                return instantiator.createInstance(configuration);
            }
        };
        context.storeFutureDrone(injectionPoint, (CachingCallable)futureDrone);
        this.afterDroneCallableCreatedEvent.fire((Object)new AfterDroneCallableCreated(injectionPoint));
    }
}

